/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.core.mixins;

import com.lowdragmc.lowdraglib.networking.s2c.SPacketManagedPayload;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAsyncAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoPersistBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IAutoSyncBlockEntity;
import com.lowdragmc.lowdraglib.syncdata.blockentity.IManagedBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockEntity.class})
public abstract class BlockEntityMixin {
    @Inject(method={"getUpdateTag"}, at={@At(value="RETURN")})
    private void injectGetUpdateTag(CallbackInfoReturnable<CompoundTag> cir) {
        BlockEntityMixin blockEntityMixin = this;
        if (blockEntityMixin instanceof IAutoSyncBlockEntity) {
            IAutoSyncBlockEntity autoSyncBlockEntity = (IAutoSyncBlockEntity)((Object)blockEntityMixin);
            CompoundTag tag = (CompoundTag)cir.getReturnValue();
            tag.m_128365_(autoSyncBlockEntity.getSyncTag(), (Tag)SPacketManagedPayload.of(autoSyncBlockEntity, true).serializeNBT());
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN")})
    private void injectSaveAdditional(CompoundTag pTag, CallbackInfo ci) {
        BlockEntityMixin blockEntityMixin = this;
        if (blockEntityMixin instanceof IAutoPersistBlockEntity) {
            IAutoPersistBlockEntity autoPersistBlockEntity = (IAutoPersistBlockEntity)((Object)blockEntityMixin);
            autoPersistBlockEntity.saveManagedPersistentData(pTag, false);
        }
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void injectLoad(CompoundTag pTag, CallbackInfo ci) {
        IAutoSyncBlockEntity autoSyncBlockEntity;
        BlockEntityMixin blockEntityMixin = this;
        if (blockEntityMixin instanceof IAutoSyncBlockEntity && (blockEntityMixin = pTag.m_128423_((autoSyncBlockEntity = (IAutoSyncBlockEntity)((Object)blockEntityMixin)).getSyncTag())) instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)blockEntityMixin;
            new SPacketManagedPayload(tag).processPacket(autoSyncBlockEntity);
        } else {
            blockEntityMixin = this;
            if (blockEntityMixin instanceof IAutoPersistBlockEntity) {
                IAutoPersistBlockEntity autoPersistBlockEntity = (IAutoPersistBlockEntity)((Object)blockEntityMixin);
                autoPersistBlockEntity.loadManagedPersistentData(pTag);
            }
        }
    }

    @Inject(method={"setRemoved"}, at={@At(value="RETURN")})
    private void injectSetRemoved(CallbackInfo ci) {
        BlockEntityMixin blockEntityMixin = this;
        if (blockEntityMixin instanceof IAsyncAutoSyncBlockEntity) {
            IAsyncAutoSyncBlockEntity autoSyncBlockEntity = (IAsyncAutoSyncBlockEntity)((Object)blockEntityMixin);
            autoSyncBlockEntity.onInValid();
        }
    }

    @Inject(method={"clearRemoved"}, at={@At(value="RETURN")})
    private void injectClearRemoved(CallbackInfo ci) {
        BlockEntityMixin blockEntityMixin = this;
        if (blockEntityMixin instanceof IManagedBlockEntity) {
            IManagedBlockEntity managed = (IManagedBlockEntity)((Object)blockEntityMixin);
            managed.getRootStorage().init();
            if (managed instanceof IAsyncAutoSyncBlockEntity) {
                IAsyncAutoSyncBlockEntity autoSyncBlockEntity = (IAsyncAutoSyncBlockEntity)managed;
                autoSyncBlockEntity.onValid();
            }
        }
    }
}

