/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer.impl;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlock;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlockEntity;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegisterClient(name="json_model", group="renderer")
public class IModelRenderer
implements ISerializableRenderer {
    @Configurable(forceUpdate=false)
    protected ResourceLocation modelLocation;
    @OnlyIn(value=Dist.CLIENT)
    protected BakedModel itemModel;
    @Deprecated(forRemoval=true, since="1.21")
    @OnlyIn(value=Dist.CLIENT)
    protected Map<Direction, BakedModel> blockModels;
    @OnlyIn(value=Dist.CLIENT)
    protected Map<ModelState, BakedModel> modelCaches;

    protected IModelRenderer() {
        this.modelLocation = new ResourceLocation("block/furnace");
    }

    public IModelRenderer(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
        this.initRenderer();
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getParticleTexture() {
        BakedModel model = this.getItemBakedModel();
        if (model == null) {
            return ISerializableRenderer.super.getParticleTexture();
        }
        return model.m_6160_();
    }

    @OnlyIn(value=Dist.CLIENT)
    protected UnbakedModel getModel() {
        return ModelFactory.getUnBakedModel(this.modelLocation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        IItemRendererProvider.disabled.set(true);
        model = this.getItemBakedModel(stack);
        if (model != null) {
            Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
        }
        IItemRendererProvider.disabled.set(false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        BakedModel model = this.getItemBakedModel(stack);
        if (model != null) {
            return model.m_7547_();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean useAO() {
        BakedModel model = this.getItemBakedModel();
        if (model != null) {
            return model.m_7541_();
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        BakedModel ibakedmodel = this.getBlockBakedModel(level, pos, state);
        if (ibakedmodel == null) {
            return Collections.emptyList();
        }
        return ibakedmodel.m_213637_(state, side, rand);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected BakedModel getItemBakedModel() {
        if (this.itemModel == null) {
            BlockModel blockModel;
            UnbakedModel model = this.getModel();
            if (model instanceof BlockModel && (blockModel = (BlockModel)model).m_111490_() == ModelBakery.f_119232_) {
                model = ModelFactory.ITEM_MODEL_GENERATOR.m_111670_(this::materialMapping, blockModel);
            }
            this.itemModel = model.m_7611_(ModelFactory.getModeBaker(), this::materialMapping, (ModelState)BlockModelRotation.X0_Y0, this.modelLocation);
        }
        return this.itemModel;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected BakedModel getItemBakedModel(ItemStack itemStack) {
        return this.getItemBakedModel();
    }

    @Nullable
    @Deprecated(forRemoval=true, since="1.21")
    @OnlyIn(value=Dist.CLIENT)
    protected BakedModel getBlockBakedModel(@Nullable BlockPos pos, @Nullable BlockAndTintGetter level) {
        return this.getRotatedModel(Direction.NORTH);
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    protected BakedModel getBlockBakedModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state) {
        IBlockRendererProvider provider;
        ModelState modelState;
        Block block;
        if (level != null && pos != null && state != null && (block = state.m_60734_()) instanceof IBlockRendererProvider && (modelState = (provider = (IBlockRendererProvider)block).getModelState(level, pos, state)) != null) {
            return this.modelCaches.computeIfAbsent(modelState, facing -> this.getModel().m_7611_(ModelFactory.getModeBaker(), this::materialMapping, modelState, this.modelLocation));
        }
        return this.getBlockBakedModel(pos, level);
    }

    @Deprecated(forRemoval=true, since="1.21")
    @OnlyIn(value=Dist.CLIENT)
    public BakedModel getRotatedModel(Direction frontFacing) {
        return this.blockModels.computeIfAbsent(frontFacing, facing -> this.getModel().m_7611_(ModelFactory.getModeBaker(), this::materialMapping, ModelFactory.getRotation(facing), this.modelLocation));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected TextureAtlasSprite materialMapping(Material material) {
        return material.m_119204_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            this.itemModel = null;
            this.blockModels.clear();
            this.modelCaches.clear();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onAdditionalModel(Consumer<ResourceLocation> registry) {
        registry.accept(this.modelLocation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean isGui3d() {
        BakedModel model = this.getItemBakedModel();
        if (model == null) {
            return ISerializableRenderer.super.isGui3d();
        }
        return model.m_7539_();
    }

    @Override
    public void initRenderer() {
        if (this.modelLocation != null && LDLib.isClient()) {
            this.blockModels = new ConcurrentHashMap<Direction, BakedModel>();
            this.modelCaches = new ConcurrentHashMap<ModelState, BakedModel>();
            this.registerEvent();
        }
    }

    @ConfigSetter(field="modelLocation")
    public void updateModelWithoutReloadingResource(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
        if (LDLib.isClient()) {
            this.itemModel = null;
            if (this.blockModels != null) {
                this.blockModels.clear();
            }
            if (this.modelCaches != null) {
                this.modelCaches.clear();
            }
        }
    }

    @Override
    public void createPreview(ConfiguratorGroup father) {
        WidgetGroup preview = new WidgetGroup(0, 0, 100, 120);
        TrackedDummyWorld level = new TrackedDummyWorld();
        level.addBlock(BlockPos.f_121853_, BlockInfo.fromBlock(RendererBlock.BLOCK));
        Optional.ofNullable(level.m_7702_(BlockPos.f_121853_)).ifPresent(blockEntity -> {
            if (blockEntity instanceof RendererBlockEntity) {
                RendererBlockEntity holder = (RendererBlockEntity)((Object)blockEntity);
                holder.setRenderer(this);
            }
        });
        SceneWidget sceneWidget = new SceneWidget(0, 0, 100, 100, level);
        sceneWidget.setRenderFacing(false);
        sceneWidget.setRenderSelect(false);
        sceneWidget.createScene(level);
        sceneWidget.getRenderer().setOnLookingAt(null);
        sceneWidget.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        sceneWidget.setBackground(new ColorBorderTexture(2, ColorPattern.T_WHITE.color));
        preview.addWidget(new ButtonWidget(5, 110, 90, 10, new GuiTextureGroup(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new TextTexture("ldlib.gui.editor.tips.select_model")), cd -> {
            if (Editor.INSTANCE == null) {
                return;
            }
            File path = new File(Editor.INSTANCE.getWorkSpace(), "models");
            DialogWidget.showFileDialog(Editor.INSTANCE, "ldlib.gui.editor.tips.select_model", path, true, DialogWidget.suffixFilter(".json"), r -> {
                if (r != null && r.isFile()) {
                    this.updateModelWithoutReloadingResource(IModelRenderer.getModelFromFile(path, r));
                }
            });
        }));
        preview.addWidget(sceneWidget);
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview", preview));
    }

    private static ResourceLocation getModelFromFile(File path, File r) {
        String id = path.getPath().replace('\\', '/').split("assets/")[1].split("/")[0];
        return new ResourceLocation(id, r.getPath().replace(path.getPath(), "").replace(".json", "").replace('\\', '/'));
    }

    public ResourceLocation getModelLocation() {
        return this.modelLocation;
    }
}

