/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.renderer;

import com.lowdragmc.lowdraglib.client.renderer.IBlockRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class ATESRRendererProvider<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    public ATESRRendererProvider() {
    }

    public ATESRRendererProvider(BlockEntityRendererProvider.Context ctx) {
    }

    public int m_142163_() {
        return super.m_142163_();
    }

    public boolean m_142756_(T pBlockEntity, Vec3 pCameraPos) {
        IRenderer renderer = this.getRenderer(pBlockEntity);
        if (renderer != null) {
            return renderer.shouldRender((BlockEntity)pBlockEntity, pCameraPos);
        }
        return super.m_142756_(pBlockEntity, pCameraPos);
    }

    public void m_6922_(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        IRenderer renderer = this.getRenderer(pBlockEntity);
        if (renderer != null && !renderer.isRaw()) {
            renderer.render((BlockEntity)pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
        }
    }

    @Nullable
    public IRenderer getRenderer(@Nonnull T tileEntity) {
        BlockState state;
        Block block;
        Level world = tileEntity.m_58904_();
        if (world != null && (block = (state = tileEntity.m_58900_()).m_60734_()) instanceof IBlockRendererProvider) {
            IBlockRendererProvider blockRendererProvider = (IBlockRendererProvider)block;
            return blockRendererProvider.getRenderer(state);
        }
        return null;
    }

    public boolean hasRenderer(T tileEntity) {
        IRenderer renderer = this.getRenderer(tileEntity);
        return renderer != null && renderer.hasTESR((BlockEntity)tileEntity);
    }

    public boolean m_5932_(@Nonnull T tileEntity) {
        IRenderer renderer = this.getRenderer(tileEntity);
        if (renderer != null) {
            return renderer.isGlobalRenderer((BlockEntity)tileEntity);
        }
        return false;
    }
}

