/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.async.IAsyncLogic;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AsyncThreadData
extends SavedData {
    private final ServerLevel serverLevel;
    private final CopyOnWriteArrayList<IAsyncLogic> asyncLogics = new CopyOnWriteArrayList();
    private ScheduledExecutorService executorService;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("LDLib Async Thread-%d").setDaemon(true).build();
    private static final ThreadLocal<Boolean> IN_SERVICE = ThreadLocal.withInitial(() -> false);
    private long periodID = Long.MIN_VALUE;

    public static AsyncThreadData getOrCreate(ServerLevel serverLevel) {
        return (AsyncThreadData)serverLevel.m_8895_().m_164861_(tag -> new AsyncThreadData(serverLevel, (CompoundTag)tag), () -> new AsyncThreadData(serverLevel), "ldlib");
    }

    private AsyncThreadData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
    }

    private AsyncThreadData(ServerLevel serverLevel, CompoundTag compoundTag) {
        this(serverLevel);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        return compoundTag;
    }

    public void createExecutorService() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            return;
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
        this.executorService.scheduleAtFixedRate(this::searchingTask, 0L, 50L, TimeUnit.MILLISECONDS);
    }

    public void addAsyncLogic(IAsyncLogic logic) {
        this.asyncLogics.add(logic);
        this.createExecutorService();
    }

    public void removeAsyncLogic(IAsyncLogic logic) {
        this.asyncLogics.remove(logic);
        if (this.asyncLogics.isEmpty()) {
            this.releaseExecutorService();
        }
    }

    private void searchingTask() {
        try {
            if (this.serverLevel.m_7654_().m_195518_()) {
                return;
            }
            IN_SERVICE.set(true);
            for (IAsyncLogic logic : this.asyncLogics) {
                logic.asyncTick(this.periodID);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            LDLib.LOGGER.error("asyncThreadLogic error: {}", (Object)e.getMessage());
        }
        finally {
            IN_SERVICE.set(false);
        }
        ++this.periodID;
    }

    public static boolean isThreadService() {
        return IN_SERVICE.get();
    }

    public void releaseExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
    }

    public long getPeriodID() {
        return this.periodID;
    }
}

