/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib;

import com.lowdragmc.lowdraglib.gui.factory.UIEditorFactory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ServerCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> createServerCommands() {
        return List.of((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ldlib").then(Commands.m_82127_((String)"ui_editor").executes(context -> {
            UIEditorFactory.INSTANCE.openUI(UIEditorFactory.INSTANCE, ((CommandSourceStack)context.getSource()).m_81375_());
            return 1;
        }))).then(Commands.m_82127_((String)"copy_block_tag").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            BlockPos pos = BlockPosArgument.m_118242_((CommandContext)context, (String)"pos");
            ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity != null) {
                CompoundTag tag = blockEntity.m_187482_();
                String value = NbtUtils.m_178063_((CompoundTag)tag);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"[Copy to clipboard]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value))).m_7220_(NbtUtils.m_178061_((Tag)tag)), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("No block entity at " + pos)).m_130948_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
            }
            return 1;
        })))).then(Commands.m_82127_((String)"copy_entity_tag").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            Entity entity = EntityArgument.m_91452_((CommandContext)context, (String)"entity");
            CompoundTag tag = entity.m_20240_(new CompoundTag());
            String value = NbtUtils.m_178063_((CompoundTag)tag);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"[Copy to clipboard]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, value))).m_7220_(NbtUtils.m_178061_((Tag)tag)), true);
            return 1;
        }))), (LiteralArgumentBuilder)Commands.m_82127_((String)"compass_server").then(Commands.m_82127_((String)"build_scene").then(Commands.m_82129_((String)"start", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"end", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> ServerCommands.runBuildScene((CommandContext<CommandSourceStack>)context, false, new BlockPos(0, 0, 0)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"saveNbt", (ArgumentType)BoolArgumentType.bool()).executes(context -> ServerCommands.runBuildScene((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"saveNbt"), new BlockPos(0, 0, 0)))).then(Commands.m_82129_((String)"offset", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> ServerCommands.runBuildScene((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"saveNbt"), BlockPosArgument.m_264582_((CommandContext)context, (String)"offset")))))))));
    }

    public static int runBuildScene(CommandContext<CommandSourceStack> context, boolean saveNbt, BlockPos offset) {
        BlockPos start = BlockPosArgument.m_264582_(context, (String)"start");
        BlockPos end = BlockPosArgument.m_264582_(context, (String)"end");
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        int smallestX = start.m_123341_() <= end.m_123341_() ? start.m_123341_() : end.m_123341_();
        int smallestY = start.m_123342_() <= end.m_123342_() ? start.m_123342_() : end.m_123342_();
        int smallestZ = start.m_123343_() <= end.m_123343_() ? start.m_123343_() : end.m_123343_();
        int largestX = start.m_123341_() >= end.m_123341_() ? start.m_123341_() : end.m_123341_();
        int largestY = start.m_123342_() >= end.m_123342_() ? start.m_123342_() : end.m_123342_();
        int largestZ = start.m_123343_() >= end.m_123343_() ? start.m_123343_() : end.m_123343_();
        int offsetX = -((largestX - smallestX) / 2) + offset.m_123341_();
        int offsetY = offset.m_123342_();
        int offsetZ = -((largestZ - smallestZ) / 2) + offset.m_123343_();
        ArrayList<String> nodes = new ArrayList<String>();
        for (int x = smallestX; x <= largestX; ++x) {
            for (int y = smallestY; y <= largestY; ++y) {
                for (int z = smallestZ; z <= largestZ; ++z) {
                    BlockState block = world.m_8055_(new BlockPos(x, y, z));
                    BlockEntity blockentity = world.m_7702_(new BlockPos(x, y, z));
                    if (block.m_60734_() == Blocks.f_50016_) continue;
                    String id = BuiltInRegistries.f_256975_.m_7981_((Object)block.m_60734_()).toString();
                    nodes.add(String.format("<add pos=\"%d %d %d\" block=\"%s\">", x - smallestX + offsetX, y - smallestY + offsetY, z - smallestZ + offsetZ, id));
                    nodes.addAll(block.m_61148_().entrySet().stream().map(e -> String.format("<properties name=\"%s\" value=\"%s\" />", ((Property)e.getKey()).m_61708_(), ((Comparable)e.getValue()).toString())).collect(Collectors.toList()));
                    if (saveNbt && blockentity != null) {
                        CompoundTag tag = blockentity.m_187482_();
                        nodes.add("<nbt>");
                        nodes.add(NbtUtils.m_178061_((Tag)tag).getString());
                        nodes.add("</nbt>");
                    }
                    nodes.add("</add>");
                }
            }
        }
        String text = nodes.stream().collect(Collectors.joining("\n"));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"[Copy XML to clipboard]").m_130948_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text))), true);
        return 1;
    }
}

