/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.kube.recipe;

import com.almostreliable.kubeio.kube.KubePlugin;
import com.almostreliable.kubeio.mixin.accessor.IngredientAccessor;
import com.almostreliable.kubeio.mixin.accessor.TagValueAccessor;
import com.enderio.core.common.recipes.CountedIngredient;
import com.enderio.machines.common.recipe.SagMillingRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public interface RecipeComponents {
    public static final RecipeComponent<CountedIngredient> COUNTED_INGREDIENT = new RecipeComponent<CountedIngredient>(){

        public Class<?> componentClass() {
            return CountedIngredient.class;
        }

        public String componentType() {
            return "counted_ingredient";
        }

        public JsonElement write(RecipeJS recipe, CountedIngredient value) {
            return value.toJson();
        }

        public CountedIngredient read(RecipeJS recipe, Object from) {
            return KubePlugin.wrapCountedIngredient(from);
        }

        public boolean isInput(RecipeJS recipe, CountedIngredient value, ReplacementMatch match) {
            return true;
        }
    };
    public static final RecipeComponent<CountedIngredient[]> COUNTED_INGREDIENT_ARRAY = COUNTED_INGREDIENT.asArray();
    public static final RecipeComponent<SagMillingRecipe.OutputItem> OUTPUT_ITEM = new RecipeComponent<SagMillingRecipe.OutputItem>(){

        public Class<?> componentClass() {
            return SagMillingRecipe.OutputItem.class;
        }

        public String componentType() {
            return "output_item";
        }

        public JsonElement write(RecipeJS recipe, SagMillingRecipe.OutputItem value) {
            JsonObject jsonObject = new JsonObject();
            if (value.isTag()) {
                jsonObject.addProperty("tag", Objects.requireNonNull(value.getTag()).f_203868_().toString());
            } else {
                jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)value.getItem())).toString());
            }
            if (value.getCount() != 1) {
                jsonObject.addProperty("count", (Number)value.getCount());
            }
            if (value.getChance() < 1.0f) {
                jsonObject.addProperty("chance", (Number)Float.valueOf(value.getChance()));
            }
            if (value.isOptional()) {
                jsonObject.addProperty("optional", Boolean.valueOf(value.isOptional()));
            }
            return jsonObject;
        }

        public SagMillingRecipe.OutputItem read(RecipeJS recipe, Object from) {
            int count;
            if (from instanceof SagMillingRecipe.OutputItem) {
                SagMillingRecipe.OutputItem outputItem = (SagMillingRecipe.OutputItem)from;
                return outputItem;
            }
            if (from instanceof Ingredient || from instanceof InputItem || from instanceof String) {
                InputItem inputItem = InputItem.of((Object)from);
                count = inputItem.count;
                Ingredient.Value[] ingredientValues = ((IngredientAccessor)inputItem.ingredient).kubeio$getValues();
                if (ingredientValues.length > 1) {
                    throw new IllegalArgumentException("Input item has more than one value");
                }
                Ingredient.Value ingredientValue = ingredientValues[0];
                if (ingredientValue instanceof Ingredient.TagValue) {
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)ingredientValue;
                    TagKey<Item> tag = ((TagValueAccessor)tagValue).kubeio$getTag();
                    return SagMillingRecipe.OutputItem.of(tag, (int)count, (float)1.0f, (boolean)false);
                }
                if (ingredientValue instanceof Ingredient.ItemValue) {
                    Ingredient.ItemValue itemValue = (Ingredient.ItemValue)ingredientValue;
                    Collection items = itemValue.m_6223_();
                    if (items.size() > 1) {
                        throw new IllegalArgumentException("Input item has more than one item");
                    }
                    return SagMillingRecipe.OutputItem.of((Item)((ItemStack)items.iterator().next()).m_41720_(), (int)count, (float)1.0f, (boolean)false);
                }
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                count = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"count", (int)1);
                float chance = GsonHelper.m_13820_((JsonObject)jsonObject, (String)"chance", (float)1.0f);
                boolean optional = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"optional", (boolean)false);
                if (jsonObject.has("tag")) {
                    ResourceLocation id = new ResourceLocation(jsonObject.get("tag").getAsString());
                    TagKey tag = ItemTags.create((ResourceLocation)id);
                    return SagMillingRecipe.OutputItem.of((TagKey)tag, (int)count, (float)chance, (boolean)optional);
                }
                if (jsonObject.has("item")) {
                    ResourceLocation id = new ResourceLocation(jsonObject.get("item").getAsString());
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                    if (!optional && item == null) {
                        throw new IllegalArgumentException("Recipe is missing a required output item");
                    }
                    return SagMillingRecipe.OutputItem.of((Item)item, (int)count, (float)chance, (boolean)optional);
                }
                throw new IllegalArgumentException("Invalid output item: " + jsonObject);
            }
            OutputItem outputItem = OutputItem.of((Object)from);
            float chance = Double.isNaN(outputItem.getChance()) ? 1.0f : (float)outputItem.getChance();
            chance = Mth.m_14036_((float)chance, (float)0.0f, (float)1.0f);
            return SagMillingRecipe.OutputItem.of((Item)outputItem.item.m_41720_(), (int)outputItem.getCount(), (float)chance, (boolean)false);
        }

        public boolean isOutput(RecipeJS recipe, SagMillingRecipe.OutputItem value, ReplacementMatch match) {
            return true;
        }
    };
    public static final RecipeComponent<SagMillingRecipe.OutputItem[]> OUTPUT_ITEM_ARRAY = OUTPUT_ITEM.asArray();
    public static final RecipeComponent<Item> ITEM = new RecipeComponent<Item>(){

        public Class<?> componentClass() {
            return Item.class;
        }

        public String componentType() {
            return "item";
        }

        public JsonElement write(RecipeJS recipe, Item value) {
            return new JsonPrimitive(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)value)).toString());
        }

        public Item read(RecipeJS recipe, Object from) {
            OutputItem outputItem = OutputItem.of((Object)from);
            return outputItem.item.m_41720_();
        }

        public boolean isOutput(RecipeJS recipe, Item value, ReplacementMatch match) {
            return true;
        }
    };
    public static final RecipeComponent<Either<Block, TagKey<Block>>> BLOCK_OR_TAG = new RecipeComponent<Either<Block, TagKey<Block>>>(){

        public Class<?> componentClass() {
            return Either.class;
        }

        public String componentType() {
            return "block_or_tag";
        }

        public JsonElement write(RecipeJS recipe, Either<Block, TagKey<Block>> value) {
            JsonObject jsonObject = new JsonObject();
            value.left().ifPresent(block -> {
                ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey(block);
                jsonObject.addProperty("block", Objects.requireNonNull(blockId).toString());
            });
            value.right().ifPresent(tag -> jsonObject.addProperty("tag", tag.f_203868_().toString()));
            return jsonObject;
        }

        public Either<Block, TagKey<Block>> read(RecipeJS recipe, Object from) {
            if (from instanceof BlockIDPredicate) {
                BlockIDPredicate blockPredicate = (BlockIDPredicate)from;
                return this.read(recipe, blockPredicate.getBlockState());
            }
            if (from instanceof BlockState) {
                BlockState blockState = (BlockState)from;
                return this.read(recipe, blockState.m_60734_());
            }
            if (from instanceof Block) {
                Block block = (Block)from;
                return Either.left((Object)block);
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                if (jsonObject.has("block")) {
                    String id = jsonObject.get("block").getAsString();
                    Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
                    if (block == null) {
                        throw new IllegalArgumentException("Unknown block: " + id);
                    }
                    return Either.left((Object)block);
                }
                if (jsonObject.has("tag")) {
                    String id = jsonObject.get("tag").getAsString();
                    TagKey tag = BlockTags.create((ResourceLocation)new ResourceLocation(id));
                    return Either.right((Object)tag);
                }
                throw new IllegalArgumentException("Invalid block or block tag: " + jsonObject);
            }
            if (from instanceof String) {
                String id = (String)from;
                if (id.startsWith("#")) {
                    TagKey tag = BlockTags.create((ResourceLocation)new ResourceLocation(id.substring(1)));
                    return Either.right((Object)tag);
                }
                BlockState state = UtilsJS.parseBlockState((String)id);
                if (state == null || state.m_60795_()) {
                    throw new IllegalArgumentException("Unknown block: " + id);
                }
                return Either.left((Object)state.m_60734_());
            }
            throw new IllegalArgumentException("Invalid block or block tag: " + from);
        }
    };
    public static final RecipeComponent<Either<Block, TagKey<Block>>[]> BLOCK_OR_TAG_ARRAY = BLOCK_OR_TAG.asArray();
    public static final RecipeComponent<Enchantment> ENCHANTMENT = new RecipeComponent<Enchantment>(){

        public Class<?> componentClass() {
            return Enchantment.class;
        }

        public String componentType() {
            return "enchantment";
        }

        public JsonElement write(RecipeJS recipe, Enchantment value) {
            ResourceLocation enchantmentId = ForgeRegistries.ENCHANTMENTS.getKey((Object)value);
            return new JsonPrimitive(Objects.requireNonNull(enchantmentId).toString());
        }

        public Enchantment read(RecipeJS recipe, Object from) {
            if (from instanceof Enchantment) {
                Enchantment enchantment = (Enchantment)from;
                return enchantment;
            }
            if (from instanceof JsonPrimitive) {
                JsonPrimitive primitive = (JsonPrimitive)from;
                return this.read(recipe, primitive.getAsString());
            }
            if (from instanceof String) {
                String enchantmentId = (String)from;
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentId));
                if (enchantment == null) {
                    throw new IllegalArgumentException("Unknown enchantment: " + enchantmentId);
                }
                return enchantment;
            }
            throw new IllegalArgumentException("Invalid enchantment: " + from);
        }
    };
}

