/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.compat;

import com.almostreliable.kubeio.compat.JeiPlugin;
import com.almostreliable.kubeio.kube.recipe.RecipesBinding;
import com.enderio.machines.common.integrations.jei.category.AlloySmeltingCategory;
import com.enderio.machines.common.recipe.AlloySmeltingRecipe;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;

public final class JeiAdapter {
    private JeiAdapter() {
    }

    private static boolean isLoaded() {
        return ModList.get().isLoaded("jei");
    }

    public static void collectRecipeFilters(Set<ResourceLocation> filters) {
        if (!JeiAdapter.isLoaded()) {
            return;
        }
        Adapter.collectRecipeFilters(filters);
    }

    static final class Adapter {
        @Nullable
        private static Set<ResourceLocation> FILTERS;

        private Adapter() {
        }

        private static void collectRecipeFilters(Set<ResourceLocation> filters) {
            FILTERS = filters;
        }

        static void applyRecipeFilters() {
            if (RecipesBinding.FILTERED_SMELTING_RECIPES.isEmpty() && FILTERS == null) {
                return;
            }
            List<AlloySmeltingRecipe> recipesToHide = JeiPlugin.RUNTIME.getRecipeManager().createRecipeLookup(AlloySmeltingCategory.TYPE).get().filter(r -> {
                if (RecipesBinding.FILTERED_SMELTING_RECIPES.isEmpty()) {
                    assert (FILTERS != null);
                    return FILTERS.contains(r.m_6423_());
                }
                return RecipesBinding.FILTERED_SMELTING_RECIPES.contains(r.m_6423_());
            }).toList();
            JeiPlugin.RUNTIME.getRecipeManager().hideRecipes(AlloySmeltingCategory.TYPE, recipesToHide);
            JeiPlugin.RUNTIME = null;
            FILTERS = null;
        }
    }
}

