/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.bookmarks;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.gui.bookmarks.IBookmark;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.RecipeBookmarkElement;
import mezz.jei.gui.recipes.RecipeCategoryIconUtil;
import net.minecraft.resources.ResourceLocation;

public class RecipeBookmark<R, I>
implements IBookmark {
    private final IElement<I> element;
    private final IRecipeCategory<R> recipeCategory;
    private final R recipe;
    private final ResourceLocation recipeUid;
    private final ITypedIngredient<I> recipeOutput;
    private boolean visible = true;

    public static <T> Optional<RecipeBookmark<T, ?>> create(IRecipeLayoutDrawable<T> recipeLayoutDrawable, IIngredientManager ingredientManager, IRecipeManager recipeManager, IGuiHelper guiHelper) {
        T recipe = recipeLayoutDrawable.getRecipe();
        IRecipeCategory<T> recipeCategory = recipeLayoutDrawable.getRecipeCategory();
        ResourceLocation recipeUid = recipeCategory.getRegistryName(recipe);
        if (recipeUid == null) {
            return Optional.empty();
        }
        IRecipeSlotsView recipeSlotsView = recipeLayoutDrawable.getRecipeSlotsView();
        List<IRecipeSlotView> outputSlots = recipeSlotsView.getSlotViews(RecipeIngredientRole.OUTPUT);
        for (IRecipeSlotView slotView : outputSlots) {
            Optional<ITypedIngredient<?>> outputOptional = slotView.getAllIngredients().findFirst();
            if (outputOptional.isEmpty()) continue;
            ITypedIngredient<?> output = outputOptional.get();
            IDrawable icon = RecipeCategoryIconUtil.create(recipeCategory, recipeManager, guiHelper);
            output = ingredientManager.normalizeTypedIngredient(output);
            return Optional.of(new RecipeBookmark(recipeCategory, recipe, recipeUid, output, icon));
        }
        return Optional.empty();
    }

    public RecipeBookmark(IRecipeCategory<R> recipeCategory, R recipe, ResourceLocation recipeUid, ITypedIngredient<I> recipeOutput, IDrawable icon) {
        this.recipeCategory = recipeCategory;
        this.recipe = recipe;
        this.recipeUid = recipeUid;
        this.recipeOutput = recipeOutput;
        this.element = new RecipeBookmarkElement(this, icon);
    }

    public IRecipeCategory<R> getRecipeCategory() {
        return this.recipeCategory;
    }

    public ResourceLocation getRecipeUid() {
        return this.recipeUid;
    }

    public R getRecipe() {
        return this.recipe;
    }

    public ITypedIngredient<I> getRecipeOutput() {
        return this.recipeOutput;
    }

    @Override
    public IElement<?> getElement() {
        return this.element;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int hashCode() {
        return this.recipeUid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RecipeBookmark) {
            RecipeBookmark recipeBookmark = (RecipeBookmark)obj;
            return recipeBookmark.recipeUid.equals((Object)this.recipeUid);
        }
        return false;
    }
}

