/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.ichun.mods.ichunutil.client.gui.bns.Theme;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.util.StringUtil;
import net.minecraft.resources.ResourceLocation;

public final class ResourceHelper {
    public static final ResourceLocation TEX_TAMED_WOLF = new ResourceLocation("textures/entity/wolf/wolf_tame.png");
    public static final ResourceLocation TEX_WOLF_COLLAR = new ResourceLocation("textures/entity/wolf/wolf_collar.png");
    public static final ResourceLocation TEX_PIG = new ResourceLocation("textures/entity/pig/pig.png");
    private static Path workingDir;
    private static Path themesDir;
    private static boolean init;

    public static void init() {
        if (!init) {
            init = true;
            try {
                Path defaultTheme;
                workingDir = iChunUtil.d().getConfigDir().resolve("ichunutil");
                if (!Files.exists(workingDir, new LinkOption[0])) {
                    Files.createDirectory(workingDir, new FileAttribute[0]);
                }
                if (!Files.exists(themesDir = workingDir.resolve("themes"), new LinkOption[0])) {
                    Files.createDirectory(themesDir, new FileAttribute[0]);
                }
                if (!Files.exists(defaultTheme = themesDir.resolve("default.json"), new LinkOption[0])) {
                    String jsonOutput = StringUtil.GSON_PRETTY.toJson((Object)new Theme());
                    try {
                        Files.writeString(defaultTheme, (CharSequence)jsonOutput, StandardCharsets.UTF_8, new OpenOption[0]);
                    }
                    catch (IOException e) {
                        iChunUtil.LOGGER.error("Error writing default theme to themes folder!", (Throwable)e);
                    }
                    InputStream in = iChunUtil.class.getResourceAsStream("/themes.zip");
                    if (in != null) {
                        ZipInputStream zipStream = new ZipInputStream(in);
                        ZipEntry entry = null;
                        while ((entry = zipStream.getNextEntry()) != null) {
                            int len;
                            File file = new File(themesDir.toFile(), entry.getName());
                            if (file.exists() && file.length() > 3L) continue;
                            FileOutputStream out = new FileOutputStream(file);
                            byte[] buffer = new byte[8192];
                            while ((len = zipStream.read(buffer)) != -1) {
                                out.write(buffer, 0, len);
                            }
                            out.close();
                        }
                        zipStream.close();
                    }
                }
                if (iChunUtil.d().isDevEnvironment() && iChunUtil.d().env().isFabric()) {
                    ResourceHelper.createFabricLoaderDependenciesOverride();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error initialising resources!", e);
            }
        }
    }

    private static void createFabricLoaderDependenciesOverride() throws IOException {
        Path file = iChunUtil.d().getConfigDir().resolve("fabric_loader_dependencies.json");
        if (!Files.exists(file, new LinkOption[0])) {
            LinkedHashMap<String, Serializable> json = new LinkedHashMap<String, Serializable>();
            json.put("version", Integer.valueOf(1));
            TreeMap modIdToDep = new TreeMap(Comparator.naturalOrder());
            json.put("overrides", modIdToDep);
            ArrayList<String> modsToOverride = new ArrayList<String>();
            modsToOverride.add("betterthanbunnies");
            modsToOverride.add("betterthanllamas");
            modsToOverride.add("deathcounter");
            modsToOverride.add("ding");
            modsToOverride.add("dogslie");
            modsToOverride.add("limitedlives");
            modsToOverride.add("partyparrots");
            modsToOverride.add("serverpause");
            for (String s : modsToOverride) {
                TreeMap depToDef = new TreeMap();
                modIdToDep.put(s, depToDef);
                TreeMap<String, String> def = new TreeMap<String, String>();
                depToDef.put("-depends", def);
                def.put("ichunutil", "IGNORED");
            }
            Files.writeString(file, (CharSequence)StringUtil.GSON_PRETTY.toJson(json), StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    public static Path getThemesDir() {
        return themesDir;
    }
}

