/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.capability.ElectricItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ToolItemHelper {
    public static final Map<GTToolType, ItemStack> TOOL_CACHE = new HashMap<GTToolType, ItemStack>();

    public static ItemStack getMaxChargeOverrideStack(Item item, long maxCharge) {
        ItemStack itemStack = item.m_7968_();
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
        if (electricItem == null) {
            throw new IllegalStateException("Not an electric item.");
        }
        if (!(electricItem instanceof ElectricItem)) {
            throw new IllegalStateException("Only standard ElectricItem implementation supported, but this item uses " + electricItem.getClass());
        }
        ((ElectricItem)electricItem).setMaxChargeOverride(maxCharge);
        return itemStack;
    }

    public static ItemStack getToolItem(GTToolType toolType) {
        return TOOL_CACHE.computeIfAbsent(toolType, type -> {
            if (type == GTToolType.SOFT_MALLET) {
                return ((ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)GTMaterials.Rubber, type)).asStack();
            }
            return ((ItemProviderEntry)GTItems.TOOL_ITEMS.get((Object)GTMaterials.Neutronium, type)).asStack();
        });
    }
}

