/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.rei.recipe;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeDisplay;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.rei.IGui2Renderer;
import com.lowdragmc.lowdraglib.rei.ModularUIDisplayCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.function.Function;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class GTRecipeREICategory
extends ModularUIDisplayCategory<GTRecipeDisplay> {
    public static final Function<GTRecipeCategory, CategoryIdentifier<GTRecipeDisplay>> CATEGORIES = Util.m_143827_(category -> CategoryIdentifier.of((ResourceLocation)category.getResourceLocation()));
    private final GTRecipeCategory category;
    private final Renderer icon;
    private final Size size;

    public GTRecipeREICategory(@NotNull GTRecipeCategory category) {
        this.category = category;
        GTRecipeType recipeType = category.getRecipeType();
        Size size = recipeType.getRecipeUI().getJEISize();
        this.size = new Size(size.width + 8, size.height + 8);
        Object object = category.getIcon();
        if (object instanceof ResourceTexture) {
            ResourceTexture tex = (ResourceTexture)object;
            this.icon = IGui2Renderer.toDrawable((IGuiTexture)tex);
        } else {
            this.icon = recipeType.getIconSupplier() != null ? IGui2Renderer.toDrawable((IGuiTexture)new ItemStackTexture(new ItemStack[]{recipeType.getIconSupplier().get()})) : IGui2Renderer.toDrawable((IGuiTexture)new ItemStackTexture(new ItemStack[]{Items.f_42127_.m_7968_()}));
        }
    }

    public CategoryIdentifier<? extends GTRecipeDisplay> getCategoryIdentifier() {
        return CATEGORIES.apply(this.category);
    }

    public int getDisplayHeight() {
        return this.getSize().height;
    }

    public int getDisplayWidth(GTRecipeDisplay display) {
        return this.getSize().width;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)this.category.getTranslation());
    }

    public static void registerDisplays(DisplayRegistry registry) {
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            GTRecipeType type = category.getRecipeType();
            if (type == GTRecipeTypes.FURNACE_RECIPES || !type.getRecipeUI().isXEIVisible() && !Platform.isDevEnv()) continue;
            registry.registerRecipeFiller(GTRecipe.class, (RecipeType)type, GTRecipeDisplay::new);
            type.getRepresentativeRecipes().stream().map(r -> new GTRecipeDisplay((GTRecipe)r, category)).forEach(arg_0 -> ((DisplayRegistry)registry).add(arg_0));
        }
    }

    public static void registerWorkStations(CategoryRegistry registry) {
        for (MachineDefinition machine : GTRegistries.MACHINES) {
            if (machine.getRecipeTypes() == null) continue;
            for (GTRecipeType type : machine.getRecipeTypes()) {
                if (type == null || !Platform.isDevEnv() && !type.getRecipeUI().isXEIVisible()) continue;
                for (GTRecipeCategory category : type.getRecipesByCategory().keySet()) {
                    registry.addWorkstations(CATEGORIES.apply(category), new EntryStack[]{EntryStacks.of((ItemStack)machine.asStack())});
                }
            }
        }
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public Size getSize() {
        return this.size;
    }
}

