/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jei.recipe;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeWrapper;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.jei.ModularUIRecipeCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeJEICategory
extends ModularUIRecipeCategory<GTRecipeWrapper> {
    public static final Function<GTRecipeCategory, RecipeType<GTRecipeWrapper>> TYPES = Util.m_143827_(category -> new RecipeType(category.getResourceLocation(), GTRecipeWrapper.class));
    private final GTRecipeCategory category;
    private final IDrawable background;
    private final IDrawable icon;

    public GTRecipeJEICategory(IJeiHelpers helpers, @NotNull GTRecipeCategory category) {
        this.category = category;
        GTRecipeType recipeType = category.getRecipeType();
        IGuiHelper guiHelper = helpers.getGuiHelper();
        Size size = recipeType.getRecipeUI().getJEISize();
        this.background = guiHelper.createBlankDrawable(size.width, size.height);
        Object icon1 = category.getIcon();
        if (icon1 instanceof ResourceTexture) {
            ResourceTexture tex = (ResourceTexture)icon1;
            this.icon = helpers.getGuiHelper().drawableBuilder(tex.imageLocation, 0, 0, (int)tex.imageWidth, (int)tex.imageHeight).setTextureSize(16, 16).build();
        } else {
            this.icon = recipeType.getIconSupplier() != null ? helpers.getGuiHelper().createDrawableItemStack(recipeType.getIconSupplier().get()) : helpers.getGuiHelper().createDrawableItemStack(Items.f_42127_.m_7968_());
        }
    }

    @NotNull
    public RecipeType<GTRecipeWrapper> getRecipeType() {
        return TYPES.apply(this.category);
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)this.category.getTranslation());
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            GTRecipeType type = category.getRecipeType();
            if (type == GTRecipeTypes.FURNACE_RECIPES || !type.getRecipeUI().isXEIVisible() && !Platform.isDevEnv()) continue;
            Stream recipes = type.getCategoryMap().getOrDefault(category, Set.of()).stream();
            List<GTRecipeWrapper> wrapped = Stream.concat(recipes, type.getRepresentativeRecipes().stream()).map(GTRecipeWrapper::new).toList();
            registration.addRecipes(TYPES.apply(category), wrapped);
        }
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (MachineDefinition machine : GTRegistries.MACHINES) {
            if (machine.getRecipeTypes() == null) continue;
            for (GTRecipeType type : machine.getRecipeTypes()) {
                if (type == null || !Platform.isDevEnv() && !type.getRecipeUI().isXEIVisible()) continue;
                for (GTRecipeCategory category : type.getRecipesByCategory().keySet()) {
                    registration.addRecipeCatalyst(machine.asStack(), new RecipeType[]{TYPES.apply(category)});
                }
            }
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(@NotNull GTRecipeWrapper wrapper) {
        return wrapper.recipe.id;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

