/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jei.orevein;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.client.ClientProxy;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.integration.GTOreVeinWidget;
import com.gregtechceu.gtceu.integration.jei.orevein.GTOreVeinInfoWrapper;
import com.lowdragmc.lowdraglib.jei.ModularUIRecipeCategory;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class GTOreVeinInfoCategory
extends ModularUIRecipeCategory<GTOreVeinInfoWrapper> {
    public static final RecipeType<GTOreVeinInfoWrapper> RECIPE_TYPE = new RecipeType(GTCEu.id("ore_vein_diagram"), GTOreVeinInfoWrapper.class);
    private final IDrawable background;
    private final IDrawable icon;

    public GTOreVeinInfoCategory(IJeiHelpers helpers) {
        IGuiHelper guiHelper = helpers.getGuiHelper();
        this.background = guiHelper.createBlankDrawable(120, 120);
        this.icon = helpers.getGuiHelper().createDrawableItemStack(ChemicalHelper.get(TagPrefix.rawOre, GTMaterials.Iron));
    }

    public static void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(RECIPE_TYPE, ClientProxy.CLIENT_ORE_VEINS.values().stream().map(GTOreVeinInfoWrapper::new).toList());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, GTOreVeinInfoWrapper wrapper, IFocusGroup focuses) {
        super.setRecipe(builder, (ModularWrapper)wrapper, focuses);
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStacks(GTOreVeinWidget.getContainedOresAndBlocks(wrapper.oreDefinition));
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(GTItems.PROSPECTOR_LV.asStack(), new RecipeType[]{RECIPE_TYPE});
        registration.addRecipeCatalyst(GTItems.PROSPECTOR_HV.asStack(), new RecipeType[]{RECIPE_TYPE});
        registration.addRecipeCatalyst(GTItems.PROSPECTOR_LuV.asStack(), new RecipeType[]{RECIPE_TYPE});
    }

    @NotNull
    public RecipeType<GTOreVeinInfoWrapper> getRecipeType() {
        return RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"gtceu.jei.ore_vein_diagram");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }
}

