/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.emi.recipe;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.integration.emi.recipe.GTEmiRecipe;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GTRecipeEMICategory
extends EmiRecipeCategory {
    public static final Function<GTRecipeCategory, GTRecipeEMICategory> CATEGORIES = Util.m_143827_(GTRecipeEMICategory::new);
    private final GTRecipeCategory category;

    public GTRecipeEMICategory(GTRecipeCategory category) {
        super(category.getRecipeType().registryName, GTRecipeEMICategory.getDrawable(category), GTRecipeEMICategory.getDrawable(category));
        this.category = category;
    }

    public static EmiRenderable getDrawable(GTRecipeCategory category) {
        Object object = category.getIcon();
        if (object instanceof ResourceTexture) {
            ResourceTexture tex = (ResourceTexture)object;
            return new EmiTexture(tex.imageLocation, 0, 0, 16, 16, (int)tex.imageWidth, (int)tex.imageHeight, (int)tex.imageWidth, (int)tex.imageHeight);
        }
        if (category.getRecipeType().getIconSupplier() != null) {
            return EmiStack.of((ItemStack)category.getRecipeType().getIconSupplier().get());
        }
        return EmiStack.of((ItemLike)Items.f_42127_);
    }

    public static void registerDisplays(EmiRegistry registry) {
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            GTRecipeType type = category.getRecipeType();
            if (type == GTRecipeTypes.FURNACE_RECIPES || !type.getRecipeUI().isXEIVisible() && !Platform.isDevEnv()) continue;
            Stream recipes = type.getCategoryMap().getOrDefault(category, Set.of()).stream();
            Stream.concat(recipes, type.getRepresentativeRecipes().stream()).map(recipe -> new GTEmiRecipe(CATEGORIES.apply(category), (GTRecipe)recipe)).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
        }
    }

    public static void registerWorkStations(EmiRegistry registry) {
        for (MachineDefinition machine : GTRegistries.MACHINES) {
            if (machine.getRecipeTypes() == null) continue;
            for (GTRecipeType type : machine.getRecipeTypes()) {
                if (type == null || !Platform.isDevEnv() && !type.getRecipeUI().isXEIVisible()) continue;
                for (GTRecipeCategory category : type.getRecipesByCategory().keySet()) {
                    registry.addWorkstation((EmiRecipeCategory)CATEGORIES.apply(category), (EmiIngredient)EmiStack.of((ItemStack)machine.asStack()));
                }
            }
        }
    }

    public Component getName() {
        return Component.m_237115_((String)this.category.getTranslation());
    }
}

