/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEFluidConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAEFluidList;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAEFluidSlot;
import com.gregtechceu.gtceu.utils.GTMath;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MEInputHatchPartMachine
extends MEHatchPartMachine
implements IDataStickInteractable,
IMachineLife {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEInputHatchPartMachine.class, MEHatchPartMachine.MANAGED_FIELD_HOLDER);
    protected ExportOnlyAEFluidList aeFluidHandler;

    public MEInputHatchPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.IN, args);
    }

    @Override
    public void onMachineRemoved() {
        this.flushInventory();
    }

    @Override
    protected NotifiableFluidTank createTank(int initialCapacity, int slots, Object ... args) {
        this.aeFluidHandler = new ExportOnlyAEFluidList(this, slots);
        return this.aeFluidHandler;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected void autoIO() {
        if (!this.isWorkingEnabled()) {
            return;
        }
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            this.syncME();
            this.updateTankSubscription();
        }
    }

    protected void syncME() {
        MEStorage networkInv = this.getMainNode().getGrid().getStorageService().getInventory();
        for (ExportOnlyAEFluidSlot aeTank : this.aeFluidHandler.getInventory()) {
            long extracted;
            GenericStack reqFluid;
            GenericStack exceedFluid = aeTank.exceedStack();
            if (exceedFluid != null) {
                int total = GTMath.saturatedCast(exceedFluid.amount());
                int inserted = GTMath.saturatedCast(networkInv.insert(exceedFluid.what(), exceedFluid.amount(), Actionable.MODULATE, this.actionSource));
                if (inserted > 0) {
                    aeTank.drain(inserted, IFluidHandler.FluidAction.EXECUTE);
                    continue;
                }
                aeTank.drain(total, IFluidHandler.FluidAction.EXECUTE);
            }
            if ((reqFluid = aeTank.requestStack()) == null || (extracted = networkInv.extract(reqFluid.what(), reqFluid.amount(), Actionable.MODULATE, this.actionSource)) <= 0L) continue;
            aeTank.addStack(new GenericStack(reqFluid.what(), extracted));
        }
    }

    protected void flushInventory() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            for (ExportOnlyAEFluidSlot aeSlot : this.aeFluidHandler.getInventory()) {
                GenericStack stock = aeSlot.getStock();
                if (stock == null) continue;
                grid.getStorageService().getInventory().insert(stock.what(), stock.amount(), Actionable.MODULATE, this.actionSource);
            }
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new LabelWidget(3, 0, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new AEFluidConfigWidget(3, 10, this.aeFluidHandler));
        return group;
    }

    @Override
    public final boolean onDataStickLeftClick(Player player, ItemStack dataStick) {
        if (!this.isRemote()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("MEInputHatch", (Tag)this.writeConfigToTag());
            dataStick.m_41751_(tag);
            dataStick.m_41714_((Component)Component.m_237115_((String)"gtceu.machine.me.fluid_import.data_stick.name"));
            player.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.import_copy_settings"));
        }
        return true;
    }

    @Override
    public final InteractionResult onDataStickRightClick(Player player, ItemStack dataStick) {
        CompoundTag tag = dataStick.m_41783_();
        if (tag == null || !tag.m_128441_("MEInputHatch")) {
            return InteractionResult.PASS;
        }
        if (!this.isRemote()) {
            this.readConfigFromTag(tag.m_128469_("MEInputHatch"));
            this.updateTankSubscription();
            player.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.me.import_paste_settings"));
        }
        return InteractionResult.m_19078_((boolean)this.isRemote());
    }

    protected CompoundTag writeConfigToTag() {
        CompoundTag tag = new CompoundTag();
        CompoundTag configStacks = new CompoundTag();
        tag.m_128365_("ConfigStacks", (Tag)configStacks);
        for (int i = 0; i < 16; ++i) {
            ExportOnlyAEFluidSlot slot = this.aeFluidHandler.getInventory()[i];
            GenericStack config = slot.getConfig();
            if (config == null) continue;
            CompoundTag stackTag = GenericStack.writeTag((GenericStack)config);
            configStacks.m_128365_(Integer.toString(i), (Tag)stackTag);
        }
        tag.m_128344_("GhostCircuit", (byte)IntCircuitBehaviour.getCircuitConfiguration(this.circuitInventory.getStackInSlot(0)));
        return tag;
    }

    protected void readConfigFromTag(CompoundTag tag) {
        if (tag.m_128441_("ConfigStacks")) {
            CompoundTag configStacks = tag.m_128469_("ConfigStacks");
            for (int i = 0; i < 16; ++i) {
                String key = Integer.toString(i);
                if (configStacks.m_128441_(key)) {
                    CompoundTag configTag = configStacks.m_128469_(key);
                    this.aeFluidHandler.getInventory()[i].setConfig(GenericStack.readTag((CompoundTag)configTag));
                    continue;
                }
                this.aeFluidHandler.getInventory()[i].setConfig(null);
            }
        }
        if (tag.m_128441_("GhostCircuit")) {
            this.circuitInventory.setStackInSlot(0, IntCircuitBehaviour.stack(tag.m_128445_("GhostCircuit")));
        }
    }
}

