/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration;

import com.google.common.collect.ImmutableList;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.TagOrCycleFluidHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.TagOrCycleItemStackHandler;
import com.gregtechceu.gtceu.integration.GTOreByProduct;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class GTOreByProductWidget
extends WidgetGroup {
    protected static final ImmutableList<Integer> ITEM_INPUT_LOCATIONS = ImmutableList.of((Object)3, (Object)3, (Object)23, (Object)3, (Object)3, (Object)24, (Object)23, (Object)71, (Object)50, (Object)80, (Object)24, (Object)25, (Object[])new Integer[]{97, 71, 70, 80, 114, 48, 133, 71, 3, 123, 41, 145, 102, 145, 24, 48, 155, 71, 101, 25});
    protected static final ImmutableList<Integer> ITEM_OUTPUT_LOCATIONS = ImmutableList.of((Object)46, (Object)3, (Object)3, (Object)47, (Object)3, (Object)65, (Object)23, (Object)92, (Object)23, (Object)110, (Object)50, (Object)101, (Object[])new Integer[]{50, 119, 64, 25, 82, 25, 97, 92, 97, 110, 70, 101, 70, 119, 137, 47, 155, 47, 133, 92, 133, 110, 3, 105, 3, 145, 23, 145, 63, 145, 84, 145, 124, 145, 64, 48, 82, 48, 155, 92, 155, 110, 155, 128, 119, 3, 137, 3, 155, 3, 119, 21, 137, 21, 155, 21});
    protected static final ImmutableList<Integer> FLUID_LOCATIONS = ImmutableList.of((Object)42, (Object)25, (Object)42, (Object)48);

    public GTOreByProductWidget(Material material) {
        super(0, 0, 176, 166);
        this.setClientSideWidget();
        this.setRecipe(new GTOreByProduct(material));
    }

    public void setRecipe(GTOreByProduct recipeWrapper) {
        int i;
        ArrayList<Boolean> itemOutputExists = new ArrayList<Boolean>();
        this.addWidget((Widget)new ImageWidget(((Integer)ITEM_INPUT_LOCATIONS.get(0)).intValue(), ((Integer)ITEM_INPUT_LOCATIONS.get(1)).intValue(), 18, 18, (IGuiTexture)GuiTextures.SLOT));
        boolean hasSifter = recipeWrapper.hasSifter();
        this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_BASE));
        if (recipeWrapper.hasDirectSmelt()) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_SMELT));
        }
        if (recipeWrapper.hasChemBath()) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_CHEM));
        }
        if (recipeWrapper.hasSeparator()) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_SEP));
        }
        if (hasSifter) {
            this.addWidget((Widget)new ImageWidget(0, 0, 176, 166, (IGuiTexture)GuiTextures.OREBY_SIFT));
        }
        List<Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>>> itemInputs = recipeWrapper.itemInputs;
        TagOrCycleItemStackHandler itemInputsHandler = new TagOrCycleItemStackHandler(itemInputs);
        WidgetGroup itemStackGroup = new WidgetGroup();
        for (int i2 = 0; i2 < ITEM_INPUT_LOCATIONS.size(); i2 += 2) {
            int finalI = i2;
            itemStackGroup.addWidget(new SlotWidget(itemInputsHandler, i2 / 2, (int)((Integer)ITEM_INPUT_LOCATIONS.get(i2)), (int)((Integer)ITEM_INPUT_LOCATIONS.get(i2 + 1))).setCanTakeItems(false).setCanPutItems(false).setIngredientIO(IngredientIO.INPUT).setOnAddedTooltips((slot, tooltips) -> recipeWrapper.getTooltip(finalI / 2, (List<Component>)tooltips)).setBackground(new IGuiTexture[]{null}));
        }
        NonNullList<ItemStack> itemOutputs = recipeWrapper.itemOutputs;
        CustomItemStackHandler itemOutputsHandler = new CustomItemStackHandler(itemOutputs);
        for (int i3 = 0; i3 < ITEM_OUTPUT_LOCATIONS.size(); i3 += 2) {
            int slotIndex = i3 / 2;
            float xeiChance = 1.0f;
            Content chance = recipeWrapper.getChance(i3 / 2 + itemInputs.size());
            IGuiTexture overlay = null;
            if (chance != null) {
                xeiChance = (float)chance.chance / (float)chance.maxChance;
                overlay = chance.createOverlay(false, 0, 0, null);
            }
            if (((ItemStack)itemOutputs.get(slotIndex)).m_41619_()) {
                itemOutputExists.add(false);
                continue;
            }
            itemStackGroup.addWidget(new SlotWidget((IItemHandlerModifiable)itemOutputsHandler, slotIndex, (int)((Integer)ITEM_OUTPUT_LOCATIONS.get(i3)), (int)((Integer)ITEM_OUTPUT_LOCATIONS.get(i3 + 1))).setCanTakeItems(false).setCanPutItems(false).setIngredientIO(IngredientIO.OUTPUT).setXEIChance(xeiChance).setOnAddedTooltips((slot, tooltips) -> recipeWrapper.getTooltip(slotIndex + itemInputs.size(), (List<Component>)tooltips)).setBackground(new IGuiTexture[]{null}).setOverlay(overlay));
            itemOutputExists.add(true);
        }
        List<Either<List<Pair<TagKey<Fluid>, Integer>>, List<FluidStack>>> fluidInputs = recipeWrapper.fluidInputs;
        TagOrCycleFluidHandler fluidInputsHandler = new TagOrCycleFluidHandler(fluidInputs);
        WidgetGroup fluidStackGroup = new WidgetGroup();
        for (i = 0; i < FLUID_LOCATIONS.size(); i += 2) {
            int slotIndex = i / 2;
            if (((List)fluidInputs.get(slotIndex).map(Function.identity(), Function.identity())).isEmpty()) continue;
            TankWidget tank = new TankWidget(new CustomFluidTank(fluidInputsHandler.getFluidInTank(slotIndex)), (Integer)FLUID_LOCATIONS.get(i), (Integer)FLUID_LOCATIONS.get(i + 1), false, false).setIngredientIO(IngredientIO.INPUT).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT).setShowAmount(false);
            fluidStackGroup.addWidget((Widget)tank);
        }
        this.addWidget((Widget)itemStackGroup);
        this.addWidget((Widget)fluidStackGroup);
        for (i = 0; i < ITEM_OUTPUT_LOCATIONS.size(); i += 2) {
            if (!((Boolean)itemOutputExists.get(i / 2)).booleanValue() && (i <= 56 || !((Boolean)itemOutputExists.get(28)).booleanValue() || !hasSifter)) continue;
            this.addWidget(this.widgets.size() - 3, (Widget)new ImageWidget(((Integer)ITEM_OUTPUT_LOCATIONS.get(i)).intValue(), ((Integer)ITEM_OUTPUT_LOCATIONS.get(i + 1)).intValue(), 18, 18, (IGuiTexture)GuiTextures.SLOT));
        }
    }
}

