/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterial;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.data.recipe.builder.BlastingRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.CampfireRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedEnergyTransferRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedFluidContainerRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapelessRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.SmeltingRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.SmokingRecipeBuilder;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.chars.Char2IntFunction;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaRecipeHelper {
    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, regName, input, output, 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, Ingredient input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, Ingredient input, ItemStack output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addBlastingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, Ingredient input, ItemStack output, float experience) {
        VanillaRecipeHelper.addBlastingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, Ingredient input, ItemStack output, float experience) {
        new BlastingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new BlastingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new SmokingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output, float experience) {
        new SmokingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output, float experience) {
        new CampfireRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new CampfireRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addShapedNBTClearingRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, regName, result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, false, regName, result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, false, regName, result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, boolean isStrict, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        ShapedRecipeBuilder builder = new ShapedRecipeBuilder(regName).output(result);
        builder.isStrict(isStrict);
        CharOpenHashSet set = new CharOpenHashSet();
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (Character c : ToolHelper.getToolSymbols()) {
                    if (pattern.indexOf(c.charValue()) < 0) continue;
                    set.add(c.charValue());
                }
            }
            if (o instanceof String[]) {
                pattern = (String[])o;
                for (String s : pattern) {
                    builder.pattern(s);
                    for (Character c : ToolHelper.getToolSymbols()) {
                        if (s.indexOf(c.charValue()) < 0) continue;
                        set.add(c.charValue());
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object content = recipe[i + 1];
            ++i;
            if (content instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)content;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (content instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)content;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (content instanceof TagKey) {
                TagKey key = (TagKey)content;
                builder.define(sign.charValue(), (TagKey<Item>)key);
                continue;
            }
            if (content instanceof TagPrefix) {
                TagPrefix prefix = (TagPrefix)content;
                if (prefix.getItemParentTags().length <= 0) continue;
                builder.define(sign.charValue(), prefix.getItemParentTags()[0]);
                continue;
            }
            if (content instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)content;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (content instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)content;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix, entry.material));
                continue;
            }
            if (!(content instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)content;
            builder.define(sign.charValue(), entry.asStack());
        }
        for (Character c : set) {
            builder.define(c.charValue(), ToolHelper.getToolFromSymbol((Character)c).itemTags.get(0));
        }
        builder.save(provider);
        if (withUnificationData) {
            ChemicalHelper.registerMaterialInfo((ItemLike)result.m_41720_(), VanillaRecipeHelper.getRecyclingIngredients(result.m_41613_(), recipe));
        }
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, withUnificationData, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, withUnificationData, false, regName, result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, withUnificationData, true, regName, result, recipe);
    }

    public static void addShapelessRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapelessRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedEnergyTransferRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, boolean overrideCharge, boolean transferMaxCharge, @NotNull ResourceLocation regName, @NotNull Ingredient chargeIngredient, @NotNull ItemStack result, Object ... recipe) {
        ShapedEnergyTransferRecipeBuilder builder = new ShapedEnergyTransferRecipeBuilder(regName).output(result);
        builder.chargeIngredient(chargeIngredient).overrideCharge(overrideCharge).transferMaxCharge(transferMaxCharge);
        CharOpenHashSet set = new CharOpenHashSet();
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (Character c : ToolHelper.getToolSymbols()) {
                    if (pattern.indexOf(c.charValue()) < 0) continue;
                    set.add(c.charValue());
                }
            }
            if (o instanceof String[]) {
                pattern = (String[])o;
                for (String s : pattern) {
                    builder.pattern(s);
                    for (Character c : ToolHelper.getToolSymbols()) {
                        if (s.indexOf(c.charValue()) < 0) continue;
                        set.add(c.charValue());
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object content = recipe[i + 1];
            ++i;
            if (content instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)content;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (content instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)content;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (content instanceof TagKey) {
                TagKey key = (TagKey)content;
                builder.define(sign.charValue(), (TagKey<Item>)key);
                continue;
            }
            if (content instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)content;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (content instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)content;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix, entry.material));
                continue;
            }
            if (!(content instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)content;
            builder.define(sign.charValue(), entry.asStack());
        }
        for (Character c : set) {
            builder.define(c.charValue(), ToolHelper.getToolFromSymbol((Character)c).itemTags.get(0));
        }
        builder.save(provider);
        if (withUnificationData) {
            ChemicalHelper.registerMaterialInfo((ItemLike)result.m_41720_(), VanillaRecipeHelper.getRecyclingIngredients(result.m_41613_(), recipe));
        }
    }

    public static void addShapedEnergyTransferRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, boolean overrideCharge, boolean transferMaxCharge, @NotNull String regName, @NotNull Ingredient chargeIngredient, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, withUnificationData, overrideCharge, transferMaxCharge, GTCEu.id(regName), chargeIngredient, result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, boolean isStrict, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        ShapedRecipeBuilder builder = new ShapedFluidContainerRecipeBuilder(regName).output(result);
        builder.isStrict(isStrict);
        CharOpenHashSet set = new CharOpenHashSet();
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (Character c : ToolHelper.getToolSymbols()) {
                    if (pattern.indexOf(c.charValue()) < 0) continue;
                    set.add(c.charValue());
                }
            }
            if (o instanceof String[]) {
                pattern = (String[])o;
                for (String s : pattern) {
                    builder.pattern(s);
                    for (Character c : ToolHelper.getToolSymbols()) {
                        if (s.indexOf(c.charValue()) < 0) continue;
                        set.add(c.charValue());
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object content = recipe[i + 1];
            ++i;
            if (content instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)content;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (content instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)content;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (content instanceof TagKey) {
                TagKey key = (TagKey)content;
                builder.define(sign.charValue(), (TagKey<Item>)key);
                continue;
            }
            if (content instanceof TagPrefix) {
                TagPrefix prefix = (TagPrefix)content;
                if (prefix.getItemParentTags().length <= 0) continue;
                builder.define(sign.charValue(), prefix.getItemParentTags()[0]);
                continue;
            }
            if (content instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)content;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (content instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)content;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix, entry.material));
                continue;
            }
            if (!(content instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)content;
            builder.define(sign.charValue(), entry.asStack());
        }
        for (Character c : set) {
            builder.define(c.charValue(), ToolHelper.getToolFromSymbol((Character)c).itemTags.get(0));
        }
        builder.save(provider);
        if (withUnificationData) {
            ChemicalHelper.registerMaterialInfo((ItemLike)result.m_41720_(), VanillaRecipeHelper.getRecyclingIngredients(result.m_41613_(), recipe));
        }
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, withUnificationData, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, boolean withUnificationData, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, withUnificationData, false, regName, result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, false, regName, result, recipe);
    }

    public static void addShapelessNBTClearingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapelessRecipe(provider, regName, result, recipe);
    }

    public static void addShapelessRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        ShapelessRecipeBuilder builder = new ShapelessRecipeBuilder(regName).output(result);
        for (Object content : recipe) {
            if (content instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)content;
                builder.requires(ingredient);
                continue;
            }
            if (content instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)content;
                builder.requires(itemStack);
                continue;
            }
            if (content instanceof TagKey) {
                TagKey key = (TagKey)content;
                builder.requires((TagKey<Item>)key);
                continue;
            }
            if (content instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)content;
                builder.requires(itemLike);
                continue;
            }
            if (content instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)content;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix, entry.material);
                if (tag != null) {
                    builder.requires(tag);
                    continue;
                }
                builder.requires(ChemicalHelper.get(entry.tagPrefix, entry.material));
                continue;
            }
            if (content instanceof ItemProviderEntry) {
                ItemProviderEntry entry = (ItemProviderEntry)content;
                builder.requires(entry.asStack());
                continue;
            }
            if (!(content instanceof Character)) continue;
            Character c = (Character)content;
            builder.requires(ToolHelper.getToolFromSymbol((Character)c).itemTags.get(0));
        }
        builder.save(provider);
    }

    public static boolean isMaterialWood(@Nullable Material material) {
        return material != null && material.hasProperty(PropertyKey.WOOD);
    }

    public static ItemMaterialInfo getRecyclingIngredients(int outputCount, Object ... recipe) {
        Object object;
        Char2IntOpenHashMap inputCountMap = new Char2IntOpenHashMap();
        Object2LongOpenHashMap materialStacksExploded = new Object2LongOpenHashMap();
        int itr = 0;
        while ((object = recipe[itr]) instanceof String) {
            String s = (String)object;
            object = s.toCharArray();
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Object c = object[i];
                if (ToolHelper.getToolFromSymbol(Character.valueOf((char)c)) != null) continue;
                int count = inputCountMap.getOrDefault((char)c, 0);
                inputCountMap.put((char)c, count + 1);
            }
            ++itr;
        }
        char lastChar = ' ';
        for (int i = itr; i < recipe.length; ++i) {
            TagPrefix prefix;
            Item itemLike;
            Object ingredient = recipe[i];
            if (ingredient instanceof Character) {
                lastChar = ((Character)ingredient).charValue();
                continue;
            }
            if (lastChar == ' ') {
                return null;
            }
            if (ingredient instanceof Ingredient) {
                ItemStack stack;
                Ingredient ingr = (Ingredient)ingredient;
                ItemStack[] stacks = ingr.m_43908_();
                if (stacks.length == 0 || (stack = stacks[0]) == ItemStack.f_41583_) continue;
                itemLike = stack.m_41720_();
            } else if (ingredient instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)ingredient;
                itemLike = itemStack.m_41720_();
            } else {
                if (ingredient instanceof TagKey) {
                    TagKey key = (TagKey)ingredient;
                    continue;
                }
                if (ingredient instanceof ItemLike) {
                    itemLike = (ItemLike)ingredient;
                } else if (ingredient instanceof UnificationEntry) {
                    UnificationEntry entry = (UnificationEntry)ingredient;
                    ItemStack stack = ChemicalHelper.get(entry.tagPrefix, entry.material);
                    if (stack == ItemStack.f_41583_) continue;
                    itemLike = stack.m_41720_();
                } else {
                    if (!(ingredient instanceof ItemProviderEntry)) continue;
                    ItemProviderEntry entry = (ItemProviderEntry)ingredient;
                    itemLike = entry.m_5456_();
                }
            }
            ItemMaterialInfo info = ChemicalHelper.getMaterialInfo((ItemLike)itemLike);
            if (info != null) {
                for (MaterialStack ms : info.getMaterials()) {
                    if (ms.material() instanceof MarkerMaterial) continue;
                    VanillaRecipeHelper.addMaterialStack((Object2LongMap<Material>)materialStacksExploded, (Char2IntFunction)inputCountMap, ms, lastChar);
                }
                continue;
            }
            MaterialStack materialStack = ChemicalHelper.getMaterial((ItemLike)itemLike);
            if (materialStack != null && !(materialStack.material() instanceof MarkerMaterial)) {
                VanillaRecipeHelper.addMaterialStack((Object2LongMap<Material>)materialStacksExploded, (Char2IntFunction)inputCountMap, materialStack, lastChar);
            }
            if ((prefix = ChemicalHelper.getPrefix((ItemLike)itemLike)) == null || prefix.secondaryMaterials().isEmpty()) continue;
            for (MaterialStack ms : prefix.secondaryMaterials()) {
                VanillaRecipeHelper.addMaterialStack((Object2LongMap<Material>)materialStacksExploded, (Char2IntFunction)inputCountMap, ms, lastChar);
            }
        }
        return new ItemMaterialInfo(materialStacksExploded.entrySet().stream().map(e -> new MaterialStack((Material)e.getKey(), (Long)e.getValue() / (long)outputCount)).sorted(Comparator.comparingLong(m -> -m.amount())).collect(Collectors.toList()));
    }

    private static void addMaterialStack(@NotNull Object2LongMap<Material> materialStacksExploded, @NotNull Char2IntFunction inputCountMap, @NotNull MaterialStack ms, char c) {
        long amount = materialStacksExploded.getOrDefault((Object)ms.material(), 0L);
        materialStacksExploded.put((Object)ms.material(), ms.amount() * (long)inputCountMap.get(c) + amount);
    }
}

