/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.machine.storage.LongDistanceEndpointMachine;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class LDFluidEndpointMachine
extends LongDistanceEndpointMachine {
    public LDFluidEndpointMachine(IMachineBlockEntity holder) {
        super(holder, LDFluidPipeType.INSTANCE);
    }

    public static class FluidHandlerWrapper
    implements IFluidHandlerModifiable {
        private final IFluidHandler delegate;

        public FluidHandlerWrapper(IFluidHandler delegate) {
            this.delegate = delegate;
        }

        public int getTanks() {
            return this.delegate.getTanks();
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return this.delegate.getFluidInTank(tank);
        }

        @Override
        public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
            IFluidHandler iFluidHandler = this.delegate;
            if (iFluidHandler instanceof IFluidHandlerModifiable) {
                IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)iFluidHandler;
                modifiable.setFluidInTank(tank, fluidStack);
            }
        }

        public int getTankCapacity(int tank) {
            return this.delegate.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return this.delegate.isFluidValid(tank, stack);
        }

        @Override
        public boolean supportsFill(int tank) {
            IFluidHandler iFluidHandler = this.delegate;
            if (iFluidHandler instanceof IFluidHandlerModifiable) {
                IFluidHandlerModifiable modifiable = (IFluidHandlerModifiable)iFluidHandler;
                return modifiable.supportsFill(tank);
            }
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return this.delegate.fill(resource, action);
        }

        @Override
        public boolean supportsDrain(int tank) {
            return false;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

