/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.network.packets;

import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.integration.map.cache.GridPos;
import com.gregtechceu.gtceu.integration.map.cache.client.GTClientCache;
import com.lowdragmc.lowdraglib.networking.IHandlerContext;
import com.lowdragmc.lowdraglib.networking.IPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class SPacketOreProspect
implements IPacket {
    private final List<ResourceKey<Level>> dimList;
    private final List<Integer> gridXList;
    private final List<Integer> gridZList;
    private final List<GeneratedVeinMetadata> nameList;

    public SPacketOreProspect() {
        this.dimList = new ArrayList<ResourceKey<Level>>();
        this.gridXList = new ArrayList<Integer>();
        this.gridZList = new ArrayList<Integer>();
        this.nameList = new ArrayList<GeneratedVeinMetadata>();
    }

    public SPacketOreProspect(ResourceKey<Level> dim, int gridX, int gridZ, GeneratedVeinMetadata vein) {
        this.dimList = Collections.singletonList(dim);
        this.gridXList = Collections.singletonList(gridX);
        this.gridZList = Collections.singletonList(gridZ);
        this.nameList = Collections.singletonList(vein);
    }

    public SPacketOreProspect(List<ResourceKey<Level>> dimList, List<Integer> gridXList, List<Integer> gridZList, List<GeneratedVeinMetadata> nameList) {
        this.dimList = dimList;
        this.gridXList = gridXList;
        this.gridZList = gridZList;
        this.nameList = nameList;
    }

    public SPacketOreProspect(ResourceKey<Level> dim, List<GeneratedVeinMetadata> veins) {
        this();
        for (GeneratedVeinMetadata vein : veins) {
            this.dimList.add(dim);
            this.gridXList.add(GridPos.blockToGridCoords(vein.center().m_123341_()));
            this.gridZList.add(GridPos.blockToGridCoords(vein.center().m_123343_()));
            this.nameList.add(vein);
        }
    }

    public void execute(IHandlerContext handler) {
        if (handler.isClient()) {
            int newVeins = 0;
            for (int i = 0; i < this.dimList.size(); ++i) {
                if (!GTClientCache.instance.addVein(this.dimList.get(i), this.gridXList.get(i), this.gridZList.get(i), this.nameList.get(i))) continue;
                ++newVeins;
            }
            GTClientCache.instance.notifyNewVeins(newVeins);
        }
    }

    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(this.dimList.size());
        for (int i = 0; i < this.dimList.size(); ++i) {
            packetBuffer.m_236858_(this.dimList.get(i));
            packetBuffer.writeInt(this.gridXList.get(i).intValue());
            packetBuffer.writeInt(this.gridZList.get(i).intValue());
            this.nameList.get(i).writeToPacket(packetBuffer);
        }
    }

    public void decode(FriendlyByteBuf packetBuffer) {
        int size = packetBuffer.readInt();
        for (int i = 0; i < size; ++i) {
            this.dimList.add((ResourceKey<Level>)packetBuffer.m_236801_(Registries.f_256858_));
            this.gridXList.add(packetBuffer.readInt());
            this.gridZList.add(packetBuffer.readInt());
            this.nameList.add(GeneratedVeinMetadata.readFromPacket(packetBuffer));
        }
    }
}

