/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomSlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.api.machine.feature.IDropSaveMachine;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Set;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class QuantumChestMachine
extends TieredMachine
implements IAutoOutputItem,
IInteractedMachine,
IControllable,
IDropSaveMachine,
IFancyUIMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(QuantumChestMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    public static final Object2LongOpenHashMap<UUID> INTERACTION_LOGGER = new Object2LongOpenHashMap();
    @Persisted
    @DescSynced
    @RequireRerender
    protected Direction outputFacingItems;
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean autoOutputItems;
    @Persisted
    protected boolean allowInputFromOutputSideItems;
    private final int maxStoredItems;
    @Persisted
    @DescSynced
    @DropSaved
    protected int storedAmount = 0;
    @Persisted
    @DescSynced
    @DropSaved
    @NotNull
    protected ItemStack stored = ItemStack.f_41583_;
    @Persisted
    @DropSaved
    protected final NotifiableItemStackHandler cache;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription exportItemSubs;
    @Persisted
    private boolean isVoiding;
    @Persisted
    @DescSynced
    private final CustomItemStackHandler lockedItem;

    public QuantumChestMachine(IMachineBlockEntity holder, int tier, int maxStoredItems, Object ... args) {
        super(holder, tier);
        this.outputFacingItems = this.getFrontFacing().m_122424_();
        this.maxStoredItems = maxStoredItems;
        this.cache = this.createCacheItemHandler(args);
        this.lockedItem = new CustomItemStackHandler();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createCacheItemHandler(Object ... args) {
        return new CustomCache(this).setFilter(itemStack -> !this.isLocked() || ItemHandlerHelper.canItemStacksStack((ItemStack)this.lockedItem.getStackInSlot(0), (ItemStack)itemStack));
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.stored = this.cache.storage.getStackInSlot(0);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
        this.exportItemSubs = this.cache.addChangedListener(this::onItemChanged);
    }

    private void onItemChanged() {
        if (!this.isRemote()) {
            this.stored = this.cache.storage.getStackInSlot(0);
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.exportItemSubs != null) {
            this.exportItemSubs.unsubscribe();
            this.exportItemSubs = null;
        }
    }

    @Override
    public boolean savePickClone() {
        return false;
    }

    @Override
    public void setAutoOutputItems(boolean allow) {
        this.autoOutputItems = allow;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void setOutputFacingItems(@Nullable Direction outputFacing) {
        this.outputFacingItems = outputFacing;
        this.updateAutoOutputSubscription();
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isAutoOutputItems();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.setAutoOutputItems(isWorkingAllowed);
    }

    protected void updateAutoOutputSubscription() {
        Direction outputFacing = this.getOutputFacingItems();
        if (this.isAutoOutputItems() && !this.cache.isEmpty() && outputFacing != null && GTTransferUtils.hasAdjacentItemHandler(this.getLevel(), this.getPos(), outputFacing)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::checkAutoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.cache.exportToNearby(this.getOutputFacingItems());
            }
            this.updateAutoOutputSubscription();
        }
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        if (facing == this.outputFacingItems) {
            return false;
        }
        return super.isFacingValid(facing);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_() == this.getFrontFacing() && !this.isRemote()) {
            ItemStack held = player.m_21205_();
            if (!held.m_41619_() && this.cache.insertItem(0, held, true).m_41613_() != held.m_41613_()) {
                ItemStack remaining = this.cache.insertItem(0, held, false);
                player.m_21008_(InteractionHand.MAIN_HAND, remaining);
                return InteractionResult.SUCCESS;
            }
            if (System.currentTimeMillis() - INTERACTION_LOGGER.getOrDefault((Object)player.m_20148_(), System.currentTimeMillis()) < 300L) {
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (stack.m_41619_() || this.cache.insertItem(0, stack, true).m_41613_() == stack.m_41613_()) continue;
                    stack.m_41764_(this.cache.insertItem(0, stack, false).m_41613_());
                }
            }
            INTERACTION_LOGGER.put((Object)player.m_20148_(), System.currentTimeMillis());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean onLeftClick(Player player, Level world, InteractionHand hand, BlockPos pos, Direction direction) {
        if (direction == this.getFrontFacing() && !this.isRemote()) {
            ItemStack drained;
            if (player.m_21120_(hand).m_204117_(GTToolType.WRENCH.itemTags.get(0))) {
                return false;
            }
            if (!(this.stored.m_41619_() || (drained = this.cache.extractItem(0, player.m_6144_() ? this.stored.m_41720_().m_41459_() : 1, false)).m_41619_() || player.m_36356_(drained))) {
                Block.m_152435_((Level)world, (BlockPos)this.getPos(), (Direction)this.getFrontFacing(), (ItemStack)drained);
            }
        }
        return IInteractedMachine.super.onLeftClick(player, world, hand, pos, direction);
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!playerIn.m_6144_() && !this.isRemote()) {
            ItemStack tool = playerIn.m_21120_(hand);
            if (tool.m_41773_() >= tool.m_41776_()) {
                return InteractionResult.PASS;
            }
            if (this.hasFrontFacing() && gridSide == this.getFrontFacing()) {
                return InteractionResult.PASS;
            }
            if (gridSide != this.getOutputFacingItems()) {
                this.setOutputFacingItems(gridSide);
            } else {
                this.setOutputFacingItems(null);
            }
            return InteractionResult.CONSUME;
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            if (gridSide == this.getOutputFacingItems()) {
                if (this.isAllowInputFromOutputSideItems()) {
                    this.setAllowInputFromOutputSideItems(false);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.disallow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")));
                } else {
                    this.setAllowInputFromOutputSideItems(true);
                    playerIn.m_213846_((Component)Component.m_237115_((String)"gtceu.machine.basic.input_from_output_side.allow").m_7220_((Component)Component.m_237115_((String)"gtceu.creative.chest.item")));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
    }

    public boolean isLocked() {
        return !this.lockedItem.getStackInSlot(0).m_41619_();
    }

    protected void setLocked(boolean locked) {
        if (!this.stored.m_41619_() && locked) {
            ItemStack copied = this.stored.m_41777_();
            copied.m_41764_(1);
            this.lockedItem.setStackInSlot(0, copied);
        } else if (!locked) {
            this.lockedItem.setStackInSlot(0, ItemStack.f_41583_);
        }
        this.lockedItem.onContentsChanged(0);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 109, 63);
        CustomItemStackHandler importItems = new CustomItemStackHandler();
        importItems.setFilter(itemStack -> this.cache.insertItem(0, (ItemStack)itemStack, true).m_41613_() != itemStack.m_41613_());
        importItems.setOnContentsChanged(() -> {
            ItemStack item = importItems.getStackInSlot(0).m_41777_();
            if (!item.m_41619_()) {
                importItems.setStackInSlot(0, ItemStack.f_41583_);
                importItems.onContentsChanged(0);
                this.cache.insertItem(0, item.m_41777_(), false);
            }
        });
        ItemStack current = this.cache.getStackInSlot(0).m_41777_();
        if (!current.m_41619_()) {
            current.m_41764_(Math.min(current.m_41613_(), current.m_41720_().m_41459_()));
        }
        group.addWidget((Widget)new ImageWidget(4, 4, 81, 55, (IGuiTexture)GuiTextures.DISPLAY)).addWidget((Widget)new LabelWidget(8, 8, "gtceu.machine.quantum_chest.items_stored")).addWidget((Widget)new LabelWidget(8, 18, () -> "" + this.storedAmount).setTextColor(-1).setDropShadow(true)).addWidget((Widget)new SlotWidget((IItemHandlerModifiable)importItems, 0, 87, 5, false, true).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.IN_SLOT_OVERLAY}))).addWidget((Widget)new SlotWidget(this.cache, 0, 87, 23, false, false).setItemHook(itemStack -> itemStack.m_255036_(Math.min(this.storedAmount, itemStack.m_41720_().getMaxStackSize(itemStack)))).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT)).addWidget((Widget)new ButtonWidget(87, 42, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, Icons.DOWN.scale(0.7f)}), cd -> {
            ItemStack extracted;
            ItemStack stored;
            if (!(cd.isRemote || (stored = this.cache.getStackInSlot(0)).m_41619_() || group.getGui().entityPlayer.m_36356_(extracted = this.cache.extractItem(0, Math.min(this.storedAmount, stored.m_41720_().getMaxStackSize(stored)), false)))) {
                Block.m_49840_((Level)group.getGui().entityPlayer.m_9236_(), (BlockPos)group.getGui().entityPlayer.m_20097_(), (ItemStack)extracted);
            }
        })).addWidget((Widget)new PhantomSlotWidget((IItemHandlerModifiable)this.lockedItem, 0, 58, 41, stack -> this.stored.m_41619_() || ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.stored)).setMaxStackSize(1)).addWidget((Widget)new ToggleButtonWidget(4, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_auto_output.tooltip")).addWidget((Widget)new ToggleButtonWidget(22, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLocked, this::setLocked).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_lock.tooltip")).addWidget((Widget)new ToggleButtonWidget(40, 41, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID, this::isVoiding, this::setVoiding).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_voiding_partial.tooltip"));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.WRENCH)) {
            if (!(player.m_6144_() || this.hasFrontFacing() && side == this.getFrontFacing())) {
                return GuiTextures.TOOL_IO_FACING_ROTATION;
            }
        } else if (toolTypes.contains(GTToolType.SCREWDRIVER)) {
            if (side == this.getOutputFacingItems()) {
                return GuiTextures.TOOL_ALLOW_INPUT;
            }
        } else if (toolTypes.contains(GTToolType.SOFT_MALLET) && side == this.getFrontFacing()) {
            return null;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    public Direction getOutputFacingItems() {
        return this.outputFacingItems;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSideItems) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSideItems;
    }

    public int getMaxStoredItems() {
        return this.maxStoredItems;
    }

    public int getStoredAmount() {
        return this.storedAmount;
    }

    @NotNull
    public ItemStack getStored() {
        return this.stored;
    }

    public NotifiableItemStackHandler getCache() {
        return this.cache;
    }

    public boolean isVoiding() {
        return this.isVoiding;
    }

    public void setVoiding(boolean isVoiding) {
        this.isVoiding = isVoiding;
    }

    public CustomItemStackHandler getLockedItem() {
        return this.lockedItem;
    }

    private class CustomCache
    extends NotifiableItemStackHandler {
        public CustomCache(MetaMachine holder) {
            super(holder, 1, IO.BOTH, IO.BOTH);
        }

        private ItemStack inner() {
            return this.storage.getStackInSlot(0);
        }

        @Override
        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.inner().m_255036_(QuantumChestMachine.this.storedAmount);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            int free = QuantumChestMachine.this.isVoiding ? Integer.MAX_VALUE : QuantumChestMachine.this.maxStoredItems - QuantumChestMachine.this.storedAmount;
            int canStore = 0;
            if ((this.inner().m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)this.inner(), (ItemStack)stack)) && this.storage.getFilter().test(stack)) {
                canStore = Math.min(stack.m_41613_(), free);
            }
            if (!simulate && canStore > 0) {
                if (this.inner().m_41619_()) {
                    this.setStackInSlot(0, stack.m_255036_(1));
                }
                QuantumChestMachine.this.storedAmount = Math.min(QuantumChestMachine.this.maxStoredItems, QuantumChestMachine.this.storedAmount + canStore);
                this.storage.onContentsChanged(0);
            }
            if (canStore == stack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            return stack.m_255036_(stack.m_41613_() - canStore);
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stored = this.inner().m_41777_();
            if (stored.m_41619_()) {
                return ItemStack.f_41583_;
            }
            int toExtract = Math.min(QuantumChestMachine.this.storedAmount, amount);
            if (!simulate && toExtract > 0) {
                QuantumChestMachine.this.storedAmount -= toExtract;
                if (QuantumChestMachine.this.storedAmount == 0) {
                    this.setStackInSlot(0, ItemStack.f_41583_);
                }
                this.storage.onContentsChanged(0);
            }
            if (toExtract == 0) {
                return ItemStack.f_41583_;
            }
            return stored.m_255036_(toExtract);
        }
    }
}

