/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.storage;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.PhantomSlotWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SwitchWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DropSaved;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class CreativeChestMachine
extends QuantumChestMachine {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CreativeChestMachine.class, QuantumChestMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DropSaved
    private int itemsPerCycle = 1;
    @Persisted
    @DropSaved
    private int ticksPerCycle = 1;

    public CreativeChestMachine(IMachineBlockEntity holder) {
        super(holder, 14, -1, new Object[0]);
    }

    @Override
    protected NotifiableItemStackHandler createCacheItemHandler(Object ... args) {
        return new InfiniteStackHandler(this);
    }

    @Override
    protected void checkAutoOutput() {
        if (this.getOffsetTimer() % (long)this.ticksPerCycle == 0L) {
            if (this.isAutoOutputItems() && this.getOutputFacingItems() != null) {
                this.updateItemTick();
            }
            this.updateAutoOutputSubscription();
        }
    }

    public void updateItemTick() {
        ItemStack stack;
        this.stored = stack = this.cache.getStackInSlot(0).m_255036_(this.itemsPerCycle);
        if (this.ticksPerCycle == 0 || this.getOffsetTimer() % (long)this.ticksPerCycle != 0L) {
            return;
        }
        if (this.getLevel().f_46443_ || !this.isWorkingEnabled() || stack.m_41619_()) {
            return;
        }
        GTTransferUtils.getAdjacentItemHandler(this.getLevel(), this.getPos(), this.getOutputFacingItems()).ifPresent(adj -> {
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)adj, (ItemStack)stack, (boolean)true);
            if (remainder.m_41613_() < this.itemsPerCycle) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)adj, (ItemStack)stack, (boolean)false);
            }
        });
    }

    private void updateStored(ItemStack item) {
        this.cache.setStackInSlot(0, item.m_255036_(1));
        this.stored = this.cache.getStackInSlot(0);
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (hit.m_82434_() == this.getFrontFacing() && !this.isRemote()) {
            if (heldItem.m_41619_() && player.m_6047_() && !this.stored.m_41619_()) {
                this.updateStored(ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_() && ItemHandlerHelper.canItemStacksStack((ItemStack)this.stored, (ItemStack)heldItem)) {
                player.m_21008_(hand, ItemStack.f_41583_);
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.m_41619_()) {
                this.updateStored(heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 131);
        group.addWidget((Widget)new PhantomSlotWidget(this.cache, 0, 36, 6).setClearSlotOnRightClick(true).setMaxStackSize(1).setBackgroundTexture((IGuiTexture)GuiTextures.SLOT).setChangeListener(this::markDirty));
        group.addWidget((Widget)new LabelWidget(7, 9, "gtceu.creative.chest.item"));
        group.addWidget((Widget)new ImageWidget(7, 48, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 50, 152, 10, () -> String.valueOf(this.itemsPerCycle), value -> {
            if (!value.isEmpty()) {
                this.itemsPerCycle = Integer.parseInt(value);
            }
        }).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 28, "gtceu.creative.chest.ipc"));
        group.addWidget((Widget)new ImageWidget(7, 85, 154, 14, (IGuiTexture)GuiTextures.DISPLAY));
        group.addWidget((Widget)new TextFieldWidget(9, 87, 152, 10, () -> String.valueOf(this.ticksPerCycle), value -> {
            if (!value.isEmpty()) {
                this.ticksPerCycle = Integer.parseInt(value);
            }
        }).setMaxStringLength(11).setNumbersOnly(1, Integer.MAX_VALUE));
        group.addWidget((Widget)new LabelWidget(7, 65, "gtceu.creative.chest.tpc"));
        group.addWidget((Widget)new SwitchWidget(7, 101, 162, 20, (clickData, value) -> this.setWorkingEnabled((boolean)value)).setTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.off")}), (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON, new TextTexture("gtceu.creative.activity.on")})).setPressed(this.isWorkingEnabled()));
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private class InfiniteStackHandler
    extends NotifiableItemStackHandler {
        public InfiniteStackHandler(MetaMachine holder) {
            super(holder, 1, IO.BOTH, IO.BOTH);
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (!CreativeChestMachine.this.stored.m_41619_()) {
                return ItemStack.f_41583_;
            }
            return stack;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!CreativeChestMachine.this.stored.m_41619_()) {
                return CreativeChestMachine.this.stored.m_255036_(amount);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

