/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.owner;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.machine.owner.ArgonautsOwner;
import com.gregtechceu.gtceu.common.machine.owner.FTBOwner;
import com.gregtechceu.gtceu.common.machine.owner.PlayerOwner;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface IMachineOwner {
    public void save(CompoundTag var1);

    public void load(CompoundTag var1);

    public MachineOwnerType type();

    public void displayInfo(List<Component> var1);

    public static IMachineOwner create(CompoundTag tag) {
        MachineOwnerType type = MachineOwnerType.VALUES[tag.m_128451_("type")];
        if (!type.isAvailable()) {
            GTCEu.LOGGER.warn("Machine ownership system: {} is not available", (Object)type.name());
            return null;
        }
        IMachineOwner owner = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case MachineOwnerType.PLAYER -> new PlayerOwner();
            case MachineOwnerType.FTB -> new FTBOwner();
            case MachineOwnerType.ARGONAUTS -> new ArgonautsOwner();
        };
        owner.load(tag);
        return owner;
    }

    default public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("type", this.type().ordinal());
        this.save(tag);
        return tag;
    }

    public boolean isPlayerInTeam(Player var1);

    public boolean isPlayerFriendly(Player var1);

    public static enum MachineOwnerType {
        PLAYER,
        FTB(GTCEu::isFTBTeamsLoaded, "FTB Teams"),
        ARGONAUTS(GTCEu::isArgonautsLoaded, "Argonauts Guild");

        public static final MachineOwnerType[] VALUES;
        private BooleanSupplier availabilitySupplier;
        private boolean available;
        private final String name;

        private MachineOwnerType(BooleanSupplier availabilitySupplier, String name) {
            this.availabilitySupplier = availabilitySupplier;
            this.name = name;
        }

        private MachineOwnerType() {
            this.available = true;
            this.name = "Player";
        }

        public boolean isAvailable() {
            if (this.availabilitySupplier != null) {
                this.available = this.availabilitySupplier.getAsBoolean();
                this.availabilitySupplier = null;
            }
            return this.available;
        }

        public String getName() {
            return this.name;
        }

        static {
            VALUES = MachineOwnerType.values();
        }
    }
}

