/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.electric.research;

import com.gregtechceu.gtceu.api.capability.IObjectHolder;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationReceiver;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.lookup.RecipeIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ResearchStationMachine
extends WorkableElectricMultiblockMachine
implements IOpticalComputationReceiver,
IDisplayUIMachine {
    private IOpticalComputationProvider computationProvider;
    private IObjectHolder objectHolder;

    public ResearchStationMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new ResearchStationRecipeLogic(this);
    }

    @Override
    public ResearchStationRecipeLogic getRecipeLogic() {
        return (ResearchStationRecipeLogic)super.getRecipeLogic();
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        for (IMultiPart part : this.getParts()) {
            IObjectHolder objectHolder;
            IOpticalComputationProvider provider = part.self().holder.self().getCapability(GTCapability.CAPABILITY_COMPUTATION_PROVIDER).resolve().orElse(null);
            if (provider != null) {
                this.computationProvider = provider;
            }
            if (!(part instanceof IObjectHolder)) continue;
            this.objectHolder = objectHolder = (IObjectHolder)((Object)part);
            this.getCapabilitiesProxy().put((Object)IO.IN, (Object)ItemRecipeCapability.CAP, Collections.singletonList(objectHolder.getAsHandler()));
        }
        if (this.computationProvider == null || this.objectHolder == null) {
            this.onStructureInvalid();
        }
    }

    @Override
    public boolean checkPattern() {
        boolean isFormed = super.checkPattern();
        if (isFormed && this.objectHolder != null && this.objectHolder.getFrontFacing() != this.getFrontFacing().m_122424_()) {
            this.onStructureInvalid();
        }
        return isFormed;
    }

    @Override
    public void onStructureInvalid() {
        this.computationProvider = null;
        for (IMultiPart part : this.getParts()) {
            IObjectHolder holder;
            if (!(part instanceof IObjectHolder) || (holder = (IObjectHolder)((Object)part)) != this.objectHolder) continue;
            this.objectHolder.setLocked(false);
        }
        this.objectHolder = null;
        super.onStructureInvalid();
    }

    @Override
    public boolean dampingWhenWaiting() {
        return false;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        MultiblockDisplayText.builder(textList, this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive()).setWorkingStatusKeys("gtceu.multiblock.idling", "gtceu.multiblock.work_paused", "gtceu.multiblock.research_station.researching").addEnergyUsageLine(this.energyContainer).addEnergyTierLine(this.tier).addWorkingStatusLine().addProgressLineOnlyPercent(this.recipeLogic.getProgressPercent());
    }

    @Override
    public IOpticalComputationProvider getComputationProvider() {
        return this.computationProvider;
    }

    public IObjectHolder getObjectHolder() {
        return this.objectHolder;
    }

    private static class ResearchStationRecipeLogic
    extends RecipeLogic {
        public ResearchStationRecipeLogic(ResearchStationMachine metaTileEntity) {
            super(metaTileEntity);
        }

        @Override
        @NotNull
        public ResearchStationMachine getMachine() {
            return (ResearchStationMachine)super.getMachine();
        }

        @Override
        @Nullable
        public Iterator<GTRecipe> searchRecipe() {
            IRecipeLogicMachine holder = this.machine;
            if (!holder.hasProxies()) {
                return null;
            }
            RecipeIterator iterator = this.machine.getRecipeType().getLookup().getRecipeIterator(holder, recipe -> {
                if (recipe.isFuel) {
                    return false;
                }
                if (!holder.hasProxies()) {
                    return false;
                }
                GTRecipe.ActionResult result = recipe.matchRecipeContents(IO.IN, holder, recipe.inputs, false);
                if (!result.isSuccess()) {
                    return false;
                }
                if (recipe.hasTick()) {
                    result = recipe.matchRecipeContents(IO.IN, holder, recipe.tickInputs, true);
                    return result.isSuccess();
                }
                return true;
            });
            boolean any = false;
            while (iterator.hasNext()) {
                GTRecipe recipe2 = iterator.next();
                if (recipe2 == null) continue;
                any = true;
                break;
            }
            if (any) {
                iterator.reset();
                return iterator;
            }
            for (GTRecipeType.ICustomRecipeLogic logic : this.machine.getRecipeType().getCustomRecipeLogicRunners()) {
                GTRecipe recipe3 = logic.createCustomRecipe(holder);
                if (recipe3 == null) continue;
                return Collections.singleton(recipe3).iterator();
            }
            return Collections.emptyIterator();
        }

        @Override
        public boolean checkMatchedRecipeAvailable(GTRecipe match) {
            GTRecipe modified = this.machine.fullModifyRecipe(match, this.ocParams, this.ocResult);
            if (modified != null) {
                if (!modified.inputs.containsKey(CWURecipeCapability.CAP) && !modified.tickInputs.containsKey(CWURecipeCapability.CAP)) {
                    return true;
                }
                if (modified.checkConditions(this).isSuccess() && this.matchRecipeNoOutput(modified, this.machine).isSuccess() && this.matchTickRecipeNoOutput(modified, this.machine).isSuccess()) {
                    this.setupRecipe(modified);
                }
                if (this.lastRecipe != null && this.getStatus() == RecipeLogic.Status.WORKING) {
                    this.lastOriginRecipe = match;
                    this.lastFailedMatches = null;
                    return true;
                }
            }
            return false;
        }

        public GTRecipe.ActionResult matchRecipeNoOutput(GTRecipe recipe, IRecipeCapabilityHolder holder) {
            if (!holder.hasProxies()) {
                return GTRecipe.ActionResult.FAIL_NO_REASON;
            }
            GTRecipe.ActionResult result = recipe.matchRecipeContents(IO.IN, holder, recipe.inputs, false);
            if (!result.isSuccess()) {
                return result;
            }
            return GTRecipe.ActionResult.SUCCESS;
        }

        public GTRecipe.ActionResult matchTickRecipeNoOutput(GTRecipe recipe, IRecipeCapabilityHolder holder) {
            if (recipe.hasTick()) {
                if (!holder.hasProxies()) {
                    return GTRecipe.ActionResult.FAIL_NO_REASON;
                }
                GTRecipe.ActionResult result = recipe.matchRecipeContents(IO.IN, holder, recipe.tickInputs, true);
                if (!result.isSuccess()) {
                    return result;
                }
            }
            return GTRecipe.ActionResult.SUCCESS;
        }

        @Override
        public void setupRecipe(GTRecipe recipe) {
            IObjectHolder holder = this.getMachine().getObjectHolder();
            holder.setLocked(true);
            if (this.handleFuelRecipe()) {
                if (!this.machine.beforeWorking(recipe)) {
                    return;
                }
                recipe.preWorking(this.machine);
                this.recipeDirty = false;
                this.lastRecipe = recipe;
                this.setStatus(RecipeLogic.Status.WORKING);
                this.progress = 0;
                this.duration = recipe.duration;
            }
        }

        @Override
        public void onRecipeFinish() {
            super.onRecipeFinish();
            IObjectHolder holder = this.getMachine().getObjectHolder();
            holder.setHeldItem(ItemStack.f_41583_);
            ItemStack outputItem = ItemStack.f_41583_;
            if (this.lastRecipe.getOutputContents(ItemRecipeCapability.CAP).size() >= 1) {
                outputItem = ((Ingredient)ItemRecipeCapability.CAP.of(this.getLastRecipe().getOutputContents(ItemRecipeCapability.CAP).get((int)0).content)).m_43908_()[0];
            }
            holder.setDataItem(outputItem);
            holder.setLocked(false);
        }

        @Override
        protected boolean handleRecipeIO(GTRecipe recipe, IO io) {
            if (io != IO.OUT) {
                return super.handleRecipeIO(recipe, io);
            }
            return true;
        }

        @Override
        protected boolean handleTickRecipeIO(GTRecipe recipe, IO io) {
            if (io != IO.OUT) {
                return super.handleTickRecipeIO(recipe, io);
            }
            return true;
        }
    }
}

