/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TransformerMachine
extends TieredEnergyMachine
implements IControllable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(TransformerMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    @UpdateListener(methodName="onTransformUpdated")
    private boolean isTransformUp;
    @Persisted
    private boolean isWorkingEnabled = true;
    private final int baseAmp;

    public TransformerMachine(IMachineBlockEntity holder, int tier, int baseAmp, Object ... args) {
        super(holder, tier, baseAmp, args);
        this.baseAmp = baseAmp;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private void onTransformUpdated(boolean newValue, boolean oldValue) {
        this.scheduleRenderUpdate();
        this.updateEnergyContainer(newValue);
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        int n;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof Integer) {
            Integer a = (Integer)object;
            n = a;
        } else {
            n = 1;
        }
        int amp = n;
        long tierVoltage = GTValues.V[this.getTier()];
        NotifiableEnergyContainer energyContainer = new NotifiableEnergyContainer(this, tierVoltage * 8L, tierVoltage * 4L, amp, tierVoltage, 4L * (long)amp);
        energyContainer.setSideInputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
        energyContainer.setSideOutputCondition(s -> s != this.getFrontFacing() && this.isWorkingEnabled());
        return energyContainer;
    }

    @Override
    public void onLoad() {
        super.onLoad();
        this.updateEnergyContainer(this.isTransformUp);
    }

    public void updateEnergyContainer(boolean isTransformUp) {
        long tierVoltage = GTValues.V[this.getTier()];
        int lowAmperage = this.baseAmp * 4;
        if (isTransformUp) {
            this.energyContainer.resetBasicInfo(tierVoltage * 8L * (long)lowAmperage, tierVoltage, lowAmperage, tierVoltage * 4L, this.baseAmp);
            this.energyContainer.setSideInputCondition(s -> s != this.getFrontFacing() && this.isWorkingEnabled());
            this.energyContainer.setSideOutputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
        } else {
            this.energyContainer.resetBasicInfo(tierVoltage * 8L * (long)lowAmperage, tierVoltage * 4L, this.baseAmp, tierVoltage, lowAmperage);
            this.energyContainer.setSideInputCondition(s -> s == this.getFrontFacing() && this.isWorkingEnabled());
            this.energyContainer.setSideOutputCondition(s -> s != this.getFrontFacing() && this.isWorkingEnabled());
        }
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier() + 1];
        }
        if (index == 3) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    public void setTransformUp(boolean isTransformUp) {
        if (this.isTransformUp != isTransformUp && !this.isRemote()) {
            this.isTransformUp = isTransformUp;
            this.updateEnergyContainer(isTransformUp);
        }
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            this.setTransformUp(!this.isTransformUp());
            playerIn.m_213846_((Component)Component.m_237110_((String)(this.isTransformUp() ? "gtceu.machine.transformer.message_transform_up" : "gtceu.machine.transformer.message_transform_down"), (Object[])new Object[]{this.energyContainer.getInputVoltage(), this.energyContainer.getInputAmperage(), this.energyContainer.getOutputVoltage(), this.energyContainer.getOutputAmperage()}));
        }
        return InteractionResult.CONSUME;
    }

    public boolean isTransformUp() {
        return this.isTransformUp;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingEnabled) {
        this.isWorkingEnabled = isWorkingEnabled;
    }

    public int getBaseAmp() {
        return this.baseAmp;
    }
}

