/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TieredEnergyMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.common.machine.trait.ConverterTrait;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConverterMachine
extends TieredEnergyMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ConverterMachine.class, TieredEnergyMachine.MANAGED_FIELD_HOLDER);

    public ConverterMachine(IMachineBlockEntity holder, int tier, int amps, Object ... args) {
        super(holder, tier, args, amps);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        Object object;
        if (args.length > 0 && (object = args[args.length - 1]) instanceof Integer) {
            Integer ampsValue = (Integer)object;
            return new ConverterTrait(this, ampsValue);
        }
        throw new IllegalArgumentException("ConverterMachine need args [amps] for initialization");
    }

    public ConverterTrait getConverterTrait() {
        return (ConverterTrait)this.energyContainer;
    }

    @Override
    public int tintColor(int index) {
        if (index == 2) {
            return GTValues.VC[this.getTier()];
        }
        return super.tintColor(index);
    }

    @Override
    public InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction facing, BlockHitResult hitResult) {
        if (!this.isRemote()) {
            if (this.getConverterTrait().isFeToEu()) {
                this.setFeToEu(false);
                playerIn.m_213846_((Component)Component.m_237110_((String)"gtceu.machine.energy_converter.message_conversion_eu", (Object[])new Object[]{this.getConverterTrait().getAmps(), this.getConverterTrait().getVoltage(), FeCompat.toFeLong(this.getConverterTrait().getVoltage() * (long)this.getConverterTrait().getAmps(), FeCompat.ratio(false))}));
            } else {
                this.setFeToEu(true);
                playerIn.m_213846_((Component)Component.m_237110_((String)"gtceu.machine.energy_converter.message_conversion_native", (Object[])new Object[]{FeCompat.toFeLong(this.getConverterTrait().getVoltage() * (long)this.getConverterTrait().getAmps(), FeCompat.ratio(true)), this.getConverterTrait().getAmps(), this.getConverterTrait().getVoltage()}));
            }
        }
        return InteractionResult.CONSUME;
    }

    public void setFeToEu(boolean feToEu) {
        this.getConverterTrait().setFeToEu(feToEu);
    }

    public boolean isFeToEu() {
        return this.getConverterTrait().isFeToEu();
    }

    @Override
    public boolean isFacingValid(Direction facing) {
        return true;
    }

    @Override
    public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
        if (toolTypes.contains(GTToolType.SOFT_MALLET)) {
            return this.isFeToEu() ? GuiTextures.TOOL_SWITCH_CONVERTER_NATIVE : GuiTextures.TOOL_SWITCH_CONVERTER_EU;
        }
        return super.sideTips(player, pos, state, toolTypes, side);
    }

    @Override
    protected long getMaxInputOutputAmperage() {
        return this.getConverterTrait().getAmps();
    }

    @Override
    protected boolean isEnergyEmitter() {
        return this.getConverterTrait().isFeToEu();
    }
}

