/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data.machines;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.block.ICoilType;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CoilWorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.registry.registrate.MultiblockMachineBuilder;
import com.gregtechceu.gtceu.common.data.GCYMBlocks;
import com.gregtechceu.gtceu.common.data.GCYMRecipeTypes;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.machines.GTAEMachines;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.DistillationTowerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.ParallelHatchPartMachine;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class GCYMMachines {
    public static final MachineDefinition[] PARALLEL_HATCH = GTMachines.registerTieredMachines("parallel_hatch", ParallelHatchPartMachine::new, (tier, builder) -> builder.langValue((switch (tier) {
        case 5 -> "Elite";
        case 6 -> "Master";
        case 7 -> "Ultimate";
        case 8 -> "Super";
        default -> "Simple";
    }) + " Parallel Control Hatch").rotationState(RotationState.ALL).abilities(PartAbility.PARALLEL_HATCH).workableTieredHullRenderer(GTCEu.id("block/machines/parallel_hatch_mk" + (tier - 4))).tooltips(new Component[]{Component.m_237115_((String)("gtceu.machine.parallel_hatch_mk" + tier + ".tooltip"))}).compassNode("parallel_hatch").register(), 5, 6, 7, 8);
    public static final MultiblockMachineDefinition LARGE_MACERATION_TOWER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_maceration_tower", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Maceration Tower").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.macerator")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.MACERATOR_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_SECURE_MACERATION)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "XGGGX", "XGGGX", "XAAAX").aisle("XXXXX", "XGGGX", "XGGGX", "XAAAX").aisle("XXXXX", "XGGGX", "XGGGX", "XAAAX").aisle("XXXXX", "XXXXX", "XXSXX", "XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_SECURE_MACERATION.get()).setMinGlobalLimited(55).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('G', Predicates.blocks((Block)GCYMBlocks.CRUSHING_WHEELS.get())).where('A', Predicates.air()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/secure_maceration_casing"), GTCEu.id("block/multiblock/gcym/large_maceration_tower")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_CHEMICAL_BATH = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_chemical_bath", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Chemical Bath").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_2.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.ore_washer"), Component.m_237115_((String)"gtceu.chemical_bath")})}).rotationState(RotationState.ALL).recipeTypes(GTRecipeTypes.CHEMICAL_BATH_RECIPES, GTRecipeTypes.ORE_WASHER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_WATERTIGHT)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "XTTTX", "X   X").aisle("XXXXX", "X   X", "X   X").aisle("XXXXX", "X   X", "X   X").aisle("XXXXX", "X   X", "X   X").aisle("XXXXX", "XTTTX", "X   X").aisle("XXXXX", "XXSXX", "XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_WATERTIGHT.get()).setMinGlobalLimited(55).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where(' ', Predicates.air()).where('T', Predicates.blocks((Block)GTBlocks.CASING_TITANIUM_PIPE.get())).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/watertight_casing"), GTCEu.id("block/multiblock/gcym/large_chemical_bath")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_CENTRIFUGE = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_centrifuge", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Centrifugal Unit").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_2.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.centrifuge"), Component.m_237115_((String)"gtceu.thermal_centrifuge")})}).rotationState(RotationState.ALL).recipeTypes(GTRecipeTypes.CENTRIFUGE_RECIPES, GTRecipeTypes.THERMAL_CENTRIFUGE_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_VIBRATION_SAFE)).pattern(definition -> FactoryBlockPattern.start().aisle("#XXX#", "XXXXX", "#XXX#").aisle("XXXXX", "XAPAX", "XXXXX").aisle("XXXXX", "XPAPX", "XXXXX").aisle("XXXXX", "XAPAX", "XXXXX").aisle("#XXX#", "XXSXX", "#XXX#").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_VIBRATION_SAFE.get()).setMinGlobalLimited(40).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('P', Predicates.blocks((Block)GTBlocks.CASING_STEEL_PIPE.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/vibration_safe_casing"), GTCEu.id("block/multiblock/gcym/large_centrifuge")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_MIXER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_mixer", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Mixing Vessel").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.mixer")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.MIXER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_REACTION_SAFE)).pattern(definition -> FactoryBlockPattern.start().aisle("#XXX#", "#XXX#", "#XXX#", "#XXX#", "#XXX#", "##F##").aisle("XXXXX", "XAPAX", "XAAAX", "XAPAX", "XAAAX", "##F##").aisle("XXXXX", "XPPPX", "XAPAX", "XPPPX", "XAGAX", "FFGFF").aisle("XXXXX", "XAPAX", "XAAAX", "XAPAX", "XAAAX", "##F##").aisle("#XXX#", "#XSX#", "#XXX#", "#XXX#", "#XXX#", "##F##").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_REACTION_SAFE.get()).setMinGlobalLimited(50).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('F', Predicates.blocks(ChemicalHelper.getBlock(TagPrefix.frameGt, GTMaterials.HastelloyX))).where('G', Predicates.blocks((Block)GTBlocks.CASING_STAINLESS_STEEL_GEARBOX.get())).where('P', Predicates.blocks((Block)GTBlocks.CASING_TITANIUM_PIPE.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/reaction_safe_mixing_casing"), GTCEu.id("block/multiblock/gcym/large_mixer")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_ELECTROLYZER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_electrolyzer", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Electrolysis Chamber").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.electrolyzer")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.ELECTROLYZER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_NONCONDUCTING)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "XCCCX", "XCCCX").aisle("XXXXX", "XCCCX", "XCCCX").aisle("XXXXX", "XXSXX", "XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_NONCONDUCTING.get()).setMinGlobalLimited(30).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('C', Predicates.blocks((Block)GCYMBlocks.ELECTROLYTIC_CELL.get())).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/nonconducting_casing"), GTCEu.id("block/multiblock/gcym/large_electrolyzer")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_ELECTROMAGNET = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_electromagnet", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Electromagnet").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_2.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.electromagnetic_separator"), Component.m_237115_((String)"gtceu.polarizer")})}).rotationState(RotationState.ALL).recipeTypes(GTRecipeTypes.ELECTROMAGNETIC_SEPARATOR_RECIPES, GTRecipeTypes.POLARIZER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_NONCONDUCTING)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXXXX", "XXXXX").aisle("XCXCX", "XCXCX", "XCXCX").aisle("XCXCX", "XCXCX", "XCXCX").aisle("XXXXX", "XXSXX", "XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_NONCONDUCTING.get()).setMinGlobalLimited(35).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('C', Predicates.blocks((Block)GCYMBlocks.ELECTROLYTIC_CELL.get())).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/nonconducting_casing"), GTCEu.id("block/multiblock/gcym/large_electrolyzer")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_PACKER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_packer", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Packaging Machine").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.packer")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.PACKER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "XAX", "XXX").aisle("XXX", "XAX", "XXX").aisle("XXX", "XAX", "XXX").aisle("XXX", "XAX", "XXX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get()).setMinGlobalLimited(30).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('A', Predicates.air()).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"), GTCEu.id("block/multiblock/gcym/large_packer")).compassSections(GTCompassSections.TIER[3]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_ASSEMBLER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_assembler", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Assembling Factory").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.exact_hatch_1.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.assembler")})}).conditionalTooltip(GTMachines.defaultEnvironmentRequirement(), ConfigHolder.INSTANCE.gameplay.environmentalHazards).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.ASSEMBLER_RECIPES).recipeModifiers(GTRecipeModifiers.DEFAULT_ENVIRONMENT_REQUIREMENT, GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_LARGE_SCALE_ASSEMBLING)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXXXXXX", "XXXXXXXXX", "XXXXXXXXX").aisle("XXXXXXXXX", "XAAAXAAAX", "XGGGXXXXX").aisle("XXXXXXXXX", "XGGGXXSXX", "XGGGX###X").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_LARGE_SCALE_ASSEMBLING.get()).setMinGlobalLimited(40).or(Predicates.autoAbilities(definition.getRecipeTypes(), false, false, true, true, true, true)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setExactLimit(1)).or(Predicates.autoAbilities(true, false, true))).where('G', Predicates.blocks((Block)GTBlocks.CASING_TEMPERED_GLASS.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/large_scale_assembling_casing"), GTCEu.id("block/multiblock/gcym/large_assembler")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_CIRCUIT_ASSEMBLER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_circuit_assembler", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Circuit Assembling Facility").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.circuit_assembler")})}).tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.exact_hatch_1.tooltip")}).conditionalTooltip(GTMachines.defaultEnvironmentRequirement(), ConfigHolder.INSTANCE.gameplay.environmentalHazards).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.CIRCUIT_ASSEMBLER_RECIPES).recipeModifiers(GTRecipeModifiers.DEFAULT_ENVIRONMENT_REQUIREMENT, GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_LARGE_SCALE_ASSEMBLING)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXXXX", "XXXXXXX", "XXXXXXX").aisle("XXXXXXX", "XPPPPPX", "XGGGGGX").aisle("XXXXXXX", "XAAAAPX", "XGGGGGX").aisle("XXXXXXX", "XTTTTXX", "XXXXXXX").aisle("#####XX", "#####SX", "#####XX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_LARGE_SCALE_ASSEMBLING.get()).setMinGlobalLimited(55).or(Predicates.autoAbilities(definition.getRecipeTypes(), false, false, true, true, true, true)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setExactLimit(1)).or(Predicates.autoAbilities(true, false, true))).where('T', Predicates.blocks((Block)GTBlocks.CASING_TEMPERED_GLASS.get())).where('G', Predicates.blocks((Block)GTBlocks.CASING_GRATE.get())).where('P', Predicates.blocks((Block)GTBlocks.CASING_TUNGSTENSTEEL_PIPE.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/large_scale_assembling_casing"), GTCEu.id("block/multiblock/gcym/large_circuit_assembler")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_ARC_SMELTER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_arc_smelter", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Arc Smelter").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.arc_furnace")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.ARC_FURNACE_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING)).pattern(definition -> FactoryBlockPattern.start().aisle("#XXX#", "#XXX#", "#XXX#", "#XXX#").aisle("XXXXX", "XCACX", "XCACX", "XXXXX").aisle("XXXXX", "XAAAX", "XAAAX", "XXMXX").aisle("XXXXX", "XACAX", "XACAX", "XXXXX").aisle("#XXX#", "#XSX#", "#XXX#", "#XXX#").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.get()).setMinGlobalLimited(45).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('C', Predicates.blocks((Block)GCYMBlocks.MOLYBDENUM_DISILICIDE_COIL_BLOCK.get())).where('M', Predicates.abilities(PartAbility.MUFFLER)).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/high_temperature_smelting_casing"), GTCEu.id("block/multiblock/gcym/large_arc_smelter")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_ENGRAVING_LASER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_engraving_laser", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Engraving Laser").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.laser_engraver")})}).conditionalTooltip(GTMachines.defaultEnvironmentRequirement(), ConfigHolder.INSTANCE.gameplay.environmentalHazards).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.LASER_ENGRAVER_RECIPES).recipeModifiers(GTRecipeModifiers.DEFAULT_ENVIRONMENT_REQUIREMENT, GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_LASER_SAFE_ENGRAVING)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXGXX", "XXGXX", "XXXXX").aisle("XXXXX", "XAAAX", "XAAAX", "XKKKX").aisle("XXXXX", "GAAAG", "GACAG", "XKXKX").aisle("XXXXX", "XAAAX", "XAAAX", "XKKKX").aisle("XXSXX", "XXGXX", "XXGXX", "XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('C', Predicates.blocks((Block)GTBlocks.CASING_TUNGSTENSTEEL_PIPE.get())).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_LASER_SAFE_ENGRAVING.get()).setMinGlobalLimited(50).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('G', Predicates.blocks((Block)GTBlocks.CASING_TEMPERED_GLASS.get())).where('K', Predicates.blocks((Block)GTBlocks.CASING_GRATE.get())).where('A', Predicates.air()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/laser_safe_engraving_casing"), GTCEu.id("block/multiblock/gcym/large_engraving_laser")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_SIFTING_FUNNEL = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_sifting_funnel", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Sifting Funnel").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.sifter")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.SIFTER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_VIBRATION_SAFE)).pattern(definition -> FactoryBlockPattern.start().aisle("#X#X#", "#X#X#", "#XXX#", "XXXXX", "#XXX#").aisle("XXXXX", "XAXAX", "XKKKX", "XKKKX", "X###X").aisle("#XXX#", "#XAX#", "XKKKX", "XKKKX", "X###X").aisle("XXXXX", "XAXAX", "XKKKX", "XKKKX", "X###X").aisle("#X#X#", "#X#X#", "#XSX#", "XXXXX", "#XXX#").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_VIBRATION_SAFE.get()).setMinGlobalLimited(50).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('K', Predicates.blocks((Block)GTBlocks.CASING_GRATE.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/vibration_safe_casing"), GTCEu.id("block/multiblock/gcym/large_sifting_funnel")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition BLAST_ALLOY_SMELTER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("alloy_blast_smelter", CoilWorkableElectricMultiblockMachine::new).langValue("Alloy Blast Smelter").tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.alloy_blast_smelter")})}).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.electric_blast_furnace.tooltip.0"), Component.m_237115_((String)"gtceu.machine.electric_blast_furnace.tooltip.1"), Component.m_237115_((String)"gtceu.machine.electric_blast_furnace.tooltip.2")}).rotationState(RotationState.ALL).recipeType(GCYMRecipeTypes.ALLOY_BLAST_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers::ebfOverclock).appearanceBlock((Supplier)GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING)).pattern(definition -> FactoryBlockPattern.start().aisle("#XXX#", "#CCC#", "#GGG#", "#CCC#", "#XXX#").aisle("XXXXX", "CAAAC", "GAAAG", "CAAAC", "XXXXX").aisle("XXXXX", "CAAAC", "GAAAG", "CAAAC", "XXMXX").aisle("XXXXX", "CAAAC", "GAAAG", "CAAAC", "XXXXX").aisle("#XSX#", "#CCC#", "#GGG#", "#CCC#", "#XXX#").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.get()).setMinGlobalLimited(30).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, false))).where('C', Predicates.heatingCoils()).where('M', Predicates.abilities(PartAbility.MUFFLER)).where('G', Predicates.blocks((Block)GCYMBlocks.HEAT_VENT.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).shapeInfos(definition -> {
        ArrayList shapeInfo = new ArrayList();
        MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"#XSX#", "#CCC#", "#GGG#", "#CCC#", "#XMX#"})).aisle(new String[]{"IXXXX", "CAAAC", "GAAAG", "CAAAC", "XXXXX"})).aisle(new String[]{"XXXXD", "CAAAC", "GAAAG", "CAAAC", "XXHXX"})).aisle(new String[]{"FXXXX", "CAAAC", "GAAAG", "CAAAC", "XXXXX"})).aisle(new String[]{"#EXE#", "#CCC#", "#GGG#", "#CCC#", "#XXX#"})).where('X', GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.getDefaultState()).where('S', (Supplier<? extends IMachineBlock>)definition, Direction.NORTH).where('G', GCYMBlocks.HEAT_VENT.getDefaultState()).where('A', Blocks.f_50016_.m_49966_()).where('E', GTMachines.ENERGY_INPUT_HATCH[1], Direction.SOUTH).where('I', GTMachines.ITEM_IMPORT_BUS[1], Direction.WEST).where('F', GTMachines.FLUID_IMPORT_HATCH[1], Direction.WEST).where('D', GTMachines.FLUID_EXPORT_HATCH[1], Direction.EAST).where('H', GTMachines.MUFFLER_HATCH[1], Direction.UP).where('M', GTMachines.MAINTENANCE_HATCH, Direction.NORTH);
        GTCEuAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ICoilType)entry.getKey()).getTier())).forEach(coil -> shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('C', (Block)((Supplier)coil.getValue()).get()).build()));
        return shapeInfo;
    }).workableCasingRenderer(GTCEu.id("block/casings/gcym/high_temperature_smelting_casing"), GTCEu.id("block/multiblock/gcym/blast_alloy_smelter")).additionalDisplay((controller, components) -> {
        if (controller instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)controller;
            if (controller.isFormed()) {
                components.add(Component.m_237110_((String)"gtceu.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{Component.m_237115_((String)(FormattingUtil.formatNumbers((long)coilMachine.getCoilType().getCoilTemperature() + 100L * (long)Math.max(0, coilMachine.getTier() - 2)) + "K")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))}));
            }
        }
    }).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_AUTOCLAVE = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_autoclave", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Crystallization Chamber").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.autoclave")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.AUTOCLAVE_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_WATERTIGHT)).pattern(definition -> FactoryBlockPattern.start().aisle("XXX", "XXX", "XXX").aisle("XXX", "XTX", "XXX").aisle("XXX", "XTX", "XXX").aisle("XXX", "XTX", "XXX").aisle("XXX", "XSX", "XXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_WATERTIGHT.get()).setMinGlobalLimited(30).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('T', Predicates.blocks((Block)GTBlocks.CASING_STEEL_PIPE.get())).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/watertight_casing"), GTCEu.id("block/multiblock/gcym/large_autoclave")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_MATERIAL_PRESS = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_material_press", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Material Press").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_4.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.bender"), Component.m_237115_((String)"gtceu.compressor"), Component.m_237115_((String)"gtceu.forge_hammer"), Component.m_237115_((String)"gtceu.forming_press")})}).rotationState(RotationState.ALL).recipeTypes(GTRecipeTypes.BENDER_RECIPES, GTRecipeTypes.COMPRESSOR_RECIPES, GTRecipeTypes.FORGE_HAMMER_RECIPES, GTRecipeTypes.FORMING_PRESS_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_STRESS_PROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXXXX", "XXXXXXX", "XXXXXXX").aisle("XXXXXXX", "XAXGGGX", "XXXXXXX").aisle("XXXXXXX", "XSXCCCX", "XXXXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_STRESS_PROOF.get()).setMinGlobalLimited(40).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('G', Predicates.blocks((Block)GTBlocks.CASING_STEEL_GEARBOX.get())).where('C', Predicates.blocks((Block)GTBlocks.CASING_TEMPERED_GLASS.get())).where('A', Predicates.air()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/stress_proof_casing"), GTCEu.id("block/multiblock/gcym/large_material_press")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_BREWER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_brewer", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Brewing Vat").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_3.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.brewery"), Component.m_237115_((String)"gtceu.fermenter"), Component.m_237115_((String)"gtceu.fluid_heater")})}).rotationState(RotationState.ALL).recipeTypes(GTRecipeTypes.BREWING_RECIPES, GTRecipeTypes.FERMENTING_RECIPES, GTRecipeTypes.FLUID_HEATER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_CORROSION_PROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("#XXX#", "#XXX#", "#XXX#", "#XXX#", "#####").aisle("XXXXX", "XCCCX", "XAAAX", "XXAXX", "##X##").aisle("XXXXX", "XCPCX", "XAPAX", "XAPAX", "#XMX#").aisle("XXXXX", "XCCCX", "XAAAX", "XXAXX", "##X##").aisle("#XXX#", "#XSX#", "#XXX#", "#XXX#", "#####").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_CORROSION_PROOF.get()).setMinGlobalLimited(50).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('P', Predicates.blocks((Block)GTBlocks.CASING_STEEL_PIPE.get())).where('C', Predicates.blocks((Block)GCYMBlocks.MOLYBDENUM_DISILICIDE_COIL_BLOCK.get())).where('M', Predicates.abilities(PartAbility.MUFFLER)).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/corrosion_proof_casing"), GTCEu.id("block/multiblock/gcym/large_brewer")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_CUTTER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_cutter", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Cutting Saw").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_2.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.cutter"), Component.m_237115_((String)"gtceu.lathe")})}).rotationState(RotationState.ALL).recipeTypes(GTRecipeTypes.CUTTER_RECIPES, GTRecipeTypes.LATHE_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_SHOCK_PROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXXXX", "XXXXXXX", "XXXXXXX", "##XXXXX").aisle("XXXXXXX", "XAXCCCX", "XXXAAAX", "##XXXXX").aisle("XXXXXXX", "XAXCCCX", "XXXAAAX", "##XXXXX").aisle("XXXXXXX", "XSXGGGX", "XXXGGGX", "##XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_SHOCK_PROOF.get()).setMinGlobalLimited(65).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('G', Predicates.blocks((Block)GTBlocks.CASING_TEMPERED_GLASS.get())).where('C', Predicates.blocks((Block)GCYMBlocks.SLICING_BLADES.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/shock_proof_cutting_casing"), GTCEu.id("block/multiblock/gcym/large_cutter")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_DISTILLERY = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_distillery", DistillationTowerMachine::new).langValue("Large Fractionating Distillery").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_2.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.distillation_tower"), Component.m_237115_((String)"gtceu.distillery")})}).rotationState(RotationState.NON_Y_AXIS).recipeTypes(GTRecipeTypes.DISTILLATION_RECIPES, GTRecipeTypes.DISTILLERY_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_WATERTIGHT)).pattern(definition -> {
        TraceabilityPredicate casingPredicate = Predicates.blocks((Block)GCYMBlocks.CASING_WATERTIGHT.get()).setMinGlobalLimited(40);
        TraceabilityPredicate exportPredicate = Predicates.abilities(PartAbility.EXPORT_FLUIDS_1X);
        if (GTCEu.isAE2Loaded()) {
            exportPredicate = exportPredicate.or(Predicates.blocks(GTAEMachines.FLUID_EXPORT_HATCH_ME.get()));
        }
        exportPredicate.setMaxLayerLimited(1);
        return FactoryBlockPattern.start(RelativeDirection.RIGHT, RelativeDirection.BACK, RelativeDirection.UP).aisle("#YYY#", "YYYYY", "YYYYY", "YYYYY", "#YYY#").aisle("#YSY#", "YAAAY", "YAAAY", "YAAAY", "#YYY#").aisle("##X##", "#XAX#", "XAPAX", "#XAX#", "##X##").setRepeatable(1, 12).aisle("#####", "#ZZZ#", "#ZCZ#", "#ZZZ#", "#####").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('Y', casingPredicate.or(Predicates.abilities(PartAbility.IMPORT_ITEMS)).or(Predicates.abilities(PartAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(2)).or(Predicates.abilities(PartAbility.IMPORT_FLUIDS).setMinGlobalLimited(1)).or(Predicates.abilities(PartAbility.EXPORT_ITEMS)).or(Predicates.autoAbilities(true, false, true))).where('X', casingPredicate.or(exportPredicate)).where('Z', casingPredicate).where('P', Predicates.blocks((Block)GTBlocks.CASING_STEEL_PIPE.get())).where('C', Predicates.abilities(PartAbility.MUFFLER)).where('A', Predicates.air()).where('#', Predicates.any()).build();
    }).shapeInfos(definition -> {
        ArrayList<MultiblockShapeInfo> shapeInfos = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.ShapeInfoBuilder builder = MultiblockShapeInfo.builder().where('S', (Supplier<? extends IMachineBlock>)definition, Direction.NORTH).where('C', GCYMBlocks.CASING_WATERTIGHT.getDefaultState()).where('M', GTMachines.MUFFLER_HATCH[5], Direction.UP).where('X', PARALLEL_HATCH[5], Direction.NORTH).where('H', GTMachines.FLUID_IMPORT_HATCH[5], Direction.NORTH).where('B', GTMachines.ITEM_EXPORT_BUS[5], Direction.NORTH).where('N', GTMachines.MAINTENANCE_HATCH, Direction.NORTH).where('P', GTBlocks.CASING_STEEL_PIPE.getDefaultState()).where('F', GTMachines.FLUID_EXPORT_HATCH[5], Direction.SOUTH).where('E', GTMachines.ENERGY_INPUT_HATCH[5], Direction.SOUTH).where('#', Blocks.f_50016_.m_49966_());
        ArrayList<String> aisle1 = new ArrayList<String>(16);
        aisle1.add("#HCB#");
        aisle1.add("#NSX#");
        aisle1.add("#####");
        ArrayList<String> aisle2 = new ArrayList<String>(16);
        aisle2.add("CCCCC");
        aisle2.add("C###C");
        aisle2.add("#CCC#");
        ArrayList<String> aisle3 = new ArrayList<String>(16);
        aisle3.add("CCCCC");
        aisle3.add("C###C");
        aisle3.add("#CMC#");
        ArrayList<String> aisle4 = new ArrayList<String>(16);
        aisle4.add("CCCCC");
        aisle4.add("C###C");
        aisle4.add("#CCC#");
        ArrayList<String> aisle5 = new ArrayList<String>(16);
        aisle5.add("#CEC#");
        aisle5.add("#CCC#");
        aisle5.add("#####");
        for (int i = 1; i <= 12; ++i) {
            aisle1.add(2, "##C##");
            aisle2.add(2, "#C#C#");
            aisle3.add(2, "C#P#C");
            aisle4.add(2, "#C#C#");
            aisle5.add(2, "##F##");
            MultiblockShapeInfo.ShapeInfoBuilder copy = (MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).aisle((String[])aisle1.toArray(String[]::new))).aisle((String[])aisle2.toArray(String[]::new))).aisle((String[])aisle3.toArray(String[]::new))).aisle((String[])aisle4.toArray(String[]::new))).aisle((String[])aisle5.toArray(String[]::new));
            shapeInfos.add(copy.build());
        }
        return shapeInfos;
    }).partSorter(Comparator.comparingInt(a -> a.self().getPos().m_123342_())).workableCasingRenderer(GTCEu.id("block/casings/gcym/watertight_casing"), GTCEu.id("block/multiblock/gcym/large_distillery")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_EXTRACTOR = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_extractor", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Extraction Machine").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_2.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.extractor"), Component.m_237115_((String)"gtceu.canner")})}).rotationState(RotationState.ALL).recipeTypes(GTRecipeTypes.EXTRACTOR_RECIPES, GTRecipeTypes.CANNER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_WATERTIGHT)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "XCACX", "XXXXX").aisle("XXXXX", "XXSXX", "XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_WATERTIGHT.get()).setMinGlobalLimited(25).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('C', Predicates.blocks((Block)GTBlocks.CASING_STEEL_PIPE.get())).where('A', Predicates.air()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/watertight_casing"), GTCEu.id("block/multiblock/gcym/large_extractor")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_EXTRUDER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_extruder", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Extrusion Machine").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.extruder")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.EXTRUDER_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_STRESS_PROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("##XXX", "##XXX", "##XXX").aisle("##XXX", "##XPX", "##XGX").setRepeatable(2).aisle("XXXXX", "XXXPX", "XXXGX").aisle("XXXXX", "XAXPX", "XXXGX").aisle("XXXXX", "XSXXX", "XXXXX").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_STRESS_PROOF.get()).setMinGlobalLimited(40).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('P', Predicates.blocks((Block)GTBlocks.CASING_TITANIUM_PIPE.get())).where('G', Predicates.blocks((Block)GTBlocks.CASING_TEMPERED_GLASS.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/stress_proof_casing"), GTCEu.id("block/multiblock/gcym/large_extruder")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_SOLIDIFIER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_solidifier", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Solidification Array").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.fluid_solidifier")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_WATERTIGHT)).pattern(definition -> FactoryBlockPattern.start().aisle("#XXX#", "#XXX#", "#XXX#", "#XXX#").aisle("XXXXX", "XCACX", "XCACX", "XXXXX").aisle("XXXXX", "XAAAX", "XAAAX", "XXXXX").aisle("XXXXX", "XCACX", "XCACX", "XXXXX").aisle("#XXX#", "#XSX#", "#XXX#", "#XXX#").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_WATERTIGHT.get()).setMinGlobalLimited(45).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('C', Predicates.blocks((Block)GTBlocks.CASING_STEEL_PIPE.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/watertight_casing"), GTCEu.id("block/multiblock/gcym/large_solidifier")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition LARGE_WIREMILL = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("large_wiremill", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Large Wire Factory").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.wiremill")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.WIREMILL_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GCYMBlocks.CASING_STRESS_PROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXX", "XXXXX", "XXX##").aisle("XXXXX", "X#CCX", "XXXXX").aisle("XXXXX", "XSXXX", "XXX##").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GCYMBlocks.CASING_STRESS_PROOF.get()).setMinGlobalLimited(25).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('C', Predicates.blocks((Block)GTBlocks.CASING_TITANIUM_GEARBOX.get())).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/gcym/stress_proof_casing"), GTCEu.id("block/multiblock/gcym/large_wiremill")).compassSections(GTCompassSections.TIER[5]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition MEGA_BLAST_FURNACE = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("mega_blast_furnace", CoilWorkableElectricMultiblockMachine::new).langValue("Rotary Hearth Furnace").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.electric_blast_furnace")})}).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.electric_blast_furnace.tooltip.0"), Component.m_237115_((String)"gtceu.machine.electric_blast_furnace.tooltip.1"), Component.m_237115_((String)"gtceu.machine.electric_blast_furnace.tooltip.2")}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.BLAST_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers::ebfOverclock).appearanceBlock((Supplier)GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING)).pattern(definition -> {
        TraceabilityPredicate casing = Predicates.blocks((Block)GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.get()).setMinGlobalLimited(360);
        return FactoryBlockPattern.start().aisle("##XXXXXXXXX##", "##XXXXXXXXX##", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############").aisle("#XXXXXXXXXXX#", "#XXXXXXXXXXX#", "###F#####F###", "###F#####F###", "###FFFFFFF###", "#############", "#############", "#############", "#############", "#############", "####FFFFF####", "#############", "#############", "#############", "#############", "#############", "#############").aisle("XXXXXXXXXXXXX", "XXXXVVVVVXXXX", "##F#######F##", "##F#######F##", "##FFFHHHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHHHFFF##", "#############", "#############", "#############", "#############", "#############", "###TTTTTTT###").aisle("XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "######P######", "######P######", "######P######", "######P######", "######P######", "##FHHHPHHHF##", "######P######", "######P######", "######P######", "######P######", "######P######", "##TTTTPTTTT##").aisle("XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BBPBB####", "####TITIT####", "#FFHHHHHHHFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "#FFHHHHHHHFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "##TTTTPTTTT##").aisle("XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BAAAB####", "####IAAAI####", "#FHHHAAAHHHF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "#FHHHAAAHHHF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "##TTTTPTTTT##").aisle("XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "###PPAAAPP###", "###PTAAATP###", "#FHPHAAAHPHF#", "###PTAAATP###", "###PCAAACP###", "###PCAAACP###", "###PCAAACP###", "###PTAAATP###", "#FHPHAAAHPHF#", "###PTAAATP###", "###PCAAACP###", "###PCAAACP###", "###PCAAACP###", "###PTAAATP###", "##TPPPMPPPT##").aisle("XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BAAAB####", "####IAAAI####", "#FHHHAAAHHHF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "#FHHHAAAHHHF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "##TTTTPTTTT##").aisle("XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BBPBB####", "####TITIT####", "#FFHHHHHHHFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "#FFHHHHHHHFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "##TTTTPTTTT##").aisle("XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "#F####P####F#", "#F####P####F#", "#FFHHHPHHHFF#", "######P######", "######P######", "######P######", "######P######", "######P######", "##FHHHPHHHF##", "######P######", "######P######", "######P######", "######P######", "######P######", "##TTTTPTTTT##").aisle("XXXXXXXXXXXXX", "XXXXVVVVVXXXX", "##F#######F##", "##F#######F##", "##FFFHHHFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFHHHFFF##", "#############", "#############", "#############", "#############", "#############", "###TTTTTTT###").aisle("#XXXXXXXXXXX#", "#XXXXXXXXXXX#", "###F#####F###", "###F#####F###", "###FFFFFFF###", "#############", "#############", "#############", "#############", "#############", "####FFFFF####", "#############", "#############", "#############", "#############", "#############", "#############").aisle("##XXXXXXXXX##", "##XXXXSXXXX##", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', casing.or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('C', Predicates.heatingCoils()).where('M', Predicates.abilities(PartAbility.MUFFLER)).where('F', Predicates.blocks(ChemicalHelper.getBlock(TagPrefix.frameGt, GTMaterials.NaquadahAlloy))).where('H', casing).where('T', Predicates.blocks((Block)GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get())).where('B', Predicates.blocks((Block)GTBlocks.FIREBOX_TUNGSTENSTEEL.get())).where('P', Predicates.blocks((Block)GTBlocks.CASING_TUNGSTENSTEEL_PIPE.get())).where('I', Predicates.blocks((Block)GTBlocks.CASING_EXTREME_ENGINE_INTAKE.get())).where('V', Predicates.blocks((Block)GCYMBlocks.HEAT_VENT.get())).where('A', Predicates.air()).where('#', Predicates.any()).build();
    }).shapeInfos(definition -> {
        ArrayList shapeInfo = new ArrayList();
        MultiblockShapeInfo.ShapeInfoBuilder builder = ((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)((MultiblockShapeInfo.ShapeInfoBuilder)MultiblockShapeInfo.builder().aisle(new String[]{"##XODXXXQLX##", "##XXXXSXXXX##", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############"})).aisle(new String[]{"#XXXXXXXXXXX#", "#XXXXXXXXXXX#", "###F#####F###", "###F#####F###", "###FFFFFFF###", "#############", "#############", "#############", "#############", "#############", "####FFFFF####", "#############", "#############", "#############", "#############", "#############", "#############"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXVVVVVXXXX", "##F#######F##", "##F#######F##", "##FFFXXXFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFXXXFFF##", "#############", "#############", "#############", "#############", "#############", "###TTTTTTT###"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "#F####P####F#", "#F####P####F#", "#FFXXXPXXXFF#", "######P######", "######P######", "######P######", "######P######", "######P######", "##FXXXPXXXF##", "######P######", "######P######", "######P######", "######P######", "######P######", "##TTTTPTTTT##"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BBPBB####", "####TITIT####", "#FFXXXXXXXFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "#FFXXXXXXXFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "##TTTTPTTTT##"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BAAAB####", "####IAAAI####", "#FXXXAAAXXXF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "#FXXXAAAXXXF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "##TTTTPTTTT##"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "###PPAAAPP###", "###PTAAATP###", "#FXPXAAAXPXF#", "###PTAAATP###", "###PCAAACP###", "###PCAAACP###", "###PCAAACP###", "###PTAAATP###", "#FXPXAAAXPXF#", "###PTAAATP###", "###PCAAACP###", "###PCAAACP###", "###PCAAACP###", "###PTAAATP###", "##TPPPHPPPT##"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BAAAB####", "####IAAAI####", "#FXXXAAAXXXF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "#FXXXAAAXXXF#", "####IAAAI####", "####CAAAC####", "####CAAAC####", "####CAAAC####", "####IAAAI####", "##TTTTPTTTT##"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXVXXXXXXXVXX", "####BBPBB####", "####TITIT####", "#FFXXXXXXXFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "#FFXXXXXXXFF#", "####BITIB####", "####CCCCC####", "####CCCCC####", "####CCCCC####", "####BITIB####", "##TTTTPTTTT##"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXXXXXXXXXX", "#F####P####F#", "#F####P####F#", "#FFXXXPXXXFF#", "######P######", "######P######", "######P######", "######P######", "######P######", "##FXXXPXXXF##", "######P######", "######P######", "######P######", "######P######", "######P######", "##TTTTPTTTT##"})).aisle(new String[]{"XXXXXXXXXXXXX", "XXXXVVVVVXXXX", "##F#######F##", "##F#######F##", "##FFFXXXFFF##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##F#######F##", "##FFFXXXFFF##", "#############", "#############", "#############", "#############", "#############", "###TTTTTTT###"})).aisle(new String[]{"#XXXXXXXXXXX#", "#XXXXXXXXXXX#", "###F#####F###", "###F#####F###", "###FFFFFFF###", "#############", "#############", "#############", "#############", "#############", "####FFFFF####", "#############", "#############", "#############", "#############", "#############", "#############"})).aisle(new String[]{"##XXXEMEXXX##", "##XXXXXXXXX##", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############", "#############"})).where('X', GCYMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.getDefaultState()).where('S', (Supplier<? extends IMachineBlock>)definition, Direction.NORTH).where('A', Blocks.f_50016_.m_49966_()).where('T', GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.getDefaultState()).where('B', GTBlocks.FIREBOX_TUNGSTENSTEEL.getDefaultState()).where('P', GTBlocks.CASING_TUNGSTENSTEEL_PIPE.getDefaultState()).where('I', GTBlocks.CASING_EXTREME_ENGINE_INTAKE.getDefaultState()).where('F', ChemicalHelper.getBlock(TagPrefix.frameGt, GTMaterials.NaquadahAlloy)).where('V', GCYMBlocks.HEAT_VENT.getDefaultState()).where('E', GTMachines.ENERGY_INPUT_HATCH[1], Direction.SOUTH).where('L', GTMachines.ITEM_IMPORT_BUS[1], Direction.NORTH).where('O', GTMachines.ITEM_EXPORT_BUS[1], Direction.NORTH).where('Q', GTMachines.FLUID_IMPORT_HATCH[1], Direction.NORTH).where('D', GTMachines.FLUID_EXPORT_HATCH[1], Direction.NORTH).where('H', GTMachines.MUFFLER_HATCH[1], Direction.UP).where('M', GTMachines.MAINTENANCE_HATCH, Direction.SOUTH);
        GTCEuAPI.HEATING_COILS.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((ICoilType)entry.getKey()).getTier())).forEach(coil -> shapeInfo.add(((MultiblockShapeInfo.ShapeInfoBuilder)builder.shallowCopy()).where('C', (Block)((Supplier)coil.getValue()).get()).build()));
        return shapeInfo;
    }).workableCasingRenderer(GTCEu.id("block/casings/gcym/high_temperature_smelting_casing"), GTCEu.id("block/multiblock/gcym/mega_blast_furnace")).additionalDisplay((controller, components) -> {
        if (controller instanceof CoilWorkableElectricMultiblockMachine) {
            CoilWorkableElectricMultiblockMachine coilMachine = (CoilWorkableElectricMultiblockMachine)controller;
            if (controller.isFormed()) {
                components.add(Component.m_237110_((String)"gtceu.multiblock.blast_furnace.max_temperature", (Object[])new Object[]{Component.m_237115_((String)(FormattingUtil.formatNumbers((long)coilMachine.getCoilType().getCoilTemperature() + 100L * (long)Math.max(0, coilMachine.getTier() - 2)) + "K")).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))}));
            }
        }
    }).compassSections(GTCompassSections.TIER[6]).compassNodeSelf().register();
    public static final MultiblockMachineDefinition MEGA_VACUUM_FREEZER = ((MultiblockMachineBuilder)GTRegistration.REGISTRATE.multiblock("mega_vacuum_freezer", x$0 -> new WorkableElectricMultiblockMachine((IMachineBlockEntity)x$0, new Object[0])).langValue("Bulk Blast Chiller").tooltips(new Component[]{Component.m_237115_((String)"gtceu.multiblock.parallelizable.tooltip")}).tooltips(new Component[]{Component.m_237110_((String)"gtceu.machine.available_recipe_map_1.tooltip", (Object[])new Object[]{Component.m_237115_((String)"gtceu.vacuum_freezer")})}).rotationState(RotationState.ALL).recipeType(GTRecipeTypes.VACUUM_RECIPES).recipeModifiers(GTRecipeModifiers.PARALLEL_HATCH, GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK_SUBTICK)).appearanceBlock((Supplier)GTBlocks.CASING_ALUMINIUM_FROSTPROOF)).pattern(definition -> FactoryBlockPattern.start().aisle("XXXXXXX#KKK", "XXXXXXX#KVK", "XXXXXXX#KVK", "XXXXXXX#KVK", "XXXXXXX#KKK", "XXXXXXX####", "XXXXXXX####").aisle("XXXXXXX#KVK", "XPPPPPPPPPV", "XPAPAPX#VPV", "XPPPPPPPPPV", "XPAPAPX#KVK", "XPPPPPX####", "XXXXXXX####").aisle("XXXXXXX#KVK", "XPAPAPXAVPV", "XAAAAAX#VPV", "XPAAAPX#VPV", "XAAAAAX#KVK", "XPAPAPX####", "XXXXXXX####").aisle("XXXXXXX#KVK", "XPAPAPPPPPV", "XAAAAAX#VPV", "XPAAAPPPPPV", "XAAAAAX#KVK", "XPAPAPX####", "XXXXXXX####").aisle("XXXXXXX#KKK", "XPPPPPX#KVK", "XPA#APX#KVK", "XPAAAPX#KVK", "XPAAAPX#KKK", "XPPPPPX####", "XXXXXXX####").aisle("#XXXXX#####", "#XXSXX#####", "#XGGGX#####", "#XGGGX#####", "#XGGGX#####", "#XXXXX#####", "###########").where('S', Predicates.controller(Predicates.blocks(definition.get()))).where('X', Predicates.blocks((Block)GTBlocks.CASING_ALUMINIUM_FROSTPROOF.get()).setMinGlobalLimited(140).or(Predicates.autoAbilities(definition.getRecipeTypes())).or(Predicates.autoAbilities(true, false, true))).where('G', Predicates.blocks((Block)GTBlocks.CASING_TEMPERED_GLASS.get())).where('K', Predicates.blocks((Block)GTBlocks.CASING_STAINLESS_CLEAN.get())).where('P', Predicates.blocks((Block)GTBlocks.CASING_TUNGSTENSTEEL_PIPE.get())).where('V', Predicates.blocks((Block)GCYMBlocks.HEAT_VENT.get())).where('A', Predicates.air()).where('#', Predicates.any()).build()).workableCasingRenderer(GTCEu.id("block/casings/solid/machine_casing_frost_proof"), GTCEu.id("block/multiblock/gcym/mega_vacuum_freezer")).compassSections(GTCompassSections.TIER[6]).compassNodeSelf().register();

    public static void init() {
    }
}

