/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.voiding;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidVoidingCover
extends PumpCover {
    @Persisted
    protected boolean isEnabled = false;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidVoidingCover.class, PumpCover.MANAGED_FIELD_HOLDER);

    public FluidVoidingCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide, 0);
    }

    @Override
    protected boolean isSubscriptionActive() {
        return this.isWorkingEnabled() && this.isEnabled();
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 5L != 0L) {
            return;
        }
        this.doVoidFluids();
        this.subscriptionHandler.updateSubscription();
    }

    protected void doVoidFluids() {
        IFluidHandlerModifiable fluidHandler = this.getOwnFluidHandler();
        if (fluidHandler == null) {
            return;
        }
        this.voidAny(fluidHandler);
    }

    void voidAny(IFluidHandlerModifiable fluidHandler) {
        Map<FluidStack, Integer> fluidAmounts = this.enumerateDistinctFluids(fluidHandler, PumpCover.TransferDirection.EXTRACT);
        for (FluidStack fluidStack : fluidAmounts.keySet()) {
            if (!this.filterHandler.test(fluidStack)) continue;
            FluidStack toDrain = fluidStack.copy();
            toDrain.setAmount(fluidAmounts.get(fluidStack).intValue());
            fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.isWorkingEnabled = workingEnabled;
        this.subscriptionHandler.updateSubscription();
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.subscriptionHandler.updateSubscription();
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 120);
        group.addWidget((Widget)new LabelWidget(10, 5, this.getUITitle()));
        group.addWidget((Widget)new ToggleButtonWidget(10, 20, 20, 20, (IGuiTexture)GuiTextures.BUTTON_POWER, this::isEnabled, this::setEnabled));
        group.addWidget(this.filterHandler.createFilterSlotUI(148, 91));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 50, 126, 60));
        this.buildAdditionalUI(group);
        return group;
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.fluid.voiding.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
    }

    @Override
    protected void configureFilter() {
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }
}

