/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.IEnergyInfoProvider;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public class EnergyDetectorCover
extends DetectorCover {
    public EnergyDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public boolean canAttach() {
        return this.getEnergyInfoProvider() != null;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        IEnergyInfoProvider energyInfoProvider = this.getEnergyInfoProvider();
        if (energyInfoProvider == null) {
            return;
        }
        IEnergyInfoProvider.EnergyInfo energyInfo = energyInfoProvider.getEnergyInfo();
        long storedEnergy = energyInfo.stored().longValue();
        long energyCapacity = energyInfo.capacity().longValue();
        if (energyCapacity == 0L) {
            return;
        }
        this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneValue(storedEnergy, energyCapacity, this.isInverted()));
    }

    @Nullable
    protected IEnergyInfoProvider getEnergyInfoProvider() {
        return GTCapabilityHelper.getEnergyInfoProvider(this.coverHolder.getLevel(), this.coverHolder.getPos(), this.attachedSide);
    }
}

