/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleFluidFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.NumberInputWidget;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.data.BucketMode;
import com.gregtechceu.gtceu.common.cover.data.TransferMode;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class FluidRegulatorCover
extends PumpCover {
    private static final int MAX_STACK_SIZE = 2048000000;
    @Persisted
    @DescSynced
    private TransferMode transferMode = TransferMode.TRANSFER_ANY;
    @Persisted
    @DescSynced
    private BucketMode transferBucketMode = BucketMode.MILLI_BUCKET;
    @Persisted
    @DescSynced
    protected int globalTransferSizeMillibuckets;
    protected int fluidTransferBuffered = 0;
    private NumberInputWidget<Integer> transferSizeInput;
    private EnumSelectorWidget<BucketMode> transferBucketModeInput;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidRegulatorCover.class, PumpCover.MANAGED_FIELD_HOLDER);

    public FluidRegulatorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        super(definition, coverHolder, attachedSide, tier);
    }

    @Override
    protected int doTransferFluidsInternal(IFluidHandlerModifiable source, IFluidHandlerModifiable destination, int platformTransferLimit) {
        return switch (this.transferMode) {
            default -> throw new IncompatibleClassChangeError();
            case TransferMode.TRANSFER_ANY -> this.transferAny(source, destination, platformTransferLimit);
            case TransferMode.TRANSFER_EXACT -> this.transferExact(source, destination, platformTransferLimit);
            case TransferMode.KEEP_EXACT -> this.keepExact(source, destination, platformTransferLimit);
        };
    }

    private int transferExact(IFluidHandler source, IFluidHandler destination, int platformTransferLimit) {
        int fluidLeftToTransfer = platformTransferLimit;
        for (int slot = 0; slot < source.getTanks() && fluidLeftToTransfer > 0; ++slot) {
            int insertableAmount;
            FluidStack sourceFluid = source.getFluidInTank(slot).copy();
            int supplyAmount = this.getFilteredFluidAmount(sourceFluid);
            if (fluidLeftToTransfer + this.fluidTransferBuffered < supplyAmount) {
                this.fluidTransferBuffered += fluidLeftToTransfer;
                fluidLeftToTransfer = 0;
                break;
            }
            if (sourceFluid.isEmpty() || supplyAmount <= 0) continue;
            sourceFluid.setAmount(supplyAmount);
            FluidStack drained = source.drain(sourceFluid, IFluidHandler.FluidAction.SIMULATE);
            if (drained.isEmpty() || drained.getAmount() < supplyAmount || (insertableAmount = destination.fill(drained.copy(), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            drained.setAmount(insertableAmount);
            drained = source.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            if (!drained.isEmpty()) {
                destination.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                fluidLeftToTransfer -= drained.getAmount() - this.fluidTransferBuffered;
            }
            this.fluidTransferBuffered = 0;
        }
        return platformTransferLimit - fluidLeftToTransfer;
    }

    private int keepExact(IFluidHandlerModifiable source, IFluidHandlerModifiable destination, int platformTransferLimit) {
        int fluidLeftToTransfer = platformTransferLimit;
        Map<FluidStack, Integer> sourceAmounts = this.enumerateDistinctFluids(source, PumpCover.TransferDirection.EXTRACT);
        Map<FluidStack, Integer> destinationAmounts = this.enumerateDistinctFluids(destination, PumpCover.TransferDirection.INSERT);
        for (FluidStack fluidStack : sourceAmounts.keySet()) {
            FluidStack drained;
            int fillableAmount;
            if (fluidLeftToTransfer <= 0) break;
            int amountToKeep = this.getFilteredFluidAmount(fluidStack);
            int amountInDest = destinationAmounts.getOrDefault(fluidStack, 0);
            if (amountInDest >= amountToKeep) continue;
            FluidStack fluidToMove = fluidStack.copy();
            fluidToMove.setAmount(Math.min(fluidLeftToTransfer, amountToKeep - amountInDest));
            if (fluidToMove.getAmount() <= 0 || (fillableAmount = destination.fill(drained = source.drain(fluidToMove, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            fluidToMove.setAmount(Math.min(fluidToMove.getAmount(), fillableAmount));
            drained = source.drain(fluidToMove, IFluidHandler.FluidAction.EXECUTE);
            int movedAmount = destination.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            fluidLeftToTransfer -= movedAmount;
        }
        return platformTransferLimit - fluidLeftToTransfer;
    }

    private void setTransferBucketMode(BucketMode transferBucketMode) {
        int oldMultiplier = this.transferBucketMode.multiplier;
        int newMultiplier = transferBucketMode.multiplier;
        this.transferBucketMode = transferBucketMode;
        if (this.transferSizeInput == null) {
            return;
        }
        if (oldMultiplier > newMultiplier) {
            this.transferSizeInput.setValue(this.getCurrentBucketModeTransferSize());
        }
        this.transferSizeInput.setMax(2048000000 / this.transferBucketMode.multiplier);
        if (newMultiplier > oldMultiplier) {
            this.transferSizeInput.setValue(this.getCurrentBucketModeTransferSize());
        }
    }

    private void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.configureTransferSizeInput();
        if (!this.isRemote()) {
            this.configureFilter();
        }
    }

    @Override
    protected void configureFilter() {
        Object f = this.filterHandler.getFilter();
        if (f instanceof SimpleFluidFilter) {
            SimpleFluidFilter filter = (SimpleFluidFilter)f;
            filter.setMaxStackSize(this.transferMode == TransferMode.TRANSFER_ANY ? 1 : 2048000000);
        }
        this.configureTransferSizeInput();
    }

    private int getFilteredFluidAmount(FluidStack fluidStack) {
        if (!this.filterHandler.isFilterPresent()) {
            return this.globalTransferSizeMillibuckets;
        }
        FluidFilter filter = (FluidFilter)this.filterHandler.getFilter();
        return filter.supportsAmounts() ? filter.testFluidAmount(fluidStack) : this.globalTransferSizeMillibuckets;
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.fluid_regulator.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
        group.addWidget((Widget)new EnumSelectorWidget(146, 45, 20, 20, (Enum[])TransferMode.values(), (Enum)this.transferMode, this::setTransferMode));
        this.transferSizeInput = new IntInputWidget(35, 45, 84, 20, this::getCurrentBucketModeTransferSize, this::setCurrentBucketModeTransferSize).setMin(0).setMax(Integer.MAX_VALUE);
        this.configureTransferSizeInput();
        group.addWidget(this.transferSizeInput);
        this.transferBucketModeInput = new EnumSelectorWidget(121, 45, 20, 20, (Enum[])BucketMode.values(), (Enum)this.transferBucketMode, this::setTransferBucketMode);
        group.addWidget(this.transferBucketModeInput);
    }

    private int getCurrentBucketModeTransferSize() {
        return this.globalTransferSizeMillibuckets / this.transferBucketMode.multiplier;
    }

    private void setCurrentBucketModeTransferSize(int transferSize) {
        this.globalTransferSizeMillibuckets = Math.min(Math.max(transferSize * this.transferBucketMode.multiplier, 0), 2048000000);
    }

    private void configureTransferSizeInput() {
        if (this.transferSizeInput == null || this.transferBucketModeInput == null) {
            return;
        }
        this.transferSizeInput.setVisible(this.shouldShowTransferSize());
        this.transferBucketModeInput.setVisible(this.shouldShowTransferSize());
    }

    private boolean shouldShowTransferSize() {
        if (this.transferMode == TransferMode.TRANSFER_ANY) {
            return false;
        }
        if (!this.filterHandler.isFilterPresent()) {
            return true;
        }
        return !((FluidFilter)this.filterHandler.getFilter()).supportsAmounts();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public BucketMode getTransferBucketMode() {
        return this.transferBucketMode;
    }

    public int getGlobalTransferSizeMillibuckets() {
        return this.globalTransferSizeMillibuckets;
    }
}

