/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import com.gregtechceu.gtceu.common.data.GTBlockEntities;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.LevelFluidPipeNet;
import com.gregtechceu.gtceu.utils.EntityDamageUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidPipeBlock
extends MaterialPipeBlock<FluidPipeType, FluidPipeProperties, LevelFluidPipeNet> {
    public FluidPipeBlock(BlockBehaviour.Properties properties, FluidPipeType fluidPipeType, Material material) {
        super(properties, fluidPipeType, material);
    }

    @Override
    protected FluidPipeProperties createProperties(FluidPipeType fluidPipeType, Material material) {
        return fluidPipeType.modifyProperties(material.getProperty(PropertyKey.FLUID_PIPE));
    }

    @Override
    protected FluidPipeProperties createMaterialData() {
        return this.material.getProperty(PropertyKey.FLUID_PIPE);
    }

    @Override
    public LevelFluidPipeNet getWorldPipeNet(ServerLevel level) {
        return LevelFluidPipeNet.getOrCreate(level);
    }

    @Override
    public BlockEntityType<? extends PipeBlockEntity<FluidPipeType, FluidPipeProperties>> getBlockEntityType() {
        return (BlockEntityType)GTBlockEntities.FLUID_PIPE.get();
    }

    @Override
    public boolean canPipesConnect(IPipeNode<FluidPipeType, FluidPipeProperties> selfTile, Direction side, IPipeNode<FluidPipeType, FluidPipeProperties> sideTile) {
        return selfTile instanceof FluidPipeBlockEntity && sideTile instanceof FluidPipeBlockEntity;
    }

    @Override
    public boolean canPipeConnectToBlock(IPipeNode<FluidPipeType, FluidPipeProperties> selfTile, Direction side, @Nullable BlockEntity tile) {
        return tile != null && tile.getCapability(ForgeCapabilities.FLUID_HANDLER, side.m_122424_()).isPresent();
    }

    @Override
    protected PipeModel createPipeModel() {
        return ((FluidPipeType)this.pipeType).createPipeModel(this.material);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        FluidPipeProperties properties = (FluidPipeProperties)this.createProperties(this.m_49966_(), stack);
        tooltip.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.fluid_transfer_rate", (Object[])new Object[]{properties.getThroughput()}));
        tooltip.add((Component)Component.m_237110_((String)"gtceu.fluid_pipe.max_temperature", (Object[])new Object[]{properties.getMaxFluidTemperature()}));
        if (properties.getChannels() > 1) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.fluid_pipe.channels", (Object[])new Object[]{properties.getChannels()}));
        }
        if (!GTUtil.isShiftDown()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.tooltip.fluid_pipe_hold_shift"));
            return;
        }
        if (properties.isGasProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.gas_proof"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.not_gas_proof"));
        }
        if (properties.isAcidProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.acid_proof"));
        }
        if (properties.isCryoProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.cryo_proof"));
        }
        if (properties.isPlasmaProof()) {
            tooltip.add((Component)Component.m_237115_((String)"gtceu.fluid_pipe.plasma_proof"));
        }
    }

    @Override
    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        IPipeNode pipeNode = this.getPipeTile((BlockGetter)level, pos);
        if (pipeNode == null) {
            GTCEu.LOGGER.error("Pipe was null");
            return;
        }
        if (pipeNode.getFrameMaterial() != null) {
            BlockState frameState = ((BlockEntry)GTBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)pipeNode.getFrameMaterial())).getDefaultState();
            frameState.m_60734_().m_7892_(frameState, level, pos, entity);
            return;
        }
        if (level.f_46443_) {
            return;
        }
        if (level.m_7702_(pos) == null) {
            return;
        }
        FluidPipeBlockEntity pipe = (FluidPipeBlockEntity)level.m_7702_(pos);
        if (pipe.getOffsetTimer() % 10L == 0L && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (pipe.getFluidTanks().length > 1) {
                int maxTemperature = Integer.MIN_VALUE;
                int minTemperature = Integer.MAX_VALUE;
                for (CustomFluidTank tank : pipe.getFluidTanks()) {
                    FluidStack stack = tank.getFluid();
                    if (tank.getFluid() == null || tank.getFluid().getAmount() <= 0) continue;
                    maxTemperature = Math.max(maxTemperature, stack.getFluid().getFluidType().getTemperature(stack));
                    minTemperature = Math.min(minTemperature, stack.getFluid().getFluidType().getTemperature(stack));
                }
                if (maxTemperature != Integer.MIN_VALUE) {
                    EntityDamageUtil.applyTemperatureDamage(livingEntity, maxTemperature, 1.0f, 20);
                }
                if (minTemperature != Integer.MAX_VALUE) {
                    EntityDamageUtil.applyTemperatureDamage(livingEntity, minTemperature, 1.0f, 20);
                }
            } else {
                CustomFluidTank tank = pipe.getFluidTanks()[0];
                if (tank.getFluid() != null && tank.getFluid().getAmount() > 0) {
                    FluidStack stack = tank.getFluid();
                    EntityDamageUtil.applyTemperatureDamage(livingEntity, stack.getFluid().getFluidType().getTemperature(stack), 1.0f, 20);
                }
            }
        }
        super.m_7892_(state, level, pos, entity);
    }
}

