/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.Branch;
import com.gregtechceu.gtceu.api.recipe.lookup.RecipeIterator;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.armor.PowerlessJetpack;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.Platform;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeLookup {
    private final GTRecipeType recipeType;
    private final Branch lookup = new Branch();
    private static final WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> ingredientRoot = new WeakHashMap();

    @Nullable
    public GTRecipe findRecipe(IRecipeCapabilityHolder holder) {
        return this.find(holder, recipe -> recipe.matchRecipe(holder).isSuccess());
    }

    @Nullable
    protected List<List<AbstractMapIngredient>> prepareRecipeFind(@NotNull IRecipeCapabilityHolder holder) {
        int totalSize = 0;
        for (Map.Entry entries : holder.getCapabilitiesProxy().row((Object)IO.IN).entrySet()) {
            int size = 0;
            if (!((RecipeCapability)entries.getKey()).isRecipeSearchFilter()) continue;
            for (IRecipeHandler entry : (List)entries.getValue()) {
                if (entry.getSize() == -1) continue;
                size += entry.getSize();
            }
            if (size == Integer.MAX_VALUE) {
                return null;
            }
            totalSize += size;
        }
        if (totalSize == 0) {
            return null;
        }
        ObjectArrayList list = new ObjectArrayList(totalSize);
        list.addAll(this.fromHolder(holder));
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Nullable
    public GTRecipe find(@NotNull IRecipeCapabilityHolder holder, @NotNull Predicate<GTRecipe> canHandle) {
        List<List<AbstractMapIngredient>> list = this.prepareRecipeFind(holder);
        if (list == null) {
            return null;
        }
        return this.recurseIngredientTreeFindRecipe(list, this.lookup, canHandle);
    }

    @NotNull
    public RecipeIterator getRecipeIterator(@NotNull IRecipeCapabilityHolder holder, @NotNull Predicate<GTRecipe> canHandle) {
        List<List<AbstractMapIngredient>> list = this.prepareRecipeFind(holder);
        return new RecipeIterator(this.recipeType, list, canHandle);
    }

    @NotNull
    public static ItemStack[] uniqueItems(@NotNull Collection<ItemStack> inputs) {
        int index = 0;
        ItemStack[] uniqueItems = new ItemStack[inputs.size()];
        block0: for (ItemStack input : inputs) {
            if (input.m_41619_()) continue;
            if (index > 0) {
                for (ItemStack unique : uniqueItems) {
                    if (unique == null) break;
                    if (ItemStack.m_150942_((ItemStack)input, (ItemStack)unique)) continue block0;
                }
            }
            uniqueItems[index++] = input;
        }
        if (index == uniqueItems.length) {
            return uniqueItems;
        }
        ItemStack[] retUniqueItems = new ItemStack[index];
        System.arraycopy(uniqueItems, 0, retUniqueItems, 0, index);
        return retUniqueItems;
    }

    @Nullable
    public GTRecipe recurseIngredientTreeFindRecipe(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchRoot, @NotNull Predicate<GTRecipe> canHandle) {
        for (int i = 0; i < ingredients.size(); ++i) {
            GTRecipe r = this.recurseIngredientTreeFindRecipe(ingredients, branchRoot, canHandle, i, 0, 1L << i);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public GTRecipe recurseIngredientTreeFindRecipe(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchMap, @NotNull Predicate<GTRecipe> canHandle, int index, int count, long skip) {
        if (count == ingredients.size()) {
            return null;
        }
        for (AbstractMapIngredient obj : ingredients.get(index)) {
            GTRecipe r;
            Map<AbstractMapIngredient, Either<GTRecipe, Branch>> targetMap = GTRecipeLookup.determineRootNodes(obj, branchMap);
            Either<GTRecipe, Branch> result = targetMap.get(obj);
            if (result == null || (r = (GTRecipe)result.map(potentialRecipe -> canHandle.test((GTRecipe)potentialRecipe) ? potentialRecipe : null, potentialBranch -> this.diveIngredientTreeFindRecipe(ingredients, (Branch)potentialBranch, canHandle, index, count, skip))) == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    private GTRecipe diveIngredientTreeFindRecipe(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch map, @NotNull Predicate<GTRecipe> canHandle, int currentIndex, int count, long skip) {
        int i = (currentIndex + 1) % ingredients.size();
        while (i != currentIndex) {
            GTRecipe found;
            if ((skip & 1L << i) == 0L && (found = this.recurseIngredientTreeFindRecipe(ingredients, map, canHandle, i, count + 1, skip | 1L << i)) != null) {
                return found;
            }
            i = (i + 1) % ingredients.size();
        }
        return null;
    }

    @Nullable
    public Set<GTRecipe> findRecipeCollisions(IRecipeCapabilityHolder holder) {
        List<List<AbstractMapIngredient>> list = this.prepareRecipeFind(holder);
        if (list == null) {
            return null;
        }
        ObjectOpenHashSet collidingRecipes = new ObjectOpenHashSet();
        this.recurseIngredientTreeFindRecipeCollisions(list, this.lookup, (Set<GTRecipe>)collidingRecipes);
        return collidingRecipes;
    }

    private void recurseIngredientTreeFindRecipeCollisions(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchRoot, @NotNull Set<GTRecipe> collidingRecipes) {
        for (int i = 0; i < ingredients.size(); ++i) {
            this.recurseIngredientTreeFindRecipeCollisions(ingredients, branchRoot, i, 0, 1L << i, collidingRecipes);
        }
    }

    @Nullable
    private GTRecipe recurseIngredientTreeFindRecipeCollisions(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchMap, int index, int count, long skip, @NotNull Set<GTRecipe> collidingRecipes) {
        if (count == ingredients.size()) {
            return null;
        }
        List<AbstractMapIngredient> wr = ingredients.get(index);
        for (AbstractMapIngredient obj : wr) {
            GTRecipe r;
            Map<AbstractMapIngredient, Either<GTRecipe, Branch>> targetMap = GTRecipeLookup.determineRootNodes(obj, branchMap);
            Either<GTRecipe, Branch> result = targetMap.get(obj);
            if (result == null || (r = (GTRecipe)result.map(recipe -> recipe, right -> this.diveIngredientTreeFindRecipeCollisions(ingredients, (Branch)right, index, count, skip, collidingRecipes))) == null) continue;
            collidingRecipes.add(r);
        }
        return null;
    }

    @Nullable
    private GTRecipe diveIngredientTreeFindRecipeCollisions(@NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch map, int currentIndex, int count, long skip, @NotNull Set<GTRecipe> collidingRecipes) {
        int i = (currentIndex + 1) % ingredients.size();
        while (i != currentIndex) {
            GTRecipe r;
            if ((skip & 1L << i) == 0L && (r = this.recurseIngredientTreeFindRecipeCollisions(ingredients, map, i, count + 1, skip | 1L << i, collidingRecipes)) != null) {
                return r;
            }
            i = (i + 1) % ingredients.size();
        }
        return null;
    }

    protected static void retrieveCachedIngredient(@NotNull List<List<AbstractMapIngredient>> list, @NotNull List<AbstractMapIngredient> ingredients, @NotNull WeakHashMap<AbstractMapIngredient, WeakReference<AbstractMapIngredient>> cache) {
        for (int i = 0; i < ingredients.size(); ++i) {
            AbstractMapIngredient mappedIngredient = ingredients.get(i);
            WeakReference<AbstractMapIngredient> cached = cache.get(mappedIngredient);
            if (cached != null && cached.get() != null) {
                ingredients.set(i, (AbstractMapIngredient)cached.get());
                continue;
            }
            cache.put(mappedIngredient, new WeakReference<AbstractMapIngredient>(mappedIngredient));
        }
        list.add(ingredients);
    }

    @NotNull
    protected List<List<AbstractMapIngredient>> fromRecipe(@NotNull GTRecipe r) {
        ObjectArrayList list = new ObjectArrayList(r.inputs.values().size());
        r.inputs.forEach((arg_0, arg_1) -> GTRecipeLookup.lambda$fromRecipe$5((List)list, arg_0, arg_1));
        r.tickInputs.forEach((arg_0, arg_1) -> GTRecipeLookup.lambda$fromRecipe$6((List)list, arg_0, arg_1));
        return list;
    }

    @NotNull
    protected List<List<AbstractMapIngredient>> fromHolder(@NotNull IRecipeCapabilityHolder r) {
        ObjectArrayList list = new ObjectArrayList(r.getCapabilitiesProxy().row((Object)IO.IN).values().size());
        r.getCapabilitiesProxy().row((Object)IO.IN).forEach((arg_0, arg_1) -> GTRecipeLookup.lambda$fromHolder$7((List)list, arg_0, arg_1));
        return list;
    }

    @ApiStatus.Internal
    public void removeAllRecipes() {
        this.lookup.getNodes().clear();
        this.lookup.getSpecialNodes().clear();
        this.recipeType.getCategoryMap().clear();
    }

    public boolean addRecipe(GTRecipe recipe) {
        List<List<AbstractMapIngredient>> items;
        if (recipe == null) {
            return false;
        }
        if (recipe.recipeCategory == null) {
            recipe.recipeCategory = GTRecipeCategory.of("gtceu", recipe.recipeType.registryName.m_135815_(), recipe.recipeType, recipe.recipeType.registryName.m_214298_());
        }
        if (recipe.getType() == GTRecipeTypes.COMBUSTION_GENERATOR_FUELS) {
            Content content = recipe.getInputContents(FluidRecipeCapability.CAP).get(0);
            FluidIngredient fluid = (FluidIngredient)FluidRecipeCapability.CAP.of(content.content);
            PowerlessJetpack.FUELS.put((Object)fluid, recipe.duration);
        }
        if (this.recurseIngredientTreeAdd(recipe, items = this.fromRecipe(recipe), this.lookup, 0, 0)) {
            this.recipeType.getCategoryMap().computeIfAbsent(recipe.recipeCategory, k -> new ObjectLinkedOpenHashSet()).add(recipe);
            return true;
        }
        return false;
    }

    private boolean recurseIngredientTreeAdd(@NotNull GTRecipe recipe, @NotNull List<List<AbstractMapIngredient>> ingredients, @NotNull Branch branchMap, int index, int count) {
        if (count >= ingredients.size()) {
            return true;
        }
        if (index >= ingredients.size()) {
            throw new RuntimeException("Index out of bounds for recurseItemTreeAdd, should not happen");
        }
        List<AbstractMapIngredient> current = ingredients.get(index);
        Branch branchRight = new Branch();
        for (AbstractMapIngredient obj : current) {
            Map<AbstractMapIngredient, Either<GTRecipe, Branch>> targetMap = GTRecipeLookup.determineRootNodes(obj, branchMap);
            Either r = targetMap.compute(obj, (k, v) -> {
                if (count == ingredients.size() - 1) {
                    if (v != null) {
                        if ((v.left().isEmpty() || v.left().get() != recipe) && (ConfigHolder.INSTANCE.dev.debug || Platform.isDevEnv())) {
                            GTCEu.LOGGER.warn("Recipe duplicate or conflict found in GTRecipeType {} and was not added. See next lines for details", (Object)BuiltInRegistries.f_256990_.m_7981_((Object)this.recipeType));
                            GTCEu.LOGGER.warn("Attempted to add GTRecipe: {}", (Object)recipe.m_6423_());
                            if (v.left().isPresent()) {
                                GTCEu.LOGGER.warn("Which conflicts with: {}", (Object)((GTRecipe)v.left().get()).m_6423_());
                            } else {
                                GTCEu.LOGGER.warn("Could not find exact duplicate/conflict.");
                            }
                        }
                        return v;
                    }
                    return Either.left((Object)recipe);
                }
                if (v == null) {
                    return Either.right((Object)branchRight);
                }
                return v;
            });
            if (r.left().isPresent()) {
                if (r.left().get() == recipe) continue;
                return false;
            }
            boolean addedNextBranch = r.right().filter(m -> this.recurseIngredientTreeAdd(recipe, ingredients, (Branch)m, (index + 1) % ingredients.size(), count + 1)).isPresent();
            if (addedNextBranch) continue;
            if (count == ingredients.size() - 1) {
                targetMap.remove(obj);
            } else if (targetMap.get(obj).right().isPresent() && ((Branch)targetMap.get(obj).right().get()).isEmptyBranch()) {
                targetMap.remove(obj);
            }
            return false;
        }
        return true;
    }

    @NotNull
    protected static Map<AbstractMapIngredient, Either<GTRecipe, Branch>> determineRootNodes(@NotNull AbstractMapIngredient ingredient, @NotNull Branch branchMap) {
        return ingredient.isSpecialIngredient() ? branchMap.getSpecialNodes() : branchMap.getNodes();
    }

    public GTRecipeLookup(GTRecipeType recipeType) {
        this.recipeType = recipeType;
    }

    public Branch getLookup() {
        return this.lookup;
    }

    private static /* synthetic */ void lambda$fromHolder$7(List list, RecipeCapability cap, List handlers) {
        if (cap.isRecipeSearchFilter() && !handlers.isEmpty()) {
            for (IRecipeHandler handler : handlers) {
                if (handler.isProxy()) continue;
                List<Object> compressed = cap.compressIngredients(handler.getContents());
                for (Object content : compressed) {
                    list.add(cap.convertToMapIngredient(content));
                }
            }
        }
    }

    private static /* synthetic */ void lambda$fromRecipe$6(List list, RecipeCapability cap, List contents) {
        if (cap.isRecipeSearchFilter() && !contents.isEmpty()) {
            List<Object> ingredients = new ArrayList<Object>();
            for (Content content : contents) {
                ingredients.add(content.getContent());
            }
            ingredients = cap.compressIngredients(ingredients);
            for (Object ingredient : ingredients) {
                GTRecipeLookup.retrieveCachedIngredient(list, cap.convertToMapIngredient(ingredient), ingredientRoot);
            }
        }
    }

    private static /* synthetic */ void lambda$fromRecipe$5(List list, RecipeCapability cap, List contents) {
        if (cap.isRecipeSearchFilter() && !contents.isEmpty()) {
            List<Object> ingredients = new ArrayList<Object>();
            for (Content content : contents) {
                ingredients.add(content.getContent());
            }
            ingredients = cap.compressIngredients(ingredients);
            for (Object ingredient : ingredients) {
                GTRecipeLookup.retrieveCachedIngredient(list, cap.convertToMapIngredient(ingredient), ingredientRoot);
            }
        }
    }
}

