/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup;

import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Branch {
    private Map<AbstractMapIngredient, Either<GTRecipe, Branch>> nodes;
    private Map<AbstractMapIngredient, Either<GTRecipe, Branch>> specialNodes;

    public Stream<GTRecipe> getRecipes(boolean filterHidden) {
        Stream<GTRecipe> stream = null;
        if (this.nodes != null) {
            stream = this.nodes.values().stream().flatMap(either -> (Stream)either.map(Stream::of, right -> right.getRecipes(filterHidden)));
        }
        if (this.specialNodes != null) {
            stream = stream == null ? this.specialNodes.values().stream().flatMap(either -> (Stream)either.map(Stream::of, right -> right.getRecipes(filterHidden))) : Stream.concat(stream, this.specialNodes.values().stream().flatMap(either -> (Stream)either.map(Stream::of, right -> right.getRecipes(filterHidden))));
        }
        if (stream == null) {
            return Stream.empty();
        }
        if (filterHidden) {
            // empty if block
        }
        return stream;
    }

    public boolean isEmptyBranch() {
        return !(this.nodes != null && !this.nodes.isEmpty() || this.specialNodes != null && !this.specialNodes.isEmpty());
    }

    @NotNull
    public Map<AbstractMapIngredient, Either<GTRecipe, Branch>> getNodes() {
        if (this.nodes == null) {
            this.nodes = new Object2ObjectOpenHashMap(2);
        }
        return this.nodes;
    }

    @NotNull
    public Map<AbstractMapIngredient, Either<GTRecipe, Branch>> getSpecialNodes() {
        if (this.specialNodes == null) {
            this.specialNodes = new Object2ObjectOpenHashMap(2);
        }
        return this.specialNodes;
    }
}

