/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.math.BigInteger;
import net.minecraft.network.FriendlyByteBuf;

public class SerializerBigInteger
implements IContentSerializer<BigInteger> {
    public static final Codec<BigInteger> CODEC = Codec.STRING.comapFlatMap(str -> {
        try {
            return DataResult.success((Object)new BigInteger((String)str), (Lifecycle)Lifecycle.stable());
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage, (Lifecycle)Lifecycle.stable());
        }
    }, BigInteger::toString);
    public static SerializerBigInteger INSTANCE = new SerializerBigInteger();

    private SerializerBigInteger() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, BigInteger content) {
        buf.m_130070_(content.toString());
    }

    @Override
    public BigInteger fromNetwork(FriendlyByteBuf buf) {
        return new BigInteger(buf.m_130277_());
    }

    @Override
    public BigInteger fromJson(JsonElement json) {
        return json.getAsBigInteger();
    }

    @Override
    public JsonElement toJson(BigInteger content) {
        return new JsonPrimitive((Number)content);
    }

    @Override
    public BigInteger of(Object o) {
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Number) {
            return BigInteger.valueOf(((Number)o).longValue());
        }
        if (o instanceof CharSequence) {
            return new BigInteger(o.toString());
        }
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger defaultValue() {
        return BigInteger.ZERO;
    }

    @Override
    public Codec<BigInteger> codec() {
        return CODEC;
    }
}

