/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.DummyCraftingContainer;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableItemStackHandler
extends NotifiableRecipeHandlerTrait<Ingredient>
implements ICapabilityTrait,
IItemHandlerModifiable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableItemStackHandler.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    @DescSynced
    public final CustomItemStackHandler storage;
    private Boolean isEmpty;

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO, @NotNull IO capabilityIO, Function<Integer, CustomItemStackHandler> storageFactory) {
        super(machine);
        this.handlerIO = handlerIO;
        this.storage = storageFactory.apply(slots);
        this.capabilityIO = capabilityIO;
        this.storage.setOnContentsChanged(this::onContentsChanged);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO, @NotNull IO capabilityIO) {
        this(machine, slots, handlerIO, capabilityIO, CustomItemStackHandler::new);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO) {
        this(machine, slots, handlerIO, handlerIO);
    }

    public NotifiableItemStackHandler setFilter(Function<ItemStack, Boolean> filter) {
        this.storage.setFilter(filter::apply);
        return this;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
        return NotifiableItemStackHandler.handleRecipe(io, recipe, left, simulate, this.handlerIO, this.storage);
    }

    public static List<Ingredient> handleRecipe(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate, IO handlerIO, CustomItemStackHandler storage) {
        if (io != handlerIO) {
            return left;
        }
        if (io != IO.IN && io != IO.OUT) {
            return left.isEmpty() ? null : left;
        }
        ItemStack[] visited = new ItemStack[storage.getSlots()];
        ListIterator<Ingredient> it = left.listIterator();
        while (it.hasNext()) {
            int amount;
            ItemStack[] items;
            Ingredient ingredient = it.next();
            if (ingredient.m_43947_()) {
                it.remove();
                continue;
            }
            if (io == IO.OUT && ingredient instanceof IntProviderIngredient) {
                IntProviderIngredient provider = (IntProviderIngredient)ingredient;
                provider.setItemStacks(null);
                provider.setSampledCount(null);
            }
            if ((items = ingredient.m_43908_()).length == 0 || items[0].m_41619_()) {
                it.remove();
                continue;
            }
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient si = (SizedIngredient)ingredient;
                amount = si.getAmount();
            } else {
                amount = items[0].m_41613_();
            }
            for (int slot = 0; slot < storage.getSlots(); ++slot) {
                int count;
                ItemStack stored = storage.getStackInSlot(slot);
                int n = count = visited[slot] == null ? stored.m_41613_() : visited[slot].m_41613_();
                if (io == IO.IN) {
                    if (count == 0) continue;
                    if (visited[slot] == null && ingredient.test(stored) || ingredient.test(visited[slot])) {
                        ItemStack extracted = NotifiableItemStackHandler.getActioned(storage, slot, recipe.ingredientActions);
                        if (extracted == null) {
                            extracted = storage.extractItem(slot, Math.min(count, amount), simulate);
                        }
                        if (!extracted.m_41619_()) {
                            visited[slot] = extracted.m_255036_(count - extracted.m_41613_());
                        }
                        amount -= extracted.m_41613_();
                    }
                } else {
                    ItemStack output = items[0].m_255036_(amount);
                    if ((visited[slot] == null || visited[slot].m_150930_(output.m_41720_())) && count < output.m_41741_() && count < storage.getSlotLimit(slot)) {
                        ItemStack remainder = NotifiableItemStackHandler.getActioned(storage, slot, recipe.ingredientActions);
                        if (remainder == null) {
                            remainder = storage.insertItem(slot, output, simulate);
                        }
                        if (remainder.m_41613_() < amount) {
                            visited[slot] = output.m_255036_(count + amount - remainder.m_41613_());
                        }
                        amount = remainder.m_41613_();
                    }
                }
                if (amount > 0) continue;
                it.remove();
                break;
            }
            if (amount <= 0) continue;
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient si = (SizedIngredient)ingredient;
                si.setAmount(amount);
                continue;
            }
            items[0].m_41764_(amount);
        }
        return left.isEmpty() ? null : left;
    }

    @Nullable
    private static ItemStack getActioned(CustomItemStackHandler storage, int index, List<?> actions) {
        if (!GTCEu.isKubeJSLoaded()) {
            return null;
        }
        ItemStack actioned = KJSCallWrapper.applyIngredientAction(storage, index, actions);
        if (!actioned.m_41619_()) {
            return actioned;
        }
        return null;
    }

    @Override
    public RecipeCapability<Ingredient> getCapability() {
        return ItemRecipeCapability.CAP;
    }

    public int getSlots() {
        return this.storage.getSlots();
    }

    @Override
    public int getSize() {
        return this.getSlots();
    }

    @Override
    public List<Object> getContents() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        return Arrays.asList(stacks.toArray());
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            amount += (long)stack.m_41613_();
        }
        return amount;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                if (this.storage.getStackInSlot(i).m_41619_()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<ItemStack> filter = this.getMachine().getItemCapFilter(facing, IO.OUT);
            GTTransferUtils.getAdjacentItemHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferItemsFiltered((IItemHandler)this, adj, filter));
        }
    }

    public void importFromNearby(Direction ... facings) {
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<ItemStack> filter = this.getMachine().getItemCapFilter(facing, IO.IN);
            GTTransferUtils.getAdjacentItemHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferItemsFiltered(adj, (IItemHandler)this, filter));
        }
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    public void setStackInSlot(int index, ItemStack stack) {
        this.storage.setStackInSlot(index, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.canCapInput()) {
            return this.storage.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack insertItemInternal(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.storage.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canCapOutput()) {
            return this.storage.extractItem(slot, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.storage.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.storage.isItemValid(slot, stack);
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    public static class KJSCallWrapper {
        public static ItemStack applyIngredientAction(CustomItemStackHandler storage, int index, List<IngredientAction> ingredientActions) {
            ItemStack stack = storage.getStackInSlot(index);
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            DummyCraftingContainer container = new DummyCraftingContainer((IItemHandlerModifiable)storage);
            for (IngredientAction action : ingredientActions) {
                if (!action.checkFilter(index, stack)) continue;
                return action.transform(stack.m_41777_(), index, (CraftingContainer)container);
            }
            return ItemStack.f_41583_;
        }
    }
}

