/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.logic.OCParams;
import com.gregtechceu.gtceu.api.recipe.logic.OCResult;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class WorkableMultiblockMachine
extends MultiblockControllerMachine
implements IWorkableMultiController,
IMufflableMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(WorkableMultiblockMachine.class, MultiblockControllerMachine.MANAGED_FIELD_HOLDER);
    @Nullable
    private ICleanroomProvider cleanroom;
    @Persisted
    @DescSynced
    public final RecipeLogic recipeLogic;
    private final GTRecipeType[] recipeTypes = this.getDefinition().getRecipeTypes();
    @Persisted
    private int activeRecipeType = 0;
    protected final Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilitiesProxy;
    protected final List<ISubscription> traitSubscriptions;
    @Persisted
    @DescSynced
    protected boolean isMuffled;
    protected boolean previouslyMuffled = true;
    @Nullable
    protected LongSet activeBlocks;

    public WorkableMultiblockMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder);
        this.recipeLogic = this.createRecipeLogic(args);
        this.capabilitiesProxy = Tables.newCustomTable(new EnumMap(IO.class), IdentityHashMap::new);
        this.traitSubscriptions = new ArrayList<ISubscription>();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.inValid();
    }

    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new RecipeLogic(this);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.activeBlocks = this.getMultiblockState().getMatchContext().getOrDefault("vaBlocks", LongSets.emptySet());
        this.capabilitiesProxy.clear();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO io = ioMap.getOrDefault(part.self().getPos().m_121878_(), IO.BOTH);
            if (io == IO.NONE) continue;
            for (IRecipeHandlerTrait handler : part.getRecipeHandlers()) {
                IO handlerIO;
                if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO()) continue;
                IO iO = handlerIO = io == IO.BOTH ? handler.getHandlerIO() : io;
                if (!this.capabilitiesProxy.contains((Object)handlerIO, handler.getCapability())) {
                    this.capabilitiesProxy.put((Object)handlerIO, handler.getCapability(), new ArrayList());
                }
                ((List)this.capabilitiesProxy.get((Object)handlerIO, handler.getCapability())).add(handler);
                this.traitSubscriptions.add(handler.addChangedListener(this.recipeLogic::updateTickSubscription));
            }
        }
        for (MachineTrait trait : this.getTraits()) {
            if (!(trait instanceof IRecipeHandlerTrait)) continue;
            IRecipeHandlerTrait handlerTrait = (IRecipeHandlerTrait)((Object)trait);
            if (!this.capabilitiesProxy.contains((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability())) {
                this.capabilitiesProxy.put((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability(), new ArrayList());
            }
            ((List)this.capabilitiesProxy.get((Object)handlerTrait.getHandlerIO(), handlerTrait.getCapability())).add(handlerTrait);
            this.traitSubscriptions.add(handlerTrait.addChangedListener(this.recipeLogic::updateTickSubscription));
        }
        this.recipeLogic.updateTickSubscription();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.updateActiveBlocks(false);
        this.activeBlocks = null;
        this.capabilitiesProxy.clear();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.resetRecipeLogic();
    }

    @Override
    public void onPartUnload() {
        super.onPartUnload();
        this.updateActiveBlocks(false);
        this.activeBlocks = null;
        this.capabilitiesProxy.clear();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.updateTickSubscription();
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.previouslyMuffled != this.isMuffled) {
            this.previouslyMuffled = this.isMuffled;
            if (this.recipeLogic != null) {
                this.recipeLogic.updateSound();
            }
        }
    }

    @Override
    @Nullable
    public final GTRecipe doModifyRecipe(GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        for (IMultiPart part : this.getParts()) {
            recipe = part.modifyRecipe(recipe);
            if (recipe != null) continue;
            return null;
        }
        return this.getRealRecipe(recipe, params, result);
    }

    @Nullable
    protected GTRecipe getRealRecipe(GTRecipe recipe, @NotNull OCParams params, @NotNull OCResult result) {
        return this.self().getDefinition().getRecipeModifier().apply(this.self(), recipe, params, result);
    }

    public void updateActiveBlocks(boolean active) {
        if (this.activeBlocks != null) {
            for (Long pos : this.activeBlocks) {
                ActiveBlock block;
                BlockState newState;
                BlockPos blockPos = BlockPos.m_122022_((long)pos);
                BlockState blockState = this.getLevel().m_8055_(blockPos);
                Block block2 = blockState.m_60734_();
                if (!(block2 instanceof ActiveBlock) || (newState = (block = (ActiveBlock)block2).changeActive(blockState, active)) == blockState) continue;
                this.getLevel().m_46597_(blockPos, newState);
            }
        }
    }

    @Override
    public boolean keepSubscribing() {
        return false;
    }

    @Override
    public void notifyStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
        IWorkableMultiController.super.notifyStatusChanged(oldStatus, newStatus);
        if (newStatus == RecipeLogic.Status.WORKING || oldStatus == RecipeLogic.Status.WORKING) {
            this.updateActiveBlocks(newStatus == RecipeLogic.Status.WORKING);
        }
    }

    @Override
    public boolean isRecipeLogicAvailable() {
        return this.isFormed && !this.getMultiblockState().hasError();
    }

    @Override
    public void afterWorking() {
        for (IMultiPart part : this.getParts()) {
            part.afterWorking(this);
        }
        IWorkableMultiController.super.afterWorking();
    }

    @Override
    public boolean beforeWorking(@Nullable GTRecipe recipe) {
        for (IMultiPart part : this.getParts()) {
            if (part.beforeWorking(this)) continue;
            return false;
        }
        return IWorkableMultiController.super.beforeWorking(recipe);
    }

    @Override
    public boolean onWorking() {
        for (IMultiPart part : this.getParts()) {
            if (part.onWorking(this)) continue;
            return false;
        }
        return IWorkableMultiController.super.onWorking();
    }

    @Override
    public void onWaiting() {
        for (IMultiPart part : this.getParts()) {
            part.onWaiting(this);
        }
        IWorkableMultiController.super.onWaiting();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (!isWorkingAllowed) {
            for (IMultiPart part : this.getParts()) {
                part.onPaused(this);
            }
        }
        IWorkableMultiController.super.setWorkingEnabled(isWorkingAllowed);
    }

    @Override
    @NotNull
    public GTRecipeType getRecipeType() {
        return this.recipeTypes[this.activeRecipeType];
    }

    @Override
    @Nullable
    public ICleanroomProvider getCleanroom() {
        return this.cleanroom;
    }

    @Override
    public void setCleanroom(@Nullable ICleanroomProvider cleanroom) {
        this.cleanroom = cleanroom;
    }

    @Override
    public RecipeLogic getRecipeLogic() {
        return this.recipeLogic;
    }

    @Override
    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes;
    }

    @Override
    public int getActiveRecipeType() {
        return this.activeRecipeType;
    }

    @Override
    public void setActiveRecipeType(int activeRecipeType) {
        this.activeRecipeType = activeRecipeType;
    }

    @Override
    public Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }

    @Override
    public boolean isMuffled() {
        return this.isMuffled;
    }

    @Override
    public void setMuffled(boolean isMuffled) {
        this.isMuffled = isMuffled;
    }

    @Nullable
    public LongSet getActiveBlocks() {
        return this.activeBlocks;
    }
}

