/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.armor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.armor.DummyArmorLogic;
import com.gregtechceu.gtceu.api.item.armor.IArmorLogic;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import com.gregtechceu.gtceu.api.item.component.IRecipeRemainder;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.api.item.component.forge.IComponentCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArmorComponentItem
extends ArmorItem
implements IComponentItem {
    private IArmorLogic armorLogic = new DummyArmorLogic();
    protected List<IItemComponent> components = new ArrayList<IItemComponent>();

    public ArmorComponentItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties.m_41503_(0));
    }

    public ArmorComponentItem setArmorLogic(IArmorLogic armorLogic) {
        Preconditions.checkNotNull((Object)armorLogic, (Object)"Cannot set ArmorLogic to null");
        this.armorLogic = armorLogic;
        this.armorLogic.addToolComponents(this);
        return this;
    }

    @Override
    public void attachComponents(IItemComponent ... components) {
        this.components.addAll(Arrays.asList(components));
        for (IItemComponent component : components) {
            component.onAttached((Item)this);
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        IArmorLogic armorLogic = this.getArmorLogic();
        multimap.putAll(super.getAttributeModifiers(slot, stack));
        multimap.putAll(armorLogic.getAttributeModifiers(slot, stack));
        return multimap;
    }

    public ArmorItem.Type m_266204_() {
        return this.armorLogic.getArmorType();
    }

    public EquipmentSlot m_40402_() {
        return this.armorLogic.getArmorType().m_266308_();
    }

    public void onArmorTick(ItemStack stack, Level level, Player player) {
        super.onArmorTick(stack, level, player);
        this.armorLogic.onArmorTick(level, player, stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return super.getMaxDamage(stack);
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 50;
    }

    public int getArmorDisplay(Player player, @NotNull ItemStack armor, EquipmentSlot slot) {
        return this.armorLogic.getArmorDisplay(player, armor, slot);
    }

    public void damageArmor(LivingEntity entity, @NotNull ItemStack stack, DamageSource source, int damage, EquipmentSlot slot) {
        this.armorLogic.damageArmor(entity, stack, source, damage, slot);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return ArmorComponentItem.this.armorLogic.getArmorModel(livingEntity, itemStack, equipmentSlot, original);
            }
        });
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.armorLogic.getArmorTexture(stack, entity, slot, type).toString();
    }

    @Override
    public void fillItemCategory(CreativeModeTab category, NonNullList<ItemStack> items) {
        boolean found = false;
        for (IItemComponent component : this.components) {
            if (!(component instanceof ISubItemHandler)) continue;
            ISubItemHandler subItemHandler = (ISubItemHandler)component;
            subItemHandler.fillItemCategory((Item)this, category, items);
            found = true;
        }
        if (found) {
            return;
        }
        items.add((Object)new ItemStack((ItemLike)this));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IAddInformation)) continue;
            IAddInformation addInformation = (IAddInformation)component;
            addInformation.appendHoverText(stack, level, tooltipComponents, isAdvanced);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.isBarVisible(stack);
        }
        return super.m_142522_(stack);
    }

    public int m_142158_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.getBarWidth(stack);
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IDurabilityBar)) continue;
            IDurabilityBar durabilityBar = (IDurabilityBar)component;
            return durabilityBar.getBarColor(stack);
        }
        return super.m_142159_(stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResult result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).useOn(context)) == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_6225_(context);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResultHolder<ItemStack> result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).use((Item)this, level, player, usedHand)).m_19089_() == InteractionResult.PASS) continue;
            return result;
        }
        return super.m_7203_(level, player, usedHand);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IInteractionItem)) continue;
            IInteractionItem interactionItem = (IInteractionItem)component;
            stack = interactionItem.finishUsingItem(stack, level, livingEntity);
        }
        return super.m_5922_(stack, level, livingEntity);
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResult result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).onItemUseFirst(itemStack, context)) == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        for (IItemComponent component : this.components) {
            IInteractionItem interactionItem;
            InteractionResult result;
            if (!(component instanceof IInteractionItem) || (result = (interactionItem = (IInteractionItem)component).interactLivingEntity(stack, player, interactionTarget, usedHand)) == InteractionResult.PASS) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            ICustomDescriptionId customDescriptionId;
            Component name;
            if (!(component instanceof ICustomDescriptionId) || (name = (customDescriptionId = (ICustomDescriptionId)component).getItemName(stack)) == null) continue;
            return name;
        }
        return super.m_7626_(stack);
    }

    public String m_5671_(ItemStack stack) {
        for (IItemComponent component : this.components) {
            ICustomDescriptionId customDescriptionId;
            String langId;
            if (!(component instanceof ICustomDescriptionId) || (langId = (customDescriptionId = (ICustomDescriptionId)component).getItemDescriptionId(stack)) == null) continue;
            return langId;
        }
        return super.m_5671_(stack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IItemLifeCycle)) continue;
            IItemLifeCycle lifeCycle = (IItemLifeCycle)component;
            lifeCycle.inventoryTick(stack, level, entity, slotId, isSelected);
        }
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IRecipeRemainder)) continue;
            IRecipeRemainder recipeRemainder = (IRecipeRemainder)component;
            return recipeRemainder.getRecipeRemained(itemStack);
        }
        return super.getCraftingRemainingItem(itemStack);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        for (IItemComponent component : this.components) {
            if (!(component instanceof IRecipeRemainder)) continue;
            IRecipeRemainder recipeRemainder = (IRecipeRemainder)component;
            return recipeRemainder.getRecipeRemained(stack) != ItemStack.f_41583_;
        }
        return super.hasCraftingRemainingItem(stack);
    }

    @Override
    public <T> LazyOptional<T> getCapability(@NotNull ItemStack itemStack, @NotNull Capability<T> cap) {
        for (IItemComponent component : this.components) {
            IComponentCapability componentCapability;
            LazyOptional<T> value;
            if (!(component instanceof IComponentCapability) || !(value = (componentCapability = (IComponentCapability)((Object)component)).getCapability(itemStack, cap)).isPresent()) continue;
            return value;
        }
        return LazyOptional.empty();
    }

    public IArmorLogic getArmorLogic() {
        return this.armorLogic;
    }

    @Override
    public List<IItemComponent> getComponents() {
        return this.components;
    }
}

