/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.editor;

import com.gregtechceu.gtceu.api.gui.editor.IEditableUI;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class EditableMachineUI
implements IEditableUI<WidgetGroup, MetaMachine> {
    final String groupName;
    final ResourceLocation uiPath;
    final Supplier<WidgetGroup> widgetSupplier;
    final BiConsumer<WidgetGroup, MetaMachine> binder;
    @Nullable
    private CompoundTag customUICache;

    public EditableMachineUI(String groupName, ResourceLocation uiPath, Supplier<WidgetGroup> widgetSupplier, BiConsumer<WidgetGroup, MetaMachine> binder) {
        this.groupName = groupName;
        this.uiPath = uiPath;
        this.widgetSupplier = widgetSupplier;
        this.binder = binder;
    }

    @Override
    public WidgetGroup createDefault() {
        return this.widgetSupplier.get();
    }

    @Override
    public void setupUI(WidgetGroup template, MetaMachine machine) {
        this.binder.accept(template, machine);
    }

    @Nullable
    public WidgetGroup createCustomUI() {
        if (this.hasCustomUI()) {
            CompoundTag nbt = this.getCustomUI();
            WidgetGroup group = new WidgetGroup();
            IConfigurableWidget.deserializeNBT((IConfigurableWidget)group, (CompoundTag)nbt.m_128469_("root"), (Resources)Resources.fromNBT((CompoundTag)nbt.m_128469_("resources")), (boolean)false);
            group.setSelfPosition(new Position(0, 0));
            return group;
        }
        return null;
    }

    public CompoundTag getCustomUI() {
        if (this.customUICache == null) {
            ResourceManager resourceManager = null;
            if (LDLib.isClient()) {
                resourceManager = Minecraft.m_91087_().m_91098_();
            } else if (Platform.getMinecraftServer() != null) {
                resourceManager = Platform.getMinecraftServer().m_177941_();
            }
            if (resourceManager == null) {
                this.customUICache = new CompoundTag();
            } else {
                try {
                    Resource resource = resourceManager.m_215593_(new ResourceLocation(this.uiPath.m_135827_(), "ui/machine/%s.mui".formatted(this.uiPath.m_135815_())));
                    try (InputStream inputStream = resource.m_215507_();
                         DataInputStream dataInputStream = new DataInputStream(inputStream);){
                        this.customUICache = NbtIo.m_128934_((DataInput)dataInputStream, (NbtAccounter)NbtAccounter.f_128917_);
                    }
                }
                catch (Exception e) {
                    this.customUICache = new CompoundTag();
                }
                if (this.customUICache == null) {
                    this.customUICache = new CompoundTag();
                }
            }
        }
        return this.customUICache;
    }

    public boolean hasCustomUI() {
        return !this.getCustomUI().m_128456_();
    }

    public void reloadCustomUI() {
        this.customUICache = null;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ResourceLocation getUiPath() {
        return this.uiPath;
    }
}

