/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.fluids.attribute;

import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class FluidAttribute {
    private final ResourceLocation resourceLocation;
    private final Consumer<Consumer<Component>> fluidTooltip;
    private final Consumer<Consumer<Component>> containerTooltip;
    private final int hashCode;

    public FluidAttribute(@NotNull ResourceLocation resourceLocation, @NotNull @NotNull Consumer<Consumer<@NotNull Component>> fluidTooltip, @NotNull @NotNull Consumer<Consumer<@NotNull Component>> containerTooltip) {
        this.resourceLocation = resourceLocation;
        this.fluidTooltip = fluidTooltip;
        this.containerTooltip = containerTooltip;
        this.hashCode = resourceLocation.hashCode();
    }

    @NotNull
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public void appendFluidTooltips(@NotNull @NotNull Consumer<@NotNull Component> tooltip) {
        this.fluidTooltip.accept(tooltip);
    }

    public void appendContainerTooltips(@NotNull @NotNull Consumer<@NotNull Component> tooltip) {
        this.containerTooltip.accept(tooltip);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FluidAttribute that = (FluidAttribute)o;
        return this.resourceLocation.equals((Object)that.getResourceLocation());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    public String toString() {
        return "FluidAttribute{" + this.resourceLocation + "}";
    }
}

