/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.data.worldgen;

import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGeneratorUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class SimpleWorldGenLayer
implements IWorldGenLayer {
    private final String name;
    private final IWorldGenLayer.RuleTestSupplier target;
    private final Set<ResourceLocation> levels;

    public SimpleWorldGenLayer(String name, IWorldGenLayer.RuleTestSupplier target, Set<ResourceLocation> levels) {
        this.name = name;
        this.target = target;
        this.levels = levels;
        WorldGeneratorUtils.WORLD_GEN_LAYERS.put(name, this);
    }

    public String m_7912_() {
        return this.name;
    }

    public String toString() {
        return this.m_7912_() + "[" + RuleTest.f_74307_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.target.get()).result().orElse(null) + "],dimensions=" + this.levels.toString();
    }

    public int hashCode() {
        return this.m_7912_().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IWorldGenLayer)) {
            return false;
        }
        IWorldGenLayer that = (IWorldGenLayer)o;
        return this.m_7912_().equals(that.m_7912_());
    }

    @Override
    public RuleTest getTarget() {
        return this.target.get();
    }

    @Override
    public boolean isApplicableForLevel(ResourceLocation level) {
        return this.levels.contains(level);
    }

    @Override
    public Set<ResourceLocation> getLevels() {
        return this.levels;
    }
}

