/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.cover.filter;

import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.ScrollablePhantomFluidWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SimpleFluidFilter
implements FluidFilter {
    protected boolean isBlackList;
    protected boolean ignoreNbt;
    protected FluidStack[] matches = new FluidStack[9];
    protected Consumer<FluidFilter> itemWriter = filter -> {};
    protected Consumer<FluidFilter> onUpdated = filter -> this.itemWriter.accept((FluidFilter)filter);
    protected int maxStackSize = 1;
    private CustomFluidTank[] fluidStorageSlots = new CustomFluidTank[9];

    protected SimpleFluidFilter() {
        Arrays.fill(this.matches, FluidStack.EMPTY);
    }

    public static SimpleFluidFilter loadFilter(ItemStack itemStack) {
        return SimpleFluidFilter.loadFilter(itemStack.m_41784_(), filter -> itemStack.m_41751_(filter.saveFilter()));
    }

    private static SimpleFluidFilter loadFilter(CompoundTag tag, Consumer<FluidFilter> itemWriter) {
        SimpleFluidFilter handler = new SimpleFluidFilter();
        handler.itemWriter = itemWriter;
        handler.isBlackList = tag.m_128471_("isBlackList");
        handler.ignoreNbt = tag.m_128471_("matchNbt");
        ListTag list = tag.m_128437_("matches", 10);
        for (int i = 0; i < list.size(); ++i) {
            handler.matches[i] = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)list.get(i)));
        }
        return handler;
    }

    @Override
    public void setOnUpdated(Consumer<FluidFilter> onUpdated) {
        this.onUpdated = filter -> {
            this.itemWriter.accept((FluidFilter)filter);
            onUpdated.accept((FluidFilter)filter);
        };
    }

    @Override
    public CompoundTag saveFilter() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("isBlackList", this.isBlackList);
        tag.m_128379_("matchNbt", this.ignoreNbt);
        ListTag list = new ListTag();
        for (FluidStack match : this.matches) {
            list.add((Object)match.writeToNBT(new CompoundTag()));
        }
        tag.m_128365_("matches", (Tag)list);
        return tag;
    }

    public void setBlackList(boolean blackList) {
        this.isBlackList = blackList;
        this.onUpdated.accept(this);
    }

    public void setIgnoreNbt(boolean ingoreNbt) {
        this.ignoreNbt = ingoreNbt;
        this.onUpdated.accept(this);
    }

    @Override
    public WidgetGroup openConfigurator(int x, int y) {
        WidgetGroup group = new WidgetGroup(x, y, 79, 54);
        this.fluidStorageSlots = new CustomFluidTank[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = i * 3 + j;
                this.fluidStorageSlots[index] = new CustomFluidTank(this.maxStackSize);
                this.fluidStorageSlots[index].setFluid(this.matches[index]);
                ScrollablePhantomFluidWidget tank = new ScrollablePhantomFluidWidget(this.fluidStorageSlots[index], 0, i * 18, j * 18, 18, 18, () -> this.fluidStorageSlots[index].getFluid(), fluid -> this.fluidStorageSlots[index].setFluid((FluidStack)fluid)){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setShowAmount((long)SimpleFluidFilter.this.maxStackSize > 1L);
                    }

                    @Override
                    public void detectAndSendChanges() {
                        super.detectAndSendChanges();
                        this.setShowAmount((long)SimpleFluidFilter.this.maxStackSize > 1L);
                    }
                };
                tank.setChangeListener(() -> {
                    this.matches[index] = this.fluidStorageSlots[index].getFluidInTank(0);
                    this.onUpdated.accept(this);
                }).setBackground((IGuiTexture)GuiTextures.SLOT);
                group.addWidget((Widget)tank);
            }
        }
        group.addWidget((Widget)new ToggleButtonWidget(59, 0, 20, 20, (IGuiTexture)GuiTextures.BUTTON_BLACKLIST, this::isBlackList, this::setBlackList));
        group.addWidget((Widget)new ToggleButtonWidget(59, 20, 20, 20, (IGuiTexture)GuiTextures.BUTTON_FILTER_NBT, this::isIgnoreNbt, this::setIgnoreNbt));
        return group;
    }

    @Override
    public boolean test(FluidStack other) {
        return (long)this.testFluidAmount(other) > 0L;
    }

    @Override
    public int testFluidAmount(FluidStack fluidStack) {
        int totalFluidAmount = this.getTotalConfiguredFluidAmount(fluidStack);
        if (this.isBlackList) {
            return totalFluidAmount > 0 ? 0 : Integer.MAX_VALUE;
        }
        return totalFluidAmount;
    }

    public int getTotalConfiguredFluidAmount(FluidStack fluidStack) {
        int totalAmount = 0;
        for (FluidStack candidate : this.matches) {
            if (this.ignoreNbt && candidate.getFluid() == fluidStack.getFluid()) {
                totalAmount += candidate.getAmount();
                continue;
            }
            if (!candidate.isFluidEqual(fluidStack)) continue;
            totalAmount += candidate.getAmount();
        }
        return totalAmount;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
        for (CustomFluidTank customFluidTank : this.fluidStorageSlots) {
            if (customFluidTank == null) continue;
            customFluidTank.setCapacity(maxStackSize);
        }
        for (CustomFluidTank customFluidTank : this.matches) {
            if (customFluidTank.isEmpty()) continue;
            customFluidTank.setAmount(Math.min(customFluidTank.getAmount(), maxStackSize));
        }
    }

    @Override
    public boolean isBlackList() {
        return this.isBlackList;
    }

    public boolean isIgnoreNbt() {
        return this.ignoreNbt;
    }

    public FluidStack[] getMatches() {
        return this.matches;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }
}

