/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.content.SerializerIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.AbstractMapIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapIntersectionIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackNBTIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemStackPartialNBTIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.MapItemTagIngredient;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.transfer.item.CycleItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.TagOrCycleItemStackHandler;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.common.valueprovider.AddedFloat;
import com.gregtechceu.gtceu.common.valueprovider.CastedFloat;
import com.gregtechceu.gtceu.common.valueprovider.FlooredInt;
import com.gregtechceu.gtceu.common.valueprovider.MultipliedFloat;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.IntersectionIngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import com.gregtechceu.gtceu.integration.GTRecipeWidget;
import com.gregtechceu.gtceu.utils.GTHashMaps;
import com.gregtechceu.gtceu.utils.IngredientEquality;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.gregtechceu.gtceu.utils.OverlayedItemHandler;
import com.gregtechceu.gtceu.utils.ResearchManager;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IntersectionIngredient;
import net.minecraftforge.common.crafting.PartialNBTIngredient;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class ItemRecipeCapability
extends RecipeCapability<Ingredient> {
    public static final ItemRecipeCapability CAP = new ItemRecipeCapability();

    protected ItemRecipeCapability() {
        super("item", -2531066, true, 0, SerializerIngredient.INSTANCE);
    }

    @Override
    public Ingredient copyInner(Ingredient content) {
        return SizedIngredient.copy(content);
    }

    @Override
    public Ingredient copyWithModifier(Ingredient content, ContentModifier modifier) {
        if (content instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)content;
            return SizedIngredient.create(sizedIngredient.getInner(), modifier.apply(sizedIngredient.getAmount()).intValue());
        }
        if (content instanceof IntProviderIngredient) {
            IntProviderIngredient intProviderIngredient = (IntProviderIngredient)content;
            return new IntProviderIngredient(intProviderIngredient.getInner(), (IntProvider)new FlooredInt(new AddedFloat(new MultipliedFloat(new CastedFloat(intProviderIngredient.getCountProvider()), (FloatProvider)ConstantFloat.m_146458_((float)((float)modifier.getMultiplier()))), (FloatProvider)ConstantFloat.m_146458_((float)((float)modifier.getAddition())))));
        }
        return SizedIngredient.create(content, modifier.apply(1).intValue());
    }

    @Override
    public List<AbstractMapIngredient> convertToMapIngredient(Object obj) {
        ObjectArrayList ingredients = new ObjectArrayList(1);
        if (obj instanceof Ingredient) {
            Ingredient ingredient = (Ingredient)obj;
            if (ingredient instanceof StrictNBTIngredient) {
                StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient;
                ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
            } else if (ingredient instanceof PartialNBTIngredient) {
                PartialNBTIngredient nbt = (PartialNBTIngredient)ingredient;
                ingredients.addAll(MapItemStackPartialNBTIngredient.from(nbt));
            } else if (ingredient instanceof SizedIngredient) {
                SizedIngredient sized = (SizedIngredient)ingredient;
                Ingredient ingredient2 = sized.getInner();
                if (ingredient2 instanceof StrictNBTIngredient) {
                    StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient2;
                    ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
                } else {
                    ingredient2 = sized.getInner();
                    if (ingredient2 instanceof PartialNBTIngredient) {
                        PartialNBTIngredient nbt = (PartialNBTIngredient)ingredient2;
                        ingredients.addAll(MapItemStackPartialNBTIngredient.from(nbt));
                    } else {
                        ingredient2 = sized.getInner();
                        if (ingredient2 instanceof IntersectionIngredient) {
                            IntersectionIngredient intersection = (IntersectionIngredient)ingredient2;
                            ingredients.add(new MapIntersectionIngredient(intersection));
                        } else {
                            for (Ingredient.Value value : ((IngredientAccessor)sized.getInner()).getValues()) {
                                if (value instanceof Ingredient.TagValue) {
                                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                                    ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                                    continue;
                                }
                                Collection stacks = value.m_6223_();
                                for (ItemStack stack : stacks) {
                                    ingredients.add(new MapItemStackIngredient(stack, sized.getInner()));
                                }
                            }
                        }
                    }
                }
            } else if (ingredient instanceof IntProviderIngredient) {
                IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
                Ingredient ingredient3 = intProvider.getInner();
                if (ingredient3 instanceof StrictNBTIngredient) {
                    StrictNBTIngredient nbt = (StrictNBTIngredient)ingredient3;
                    ingredients.addAll(MapItemStackNBTIngredient.from(nbt));
                } else {
                    ingredient3 = intProvider.getInner();
                    if (ingredient3 instanceof PartialNBTIngredient) {
                        PartialNBTIngredient nbt = (PartialNBTIngredient)ingredient3;
                        ingredients.addAll(MapItemStackPartialNBTIngredient.from(nbt));
                    } else {
                        ingredient3 = intProvider.getInner();
                        if (ingredient3 instanceof IntersectionIngredient) {
                            IntersectionIngredient intersection = (IntersectionIngredient)ingredient3;
                            ingredients.add(new MapIntersectionIngredient(intersection));
                        } else {
                            for (Ingredient.Value value : ((IngredientAccessor)intProvider.getInner()).getValues()) {
                                if (value instanceof Ingredient.TagValue) {
                                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                                    ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                                    continue;
                                }
                                Collection stacks = value.m_6223_();
                                for (ItemStack stack : stacks) {
                                    ingredients.add(new MapItemStackIngredient(stack, intProvider.getInner()));
                                }
                            }
                        }
                    }
                }
            } else if (ingredient instanceof IntersectionIngredient) {
                IntersectionIngredient intersection = (IntersectionIngredient)ingredient;
                ingredients.add(new MapIntersectionIngredient(intersection));
            } else {
                for (Ingredient.Value value : ((IngredientAccessor)ingredient).getValues()) {
                    if (value instanceof Ingredient.TagValue) {
                        Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                        ingredients.add(new MapItemTagIngredient(((TagValueAccessor)tagValue).getTag()));
                        continue;
                    }
                    Collection stacks = value.m_6223_();
                    for (ItemStack stack : stacks) {
                        ingredients.add(new MapItemStackIngredient(stack, ingredient));
                    }
                }
            }
        } else if (obj instanceof ItemStack) {
            TagPrefix prefix;
            ItemStack stack = (ItemStack)obj;
            ingredients.add(new MapItemStackIngredient(stack));
            stack.m_204131_().forEach(arg_0 -> ItemRecipeCapability.lambda$convertToMapIngredient$0((List)ingredients, arg_0));
            if (stack.m_41782_()) {
                ingredients.add(new MapItemStackNBTIngredient(stack, StrictNBTIngredient.of((ItemStack)stack)));
            }
            if (stack.getShareTag() != null) {
                ingredients.add(new MapItemStackPartialNBTIngredient(stack, PartialNBTIngredient.of((ItemLike)stack.m_41720_(), (CompoundTag)stack.getShareTag())));
            }
            if ((prefix = ChemicalHelper.getPrefix((ItemLike)stack.m_41720_())) != null && TagPrefix.ORES.containsKey(prefix)) {
                Material material = ChemicalHelper.getMaterial((ItemLike)stack.m_41720_()).material();
                ingredients.add(new MapIntersectionIngredient((IntersectionIngredient)IntersectionIngredient.of((Ingredient[])new Ingredient[]{Ingredient.m_204132_(prefix.getItemTags(material)[0]), Ingredient.m_204132_(prefix.getItemParentTags()[0])})));
            }
        }
        return ingredients;
    }

    @Override
    public List<Object> compressIngredients(Collection<Object> ingredients) {
        ObjectArrayList list = new ObjectArrayList(ingredients.size());
        for (Object item : ingredients) {
            boolean isEqual;
            if (item instanceof Ingredient) {
                IntProviderIngredient intProvider;
                SizedIngredient sized;
                Ingredient ingredient = (Ingredient)item;
                isEqual = false;
                for (Object obj : list) {
                    ItemStack stack;
                    if (obj instanceof Ingredient) {
                        Ingredient ingredient1 = (Ingredient)obj;
                        if (!IngredientEquality.ingredientEquals(ingredient, ingredient1)) continue;
                        isEqual = true;
                        break;
                    }
                    if (!(obj instanceof ItemStack) || !ingredient.test(stack = (ItemStack)obj)) continue;
                    isEqual = true;
                    break;
                }
                if (isEqual) continue;
                if (ingredient instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                if (ingredient instanceof SizedIngredient && (sized = (SizedIngredient)ingredient).getInner() instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                if (ingredient instanceof IntProviderIngredient && (intProvider = (IntProviderIngredient)ingredient).getInner() instanceof IntCircuitIngredient) {
                    list.add(0, ingredient);
                    continue;
                }
                list.add(ingredient);
                continue;
            }
            if (!(item instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)item;
            isEqual = false;
            for (Object obj : list) {
                ItemStack stack1;
                if (obj instanceof Ingredient) {
                    Ingredient ingredient = (Ingredient)obj;
                    if (!ingredient.test(stack)) continue;
                    isEqual = true;
                    break;
                }
                if (!(obj instanceof ItemStack) || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)(stack1 = (ItemStack)obj))) continue;
                isEqual = true;
                break;
            }
            if (isEqual) continue;
            list.add(stack);
        }
        return list;
    }

    @Override
    public boolean isRecipeSearchFilter() {
        return true;
    }

    @Override
    public int limitParallel(GTRecipe recipe, IRecipeCapabilityHolder holder, int multiplier) {
        if (holder instanceof ICustomParallel) {
            ICustomParallel p = (ICustomParallel)((Object)holder);
            return p.limitParallel(recipe, multiplier);
        }
        int minMultiplier = 0;
        int maxMultiplier = multiplier;
        OverlayedItemHandler itemHandler = new OverlayedItemHandler((IItemHandlerModifiable)new CombinedInvWrapper((IItemHandlerModifiable[])Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.OUT, (Object)CAP), Collections::emptyList).stream().filter(IItemHandlerModifiable.class::isInstance).map(IItemHandlerModifiable.class::cast).toArray(IItemHandlerModifiable[]::new)));
        Object2IntMap<ItemStack> recipeOutputs = GTHashMaps.fromItemStackCollection(recipe.getOutputContents(CAP).stream().map(content -> (Ingredient)CAP.of(content.getContent())).filter(ingredient -> !ingredient.m_43947_()).map(ingredient -> ingredient.m_43908_()[0]).toList());
        while (minMultiplier != maxMultiplier) {
            itemHandler.reset();
            int returnedAmount = 0;
            for (Object2IntMap.Entry entry : recipeOutputs.object2IntEntrySet()) {
                int amountToInsert = entry.getIntValue() != 0 && multiplier > Integer.MAX_VALUE / entry.getIntValue() ? Integer.MAX_VALUE : entry.getIntValue() * multiplier;
                returnedAmount = itemHandler.insertStackedItemStack((ItemStack)entry.getKey(), amountToInsert);
                if (returnedAmount <= 0) continue;
                break;
            }
            int[] bin = ParallelLogic.adjustMultiplier(returnedAmount == 0, minMultiplier, multiplier, maxMultiplier);
            minMultiplier = bin[0];
            multiplier = bin[1];
            maxMultiplier = bin[2];
        }
        return multiplier;
    }

    @Override
    public int getMaxParallelRatio(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelAmount) {
        int available;
        Object2IntMap<ItemStack> ingredientStacks = this.getIngredientStacks(holder);
        int minMultiplier = Integer.MAX_VALUE;
        Object2IntOpenHashMap notConsumableMap = new Object2IntOpenHashMap();
        Object2IntOpenHashMap countableMap = new Object2IntOpenHashMap();
        for (Content content : recipe.getInputContents(CAP)) {
            int ingredientCount;
            Ingredient recipeIngredient = (Ingredient)CAP.of(content.content);
            if (recipeIngredient instanceof SizedIngredient) {
                SizedIngredient sizedIngredient = (SizedIngredient)recipeIngredient;
                ingredientCount = sizedIngredient.getAmount();
            } else if (recipeIngredient instanceof IntProviderIngredient) {
                IntProviderIngredient intProviderIngredient = (IntProviderIngredient)recipeIngredient;
                ingredientCount = intProviderIngredient.getSampledCount(GTValues.RNG);
            } else {
                ingredientCount = 1;
            }
            if (content.chance == 0) {
                notConsumableMap.computeIfPresent((Object)recipeIngredient, (k, v) -> v + ingredientCount);
                notConsumableMap.putIfAbsent((Object)recipeIngredient, ingredientCount);
                continue;
            }
            countableMap.computeIfPresent((Object)recipeIngredient, (k, v) -> v + ingredientCount);
            countableMap.putIfAbsent((Object)recipeIngredient, ingredientCount);
        }
        for (Object2IntMap.Entry recipeInputEntry : notConsumableMap.object2IntEntrySet()) {
            int needed = recipeInputEntry.getIntValue();
            available = 0;
            for (Object2IntMap.Entry inventoryEntry : ingredientStacks.object2IntEntrySet()) {
                if (!((Ingredient)recipeInputEntry.getKey()).test((ItemStack)inventoryEntry.getKey())) continue;
                available = inventoryEntry.getIntValue();
                if (available > needed) {
                    inventoryEntry.setValue(available - needed);
                    needed -= available;
                    break;
                }
                inventoryEntry.setValue(0);
                recipeInputEntry.setValue(needed - available);
                needed -= available;
            }
            if (needed < available) continue;
            return 0;
        }
        if (countableMap.isEmpty() && !notConsumableMap.isEmpty()) {
            return parallelAmount;
        }
        for (Object2IntMap.Entry recipeInputEntry : countableMap.object2IntEntrySet()) {
            int needed = recipeInputEntry.getIntValue();
            available = 0;
            for (Object2IntMap.Entry inventoryEntry : ingredientStacks.object2IntEntrySet()) {
                if (!((Ingredient)recipeInputEntry.getKey()).test((ItemStack)inventoryEntry.getKey())) continue;
                available += inventoryEntry.getIntValue();
                break;
            }
            if (available >= needed) {
                int ratio = Math.min(parallelAmount, available / needed);
                if (ratio >= minMultiplier) continue;
                minMultiplier = ratio;
                continue;
            }
            return 0;
        }
        return minMultiplier;
    }

    private Object2IntMap<ItemStack> getIngredientStacks(IRecipeCapabilityHolder holder) {
        Object2IntOpenCustomHashMap map = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        Object2IntOpenHashMap result = new Object2IntOpenHashMap();
        List<IRecipeHandler> recipeHandlerList = Objects.requireNonNullElseGet((List)holder.getCapabilitiesProxy().get((Object)IO.IN, (Object)CAP), Collections::emptyList).stream().filter(handler -> !handler.isProxy()).toList();
        for (IRecipeHandler container : recipeHandlerList) {
            Object2IntOpenCustomHashMap itemMap = container.getContents().stream().filter(ItemStack.class::isInstance).map(ItemStack.class::cast).flatMap(con -> GTHashMaps.fromItemStackCollection(Collections.singleton(con)).object2IntEntrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, () -> new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount())));
            if (container.isDistinct()) {
                result.putAll((Map)itemMap);
                continue;
            }
            for (Object2IntMap.Entry obj : itemMap.object2IntEntrySet()) {
                map.computeInt((Object)((ItemStack)obj.getKey()), (k, v) -> v == null ? obj.getIntValue() : v + obj.getIntValue());
            }
        }
        result.putAll((Map)map);
        return result;
    }

    @Override
    @NotNull
    public List<Object> createXEIContainerContents(List<Content> contents, GTRecipe recipe, IO io) {
        ArrayList<Either> outputStacks = contents.stream().map(content -> content.content).map(this::of).map(ItemRecipeCapability::mapItem).collect(Collectors.toList());
        ArrayList<Either> scannerPossibilities = null;
        if (io == IO.OUT && recipe.recipeType.isScanner()) {
            scannerPossibilities = new ArrayList<Either>();
            Pair<GTRecipeType, String> researchData = null;
            for (Content stack : recipe.getOutputContents(CAP)) {
                researchData = ResearchManager.readResearchId(((Ingredient)CAP.of(stack.content)).m_43908_()[0]);
                if (researchData == null) continue;
                break;
            }
            if (researchData != null) {
                Collection<GTRecipe> possibleRecipes = ((GTRecipeType)researchData.getFirst()).getDataStickEntry((String)researchData.getSecond());
                if (possibleRecipes != null) {
                    for (GTRecipe r : possibleRecipes) {
                        ItemStack researchItem = ((Ingredient)CAP.of(r.getOutputContents(ItemRecipeCapability.CAP).get((int)0).content)).m_43908_()[0];
                        researchItem = researchItem.m_41777_();
                        researchItem.m_41764_(1);
                        boolean didMatch = false;
                        block2: for (Either stacks : scannerPossibilities) {
                            for (ItemStack stack : (List)stacks.map(tag -> tag.stream().flatMap(key -> BuiltInRegistries.f_257033_.m_203431_((TagKey)key.getFirst()).stream()).flatMap(holders -> holders.m_203614_().map(holder -> new ItemStack((ItemLike)holder.get()))).collect(Collectors.toList()), Function.identity())) {
                                if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)researchItem)) continue;
                                didMatch = true;
                                continue block2;
                            }
                        }
                        if (didMatch) continue;
                        scannerPossibilities.add(Either.right(List.of(researchItem)));
                    }
                }
                scannerPossibilities.add((Either)outputStacks.get(0));
            }
        }
        if (scannerPossibilities != null && !scannerPossibilities.isEmpty()) {
            outputStacks = scannerPossibilities;
        }
        while (outputStacks.size() < recipe.recipeType.getMaxOutputs(CAP)) {
            outputStacks.add(null);
        }
        return new ArrayList<Object>(outputStacks);
    }

    @Override
    public Object createXEIContainer(List<?> contents) {
        return new TagOrCycleItemStackHandler(contents);
    }

    @Override
    @NotNull
    public Widget createWidget() {
        SlotWidget slot = new SlotWidget();
        slot.initTemplate();
        return slot;
    }

    @Override
    @NotNull
    public Class<? extends Widget> getWidgetClass() {
        return SlotWidget.class;
    }

    @Override
    public void applyWidgetInfo(@NotNull Widget widget, int index, boolean isXEI, IO io,  @UnknownNullability(value="null when storage == null") GTRecipeTypeUI.RecipeHolder recipeHolder, @NotNull GTRecipeType recipeType, @UnknownNullability(value="null when content == null") GTRecipe recipe, @Nullable Content content, @Nullable Object storage, int tier, int minTier) {
        if (widget instanceof SlotWidget) {
            SlotWidget slot = (SlotWidget)widget;
            if (storage instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable items = (IItemHandlerModifiable)storage;
                if (index >= 0 && index < items.getSlots()) {
                    slot.setHandlerSlot(items, index);
                    slot.setIngredientIO(io == IO.IN ? IngredientIO.INPUT : IngredientIO.OUTPUT);
                    slot.setCanTakeItems(!isXEI);
                    slot.setCanPutItems(!isXEI && io.support(IO.IN));
                }
                if (isXEI && recipeType.isHasResearchSlot() && index == items.getSlots() && ConfigHolder.INSTANCE.machines.enableResearch) {
                    ResearchCondition condition = recipeHolder.conditions().stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
                    if (condition != null) {
                        ArrayList<ItemStack> dataItems = new ArrayList<ItemStack>();
                        for (ResearchData.ResearchEntry entry : condition.data) {
                            ItemStack dataStick = entry.getDataItem().m_41777_();
                            ResearchManager.writeResearchToNBT(dataStick.m_41784_(), entry.getResearchId(), recipeType);
                            dataItems.add(dataStick);
                        }
                        CycleItemStackHandler handler = new CycleItemStackHandler(List.of(dataItems));
                        slot.setHandlerSlot(handler, 0);
                        slot.setIngredientIO(IngredientIO.INPUT);
                        slot.setCanTakeItems(false);
                        slot.setCanPutItems(false);
                    }
                }
            }
            if (content != null) {
                float chance = (float)recipeType.getChanceFunction().getBoostedChance(content, minTier, tier) / (float)content.maxChance;
                slot.setXEIChance(chance);
                slot.setOnAddedTooltips((w, tooltips) -> {
                    GTRecipeWidget.setConsumedChance(content, recipe.getChanceLogicForCapability(this, io, this.isTickSlot(index, io, recipe)), tooltips, tier, minTier, recipeType.getChanceFunction());
                    Object patt27620$temp = this.of(content.content);
                    if (patt27620$temp instanceof IntProviderIngredient) {
                        IntProviderIngredient ingredient = (IntProviderIngredient)((Object)((Object)patt27620$temp));
                        countProvider = ingredient.getCountProvider();
                        tooltips.add(Component.m_237110_((String)"gtceu.gui.content.count_range", (Object[])new Object[]{countProvider.m_142739_(), countProvider.m_142737_()}).m_130940_(ChatFormatting.GOLD));
                    } else {
                        SizedIngredient sizedIngredient;
                        Ingredient patt28156$temp;
                        Object patt28055$temp = this.of(content.content);
                        if (patt28055$temp instanceof SizedIngredient && (patt28156$temp = (sizedIngredient = (SizedIngredient)((Object)((Object)patt28055$temp))).getInner()) instanceof IntProviderIngredient) {
                            IntProviderIngredient ingredient = (IntProviderIngredient)patt28156$temp;
                            countProvider = ingredient.getCountProvider();
                            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.count_range", (Object[])new Object[]{countProvider.m_142739_(), countProvider.m_142737_()}).m_130940_(ChatFormatting.GOLD));
                        }
                    }
                    if (this.isTickSlot(index, io, recipe)) {
                        tooltips.add(Component.m_237115_((String)"gtceu.gui.content.per_tick"));
                    }
                });
                if (io == IO.IN && (content.chance == 0 || this.of(content.content) instanceof IntCircuitIngredient)) {
                    slot.setIngredientIO(IngredientIO.CATALYST);
                }
            }
        }
    }

    private static Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> mapItem(Ingredient ingredient) {
        if (ingredient instanceof SizedIngredient) {
            Ingredient.Value children;
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            int amount = sizedIngredient.getAmount();
            Ingredient ingredient2 = sizedIngredient.getInner();
            if (ingredient2 instanceof IntersectionIngredient) {
                IntersectionIngredient intersection = (IntersectionIngredient)ingredient2;
                children = ((IntersectionIngredientAccessor)intersection).getChildren();
                if (children.isEmpty()) {
                    return Either.right(null);
                }
                Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> childEither = ItemRecipeCapability.mapItem(children.get(0));
                return Either.right((Object)((List)childEither.map(arg_0 -> ItemRecipeCapability.lambda$mapItem$21((List)children, amount, arg_0), arg_0 -> ItemRecipeCapability.lambda$mapItem$22((List)children, amount, arg_0))));
            }
            if (((IngredientAccessor)sizedIngredient.getInner()).getValues().length > 0 && (children = ((IngredientAccessor)sizedIngredient.getInner()).getValues()[0]) instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)children;
                return Either.left(List.of(Pair.of(((TagValueAccessor)tagValue).getTag(), (Object)amount)));
            }
        } else {
            Ingredient.Value value;
            if (ingredient instanceof IntersectionIngredient) {
                IntersectionIngredient intersection = (IntersectionIngredient)ingredient;
                List<Ingredient> children = ((IntersectionIngredientAccessor)intersection).getChildren();
                if (children.isEmpty()) {
                    return Either.right(null);
                }
                Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> childEither = ItemRecipeCapability.mapItem(children.get(0));
                return Either.right((Object)((List)childEither.map(tags -> {
                    List tagItems = tags.stream().map(pair -> Pair.of(BuiltInRegistries.f_257033_.m_203431_((TagKey)pair.getFirst()).stream(), (Object)((Integer)pair.getSecond()))).flatMap(pair -> ((Stream)pair.getFirst()).flatMap(tag -> tag.m_203614_().map(holder -> new ItemStack((ItemLike)holder.m_203334_(), ((Integer)pair.getSecond()).intValue())))).collect(Collectors.toList());
                    ListIterator iterator = tagItems.listIterator();
                    block0: while (iterator.hasNext()) {
                        ItemStack item = (ItemStack)iterator.next();
                        for (int i = 1; i < children.size(); ++i) {
                            if (((Ingredient)children.get(i)).test(item)) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                    return tagItems;
                }, items -> {
                    items = new ArrayList(items);
                    ListIterator iterator = items.listIterator();
                    block0: while (iterator.hasNext()) {
                        ItemStack item = (ItemStack)iterator.next();
                        for (int i = 1; i < children.size(); ++i) {
                            if (((Ingredient)children.get(i)).test(item)) continue;
                            iterator.remove();
                            continue block0;
                        }
                    }
                    return items;
                })));
            }
            if (ingredient instanceof IntProviderIngredient) {
                Ingredient.Value value2;
                IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
                boolean amount = true;
                Object children = intProvider.getInner();
                if (children instanceof IntersectionIngredient) {
                    IntersectionIngredient intersection = (IntersectionIngredient)children;
                    if ((children = ((IntersectionIngredientAccessor)intersection).getChildren()).isEmpty()) {
                        return Either.right(null);
                    }
                    Either<List<Pair<TagKey<Item>, Integer>>, List<ItemStack>> childEither = ItemRecipeCapability.mapItem((Ingredient)children.get(0));
                    return Either.right((Object)((List)childEither.map(arg_0 -> ItemRecipeCapability.lambda$mapItem$33((List)children, arg_0), arg_0 -> ItemRecipeCapability.lambda$mapItem$34((List)children, arg_0))));
                }
                if (((IngredientAccessor)intProvider.getInner()).getValues().length > 0 && (value2 = ((IngredientAccessor)intProvider.getInner()).getValues()[0]) instanceof Ingredient.TagValue) {
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value2;
                    return Either.left(List.of(Pair.of(((TagValueAccessor)tagValue).getTag(), (Object)1)));
                }
            } else if (((IngredientAccessor)ingredient).getValues().length > 0 && (value = ((IngredientAccessor)ingredient).getValues()[0]) instanceof Ingredient.TagValue) {
                Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                return Either.left(List.of(Pair.of(((TagValueAccessor)tagValue).getTag(), (Object)1)));
            }
        }
        return Either.right(Arrays.stream(ingredient.m_43908_()).map(stack -> {
            SizedIngredient sized;
            if (ingredient instanceof IntProviderIngredient) {
                stack.m_41764_(1);
            } else if (ingredient instanceof SizedIngredient && (sized = (SizedIngredient)ingredient).getInner() instanceof IntProviderIngredient) {
                stack.m_41764_(1);
            }
            return stack;
        }).toList());
    }

    @Override
    public Object2IntMap<Ingredient> makeChanceCache() {
        return new Object2IntOpenCustomHashMap((Hash.Strategy)IngredientEquality.IngredientHashStrategy.INSTANCE);
    }

    private static /* synthetic */ List lambda$mapItem$34(List children, List items) {
        items = new ArrayList(items);
        ListIterator<ItemStack> iterator = items.listIterator();
        block0: while (iterator.hasNext()) {
            ItemStack item = (ItemStack)iterator.next();
            for (int i = 1; i < children.size(); ++i) {
                if (((Ingredient)children.get(i)).test(item)) continue;
                iterator.remove();
                continue block0;
            }
            iterator.set(item.m_255036_(1));
        }
        return items;
    }

    private static /* synthetic */ List lambda$mapItem$33(List children, List tags) {
        List tagItems = tags.stream().map(pair -> Pair.of(BuiltInRegistries.f_257033_.m_203431_((TagKey)pair.getFirst()).stream(), (Object)((Integer)pair.getSecond()))).flatMap(pair -> ((Stream)pair.getFirst()).flatMap(tag -> tag.m_203614_().map(holder -> new ItemStack((ItemLike)holder.m_203334_(), ((Integer)pair.getSecond()).intValue())))).collect(Collectors.toList());
        ListIterator iterator = tagItems.listIterator();
        block0: while (iterator.hasNext()) {
            ItemStack item = (ItemStack)iterator.next();
            for (int i = 1; i < children.size(); ++i) {
                if (((Ingredient)children.get(i)).test(item)) continue;
                iterator.remove();
                continue block0;
            }
            iterator.set(item.m_255036_(1));
        }
        return tagItems;
    }

    private static /* synthetic */ List lambda$mapItem$22(List children, int amount, List items) {
        items = new ArrayList(items);
        ListIterator<ItemStack> iterator = items.listIterator();
        block0: while (iterator.hasNext()) {
            ItemStack item = (ItemStack)iterator.next();
            for (int i = 1; i < children.size(); ++i) {
                if (((Ingredient)children.get(i)).test(item)) continue;
                iterator.remove();
                continue block0;
            }
            iterator.set(item.m_255036_(amount));
        }
        return items;
    }

    private static /* synthetic */ List lambda$mapItem$21(List children, int amount, List tags) {
        List tagItems = tags.stream().map(pair -> Pair.of(BuiltInRegistries.f_257033_.m_203431_((TagKey)pair.getFirst()).stream(), (Object)((Integer)pair.getSecond()))).flatMap(pair -> ((Stream)pair.getFirst()).flatMap(tag -> tag.m_203614_().map(holder -> new ItemStack((ItemLike)holder.m_203334_(), ((Integer)pair.getSecond()).intValue())))).collect(Collectors.toList());
        ListIterator iterator = tagItems.listIterator();
        block0: while (iterator.hasNext()) {
            ItemStack item = (ItemStack)iterator.next();
            for (int i = 1; i < children.size(); ++i) {
                if (((Ingredient)children.get(i)).test(item)) continue;
                iterator.remove();
                continue block0;
            }
            iterator.set(item.m_255036_(amount));
        }
        return tagItems;
    }

    private static /* synthetic */ void lambda$convertToMapIngredient$0(List ingredients, TagKey tag) {
        ingredients.add(new MapItemTagIngredient((TagKey<Item>)tag));
    }

    public static interface ICustomParallel {
        public int limitParallel(GTRecipe var1, int var2);
    }
}

