/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.compat;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.compat.CapabilityCompatProvider;
import com.gregtechceu.gtceu.api.capability.compat.FeCompat;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EUToFEProvider
extends CapabilityCompatProvider {
    private long feBuffer;

    public EUToFEProvider(BlockEntity tileEntity) {
        super((ICapabilityProvider)tileEntity);
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
        if (!ConfigHolder.INSTANCE.compat.energy.nativeEUToFE || capability != GTCapability.CAPABILITY_ENERGY_CONTAINER) {
            return LazyOptional.empty();
        }
        LazyOptional energyStorage = this.getUpvalueCapability(ForgeCapabilities.ENERGY, facing);
        return energyStorage.isPresent() ? GTCapability.CAPABILITY_ENERGY_CONTAINER.orEmpty(capability, LazyOptional.of(() -> new GTEnergyWrapper((IEnergyStorage)energyStorage.resolve().get()))) : LazyOptional.empty();
    }

    public class GTEnergyWrapper
    implements IEnergyContainer {
        private final IEnergyStorage energyStorage;

        public GTEnergyWrapper(IEnergyStorage energyStorage) {
            this.energyStorage = energyStorage;
        }

        @Override
        public long acceptEnergyFromNetwork(Direction facing, long voltage, long amperage) {
            int receive = 0;
            if (EUToFEProvider.this.feBuffer > 0L) {
                receive = this.energyStorage.receiveEnergy(GTMath.saturatedCast(EUToFEProvider.this.feBuffer), true);
                if (receive == 0) {
                    return 0L;
                }
                if (EUToFEProvider.this.feBuffer > (long)receive) {
                    EUToFEProvider.this.feBuffer -= (long)receive;
                    this.energyStorage.receiveEnergy(receive, false);
                    return 0L;
                }
                receive = GTMath.saturatedCast(EUToFEProvider.this.feBuffer);
                EUToFEProvider.this.feBuffer = 0L;
            }
            long maxPacket = FeCompat.toFeLong(voltage, FeCompat.ratio(false));
            long maximalValue = maxPacket * amperage;
            if (receive != 0) {
                int consumable = this.energyStorage.receiveEnergy(GTMath.saturatedCast(maximalValue + (long)receive), true);
                if (consumable == 0) {
                    return 0L;
                }
                if (consumable == receive) {
                    this.energyStorage.receiveEnergy(consumable, false);
                    return 0L;
                }
                if ((long)consumable == maximalValue + (long)receive) {
                    this.energyStorage.receiveEnergy(consumable, false);
                    return amperage;
                }
                long newPower = consumable - receive;
                if (newPower % maxPacket == 0L) {
                    return (long)this.energyStorage.receiveEnergy(consumable, false) / maxPacket;
                }
                int ampsToConsume = GTMath.saturatedCast(newPower / maxPacket + 1L);
                EUToFEProvider.this.feBuffer = GTMath.saturatedCast(maxPacket * (long)ampsToConsume - (long)consumable);
                this.energyStorage.receiveEnergy(consumable, false);
                return ampsToConsume;
            }
            int consumable = this.energyStorage.receiveEnergy(GTMath.saturatedCast(maximalValue), true);
            if (consumable == 0) {
                return 0L;
            }
            if ((long)consumable == maximalValue) {
                this.energyStorage.receiveEnergy(consumable, false);
                return amperage;
            }
            if ((long)consumable % maxPacket == 0L) {
                return (long)this.energyStorage.receiveEnergy(consumable, false) / maxPacket;
            }
            int ampsToConsume = GTMath.saturatedCast((long)consumable / maxPacket + 1L);
            EUToFEProvider.this.feBuffer = GTMath.saturatedCast(maxPacket * (long)ampsToConsume - (long)consumable);
            this.energyStorage.receiveEnergy(consumable, false);
            return ampsToConsume;
        }

        @Override
        public long changeEnergy(long delta) {
            if (delta == 0L) {
                return 0L;
            }
            if (delta < 0L) {
                return FeCompat.extractEu(this.energyStorage, -delta, false);
            }
            return FeCompat.insertEu(this.energyStorage, delta, false);
        }

        @Override
        public long getEnergyCapacity() {
            return FeCompat.toEu(this.energyStorage.getMaxEnergyStored(), FeCompat.ratio(false));
        }

        @Override
        public long getEnergyStored() {
            return FeCompat.toEu(this.energyStorage.getEnergyStored(), FeCompat.ratio(false));
        }

        @Override
        public long getEnergyCanBeInserted() {
            return Math.max(1L, this.getEnergyCapacity() - this.getEnergyStored());
        }

        @Override
        public long getInputAmperage() {
            return this.getInputVoltage() == 0L ? 0L : 2L;
        }

        @Override
        public long getInputVoltage() {
            long maxInput = this.energyStorage.receiveEnergy(Integer.MAX_VALUE, true);
            if (maxInput == 0L) {
                return 0L;
            }
            return GTValues.V[GTUtil.getTierByVoltage(FeCompat.toEu(maxInput, FeCompat.ratio(false)))];
        }

        @Override
        public boolean inputsEnergy(Direction facing) {
            return this.energyStorage.canReceive();
        }

        @Override
        public boolean outputsEnergy(Direction facing) {
            return false;
        }

        @Override
        public boolean isOneProbeHidden() {
            return true;
        }
    }
}

