/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import org.jetbrains.annotations.NotNull;

public class OverlayingFluidStorage
implements IFluidStorage {
    private final IFluidTransfer transfer;
    private final int tank;

    public void onContentsChanged() {
        this.transfer.onContentsChanged();
    }

    @NotNull
    public FluidStack getFluid() {
        return this.transfer.getFluidInTank(this.tank);
    }

    public void setFluid(FluidStack fluid) {
        this.transfer.setFluidInTank(this.tank, fluid);
    }

    public long getCapacity() {
        return this.transfer.getTankCapacity(this.tank);
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.transfer.isFluidValid(this.tank, stack);
    }

    public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        IFluidTransfer iFluidTransfer = this.transfer;
        if (iFluidTransfer instanceof NotifiableFluidTank) {
            NotifiableFluidTank notifiable = (NotifiableFluidTank)iFluidTransfer;
            return notifiable.getStorages()[this.tank].fill(resource, simulate, notifyChanges);
        }
        return this.transfer.fill(this.tank, resource, simulate, notifyChanges);
    }

    public boolean supportsFill(int tank) {
        return this.transfer.supportsFill(this.tank);
    }

    @NotNull
    public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
        IFluidTransfer iFluidTransfer = this.transfer;
        if (iFluidTransfer instanceof NotifiableFluidTank) {
            NotifiableFluidTank notifiable = (NotifiableFluidTank)iFluidTransfer;
            return notifiable.getStorages()[this.tank].drain(resource, simulate, notifyChanges);
        }
        return this.transfer.drain(this.tank, resource, simulate, notifyChanges);
    }

    public boolean supportsDrain(int tank) {
        return this.transfer.supportsDrain(this.tank);
    }

    @NotNull
    public Object createSnapshot() {
        return this.transfer.createSnapshot();
    }

    public void restoreFromSnapshot(Object snapshot) {
        this.transfer.restoreFromSnapshot(snapshot);
    }

    public OverlayingFluidStorage(IFluidTransfer transfer, int tank) {
        this.transfer = transfer;
        this.tank = tank;
    }
}

