/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.utils.GTHashMaps;
import com.gregtechceu.gtceu.utils.OverlayedFluidHandler;
import com.gregtechceu.gtceu.utils.OverlayedItemHandler;
import com.lowdragmc.lowdraglib.misc.FluidTransferList;
import com.lowdragmc.lowdraglib.misc.ItemHandlerHelper;
import com.lowdragmc.lowdraglib.misc.ItemTransferList;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GTTransferUtils {
    public static int transferFluids(@NotNull IFluidTransfer sourceHandler, @NotNull IFluidTransfer destHandler) {
        return GTTransferUtils.transferFluids(sourceHandler, destHandler, Integer.MAX_VALUE, fluidStack -> true);
    }

    public static int transferFluids(@NotNull IFluidTransfer sourceHandler, @NotNull IFluidTransfer destHandler, int transferLimit) {
        return GTTransferUtils.transferFluids(sourceHandler, destHandler, transferLimit, fluidStack -> true);
    }

    public static int transferFluids(@NotNull IFluidTransfer sourceHandler, @NotNull IFluidTransfer destHandler, int transferLimit, @NotNull Predicate<FluidStack> fluidFilter) {
        int fluidLeftToTransfer = transferLimit;
        for (int i = 0; i < sourceHandler.getTanks(); ++i) {
            long canInsertAmount;
            FluidStack currentFluid = sourceHandler.getFluidInTank(i);
            if (currentFluid.isEmpty() || !fluidFilter.test(currentFluid)) continue;
            currentFluid.setAmount((long)fluidLeftToTransfer);
            FluidStack fluidStack = sourceHandler.drain(currentFluid, true);
            if (fluidStack.isEmpty() || (canInsertAmount = destHandler.fill(fluidStack, true)) <= 0L) continue;
            fluidStack.setAmount(canInsertAmount);
            fluidStack = sourceHandler.drain(fluidStack, false);
            if (fluidStack == FluidStack.empty() || fluidStack.getAmount() <= 0L) continue;
            GTTransferUtils.fillFluidAccountNotifiableList(destHandler, fluidStack, false);
            fluidLeftToTransfer = (int)((long)fluidLeftToTransfer - fluidStack.getAmount());
            if (fluidLeftToTransfer == 0) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }

    public static boolean transferExactFluidStack(@NotNull IFluidTransfer sourceHandler, @NotNull IFluidTransfer destHandler, FluidStack fluidStack) {
        long amount = fluidStack.getAmount();
        FluidStack sourceFluid = sourceHandler.drain(fluidStack, true);
        if (sourceFluid == FluidStack.empty() || sourceFluid.getAmount() != amount) {
            return false;
        }
        long canInsertAmount = destHandler.fill(sourceFluid, true);
        if (canInsertAmount == amount && (sourceFluid = sourceHandler.drain(sourceFluid, false)) != FluidStack.empty() && sourceFluid.getAmount() > 0L) {
            destHandler.fill(sourceFluid, false);
            return true;
        }
        return false;
    }

    public static void moveInventoryItems(IItemTransfer sourceInventory, IItemTransfer targetInventory) {
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.m_41619_()) continue;
            ItemStack remainder = GTTransferUtils.insertItem(targetInventory, sourceStack, true);
            int amountToInsert = sourceStack.m_41613_() - remainder.m_41613_();
            if (amountToInsert <= 0) continue;
            sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false);
            GTTransferUtils.insertItem(targetInventory, sourceStack, false);
        }
    }

    public static boolean addItemsToItemHandler(IItemTransfer handler, boolean simulate, List<ItemStack> items) {
        if (simulate) {
            OverlayedItemHandler overlayedItemHandler = new OverlayedItemHandler(handler);
            Object2IntMap<ItemStack> stackKeyMap = GTHashMaps.fromItemStackCollection(items);
            for (Object2IntMap.Entry entry : stackKeyMap.object2IntEntrySet()) {
                int amountToInsert = entry.getIntValue();
                int amount = overlayedItemHandler.insertStackedItemStack((ItemStack)entry.getKey(), amountToInsert);
                if (amount <= 0) continue;
                return false;
            }
            return true;
        }
        items.forEach(stack -> GTTransferUtils.insertItem(handler, stack, false));
        return true;
    }

    public static boolean addFluidsToFluidHandler(FluidTransferList fluidHandler, boolean simulate, List<FluidStack> fluidStacks) {
        if (simulate) {
            OverlayedFluidHandler overlayedFluidHandler = new OverlayedFluidHandler(fluidHandler);
            for (FluidStack fluidStack : fluidStacks) {
                long inserted = overlayedFluidHandler.insertFluid(fluidStack, fluidStack.getAmount());
                if (inserted == fluidStack.getAmount()) continue;
                return false;
            }
            return true;
        }
        for (FluidStack fluidStack : fluidStacks) {
            GTTransferUtils.fillFluidAccountNotifiableList((IFluidTransfer)fluidHandler, fluidStack, false);
        }
        return true;
    }

    public static long fillFluidAccountNotifiableList(IFluidTransfer handler, FluidStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return 0L;
        }
        if (handler instanceof FluidTransferList) {
            FluidTransferList transferList = (FluidTransferList)handler;
            FluidStack copied = stack.copy();
            for (IFluidTransfer transfer : transferList.transfers) {
                FluidStack candidate = copied.copy();
                if (transfer instanceof NotifiableFluidTank) {
                    NotifiableFluidTank notifiable = (NotifiableFluidTank)transfer;
                    copied.shrink(notifiable.fillInternal(candidate, simulate));
                } else {
                    copied.shrink(transfer.fill(candidate, simulate));
                }
                if (copied.isEmpty()) break;
            }
            return stack.getAmount() - copied.getAmount();
        }
        return handler.fill(stack, simulate);
    }

    public static FluidStack drainFluidAccountNotifiableList(IFluidTransfer handler, FluidStack stack, boolean simulate) {
        if (stack.isEmpty()) {
            return FluidStack.empty();
        }
        if (handler instanceof FluidTransferList) {
            FluidTransferList transferList = (FluidTransferList)handler;
            FluidStack copied = stack.copy();
            for (IFluidTransfer transfer : transferList.transfers) {
                FluidStack candidate = copied.copy();
                if (transfer instanceof NotifiableFluidTank) {
                    NotifiableFluidTank notifiable = (NotifiableFluidTank)transfer;
                    copied.shrink(notifiable.drainInternal(candidate, simulate).getAmount());
                } else {
                    copied.shrink(transfer.drain(candidate, simulate).getAmount());
                }
                if (copied.isEmpty()) break;
            }
            copied.setAmount(stack.getAmount() - copied.getAmount());
            return copied;
        }
        return handler.drain(stack, simulate);
    }

    public static ItemStack insertItem(IItemTransfer handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            return GTTransferUtils.insertToEmpty(handler, stack, simulate);
        }
        IntArrayList emptySlots = new IntArrayList();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.m_41619_()) {
                emptySlots.add(i);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotStack) || !(stack = GTTransferUtils.insertItemAccountNotifiableList(handler, i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        IntListIterator intListIterator = emptySlots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            stack = GTTransferUtils.insertItemAccountNotifiableList(handler, slot, stack, simulate);
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public static ItemStack insertItemAccountNotifiableList(IItemTransfer handler, int slot, ItemStack stack, boolean simulate) {
        if (handler instanceof ItemTransferList) {
            ItemTransferList transferList = (ItemTransferList)handler;
            int index = 0;
            for (IItemTransfer transfer : transferList.transfers) {
                if (slot - index < transfer.getSlots()) {
                    if (transfer instanceof NotifiableItemStackHandler) {
                        NotifiableItemStackHandler notifiable = (NotifiableItemStackHandler)transfer;
                        return notifiable.insertItemInternal(slot - index, stack, simulate);
                    }
                    return transfer.insertItem(slot - index, stack, simulate);
                }
                index += transfer.getSlots();
            }
            return stack;
        }
        return handler.insertItem(slot, stack, simulate);
    }

    public static ItemStack extractItemAccountNotifiableList(IItemTransfer handler, int slot, int amount, boolean simulate) {
        if (handler instanceof ItemTransferList) {
            ItemTransferList transferList = (ItemTransferList)handler;
            int index = 0;
            for (IItemTransfer transfer : transferList.transfers) {
                if (slot - index < transfer.getSlots()) {
                    if (transfer instanceof NotifiableItemStackHandler) {
                        NotifiableItemStackHandler notifiable = (NotifiableItemStackHandler)transfer;
                        return notifiable.extractItemInternal(slot - index, amount, simulate);
                    }
                    return transfer.extractItem(slot - index, amount, simulate);
                }
                index += transfer.getSlots();
            }
            return ItemStack.f_41583_;
        }
        return handler.extractItem(slot, amount, simulate);
    }

    public static ItemStack insertToEmpty(IItemTransfer handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.m_41619_()) {
            return stack;
        }
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!slotStack.m_41619_() || !(stack = GTTransferUtils.insertItemAccountNotifiableList(handler, i, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }
}

