/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.test.api.machine.trait;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.core.mixins.RecipeManagerAccessor;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.BeforeBatch;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RecipeLogicTest {
    private static boolean hasInjectedRecipe = false;

    @BeforeBatch(batch="gtceu")
    public static void replaceRecipeManagerEntries(ServerLevel level) {
        if (hasInjectedRecipe) {
            return;
        }
        HashMap recipes = new HashMap(((RecipeManagerAccessor)level.m_7465_()).getRawRecipes());
        ((RecipeManagerAccessor)level.m_7465_()).setRawRecipes(recipes);
        recipes.replaceAll((k, v) -> new HashMap(v));
    }

    @GameTest(template="gtceu:recipelogic")
    public static void recipeLogicTest(GameTestHelper helper) {
        RecipeLogicTest.replaceRecipeManagerEntries(helper.m_177100_());
        BlockEntity holder = helper.m_177347_(new BlockPos(0, 2, 0));
        if (!(holder instanceof MetaMachineBlockEntity)) {
            helper.m_177284_("wrong block at relative pos [0,1,0]!");
            return;
        }
        MetaMachineBlockEntity atte = (MetaMachineBlockEntity)holder;
        MetaMachine machine = atte.getMetaMachine();
        if (!(machine instanceof IRecipeLogicMachine)) {
            helper.m_177284_("wrong machine in MetaMachineBlockEntity!");
            return;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        GTRecipe recipe = GTRecipeBuilder.ofRaw().id(GTCEu.id("test")).inputItems(new ItemStack((ItemLike)Blocks.f_50652_)).outputItems(new ItemStack((ItemLike)Blocks.f_50069_)).EUt(1L).duration(1).buildRawRecipe();
        if (!hasInjectedRecipe) {
            ((RecipeManagerAccessor)helper.m_177100_().m_7465_()).getRawRecipes().get(GTRecipeTypes.CHEMICAL_RECIPES).put(GTCEu.id("test"), recipe);
            hasInjectedRecipe = true;
        }
        RecipeLogic arl = rlm.getRecipeLogic();
        arl.findAndHandleRecipe();
        helper.m_277053_(arl.isActive(), "Recipe logic is active, even when it shouldn't be");
        helper.m_246336_(arl.getLastRecipe() == null, "Recipe logic has somehow found a recipe, when there should be none");
        ((IItemTransfer)((List)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP)).get(0)).insertItem(0, new ItemStack((ItemLike)Blocks.f_50652_, 16), false);
        arl.findAndHandleRecipe();
        helper.m_277053_(arl.getLastRecipe() == null, "Last recipe is empty, even though recipe logic should've found a recipe.");
        helper.m_246336_(arl.isActive(), "Recipelogic is inactive, when it should be active.");
        int stackCount = ((IItemTransfer)((List)rlm.getCapabilitiesProxy().get((Object)IO.IN, (Object)ItemRecipeCapability.CAP)).get(0)).getStackInSlot(0).m_41613_();
        helper.m_246336_(stackCount == 15, "Count is wrong (should be 15, when it's %s".formatted(stackCount));
        GTRecipe prev = arl.getLastRecipe();
        arl.serverTick();
        helper.m_246336_(arl.getLastRecipe() == prev, "lastRecipe is wrong");
        helper.m_246336_(ItemStack.m_41656_((ItemStack)((IItemTransfer)((List)rlm.getCapabilitiesProxy().get((Object)IO.OUT, (Object)ItemRecipeCapability.CAP)).get(0)).getStackInSlot(0), (ItemStack)new ItemStack((ItemLike)Blocks.f_50069_, 1)), "wrong output stack.");
        helper.m_246336_(arl.isActive(), "RecipeLogic is not active, when it should be.");
        ((IItemTransfer)((List)rlm.getCapabilitiesProxy().get((Object)IO.OUT, (Object)ItemRecipeCapability.CAP)).get(0)).setStackInSlot(0, new ItemStack((ItemLike)Blocks.f_50069_, 63));
        ((IItemTransfer)((List)rlm.getCapabilitiesProxy().get((Object)IO.OUT, (Object)ItemRecipeCapability.CAP)).get(0)).setStackInSlot(1, new ItemStack((ItemLike)Blocks.f_50069_, 64));
        arl.serverTick();
        helper.m_277053_(arl.isActive(), "RecipeLogic is active, when it shouldn't be.");
        arl.serverTick();
        helper.m_277053_(arl.isActive(), "Recipelogic is active, when it shouldn't be.");
        ((IItemTransfer)((List)rlm.getCapabilitiesProxy().get((Object)IO.OUT, (Object)ItemRecipeCapability.CAP)).get(0)).setStackInSlot(1, ItemStack.f_41583_);
        arl.serverTick();
        helper.m_246336_(ItemStack.m_41656_((ItemStack)((IItemTransfer)((List)rlm.getCapabilitiesProxy().get((Object)IO.OUT, (Object)ItemRecipeCapability.CAP)).get(0)).getStackInSlot(0), (ItemStack)new ItemStack((ItemLike)Blocks.f_50069_, 1)), "Wrong stack.");
        helper.m_177412_();
    }
}

