/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.StressRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.ResearchRecipeBuilder;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.NBTIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.common.recipe.BiomeCondition;
import com.gregtechceu.gtceu.common.recipe.CleanroomCondition;
import com.gregtechceu.gtceu.common.recipe.DimensionCondition;
import com.gregtechceu.gtceu.common.recipe.EnvironmentalHazardCondition;
import com.gregtechceu.gtceu.common.recipe.PositionYCondition;
import com.gregtechceu.gtceu.common.recipe.RPMCondition;
import com.gregtechceu.gtceu.common.recipe.RainingCondition;
import com.gregtechceu.gtceu.common.recipe.ResearchCondition;
import com.gregtechceu.gtceu.common.recipe.ThunderCondition;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.CapabilityMap;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.ExtendedOutputItem;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.GTRecipeComponents;
import com.gregtechceu.gtceu.utils.ResearchManager;
import dev.architectury.fluid.FluidStack;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.fluid.InputFluid;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.BooleanComponent;
import dev.latvian.mods.kubejs.recipe.component.TimeComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GTRecipeSchema {
    public static final RecipeKey<ResourceLocation> ID = GTRecipeComponents.RESOURCE_LOCATION.key("id");
    public static final RecipeKey<Long> DURATION = TimeComponent.TICKS.key("duration").optional((Object)100L);
    public static final RecipeKey<CompoundTag> DATA = GTRecipeComponents.TAG.key("data").optional((Object)null);
    public static final RecipeKey<RecipeCondition[]> CONDITIONS = GTRecipeComponents.RECIPE_CONDITION.asArray().key("recipeConditions").defaultOptional();
    public static final RecipeKey<Boolean> IS_FUEL = BooleanComponent.BOOLEAN.key("isFuel").optional((Object)false);
    public static final RecipeKey<CapabilityMap> ALL_INPUTS = GTRecipeComponents.IN.key("inputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_TICK_INPUTS = GTRecipeComponents.TICK_IN.key("tickInputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_OUTPUTS = GTRecipeComponents.OUT.key("outputs").defaultOptional();
    public static final RecipeKey<CapabilityMap> ALL_TICK_OUTPUTS = GTRecipeComponents.TICK_OUT.key("tickOutputs").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> INPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("inputChanceLogics").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> OUTPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("outputChanceLogics").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> TICK_INPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("tickInputChanceLogics").defaultOptional();
    public static final RecipeKey<Map<RecipeCapability<?>, ChanceLogic>> TICK_OUTPUT_CHANCE_LOGICS = GTRecipeComponents.CHANCE_LOGIC_MAP.key("tickOutputChanceLogics").defaultOptional();
    public static final RecipeSchema SCHEMA = new RecipeSchema(GTRecipeJS.class, GTRecipeJS::new, new RecipeKey[]{DURATION, DATA, CONDITIONS, ALL_INPUTS, ALL_TICK_INPUTS, ALL_OUTPUTS, ALL_TICK_OUTPUTS, INPUT_CHANCE_LOGICS, OUTPUT_CHANCE_LOGICS, TICK_INPUT_CHANCE_LOGICS, TICK_OUTPUT_CHANCE_LOGICS, IS_FUEL}).constructor((recipe, schemaType, keys, from) -> recipe.id((ResourceLocation)from.getValue(recipe, ID)), new RecipeKey[]{ID}).constructor(new RecipeKey[]{DURATION, CONDITIONS, ALL_INPUTS, ALL_OUTPUTS, ALL_TICK_INPUTS, ALL_TICK_OUTPUTS});

    public static class GTRecipeJS
    extends RecipeJS {
        public boolean perTick;
        public int chance = ChanceLogic.getMaxChancedValue();
        public int maxChance = ChanceLogic.getMaxChancedValue();
        public int tierChanceBoost = 0;
        public boolean isFuel = false;
        private ResourceLocation idWithoutType;
        public Consumer<GTRecipeJS> onSave;
        private final Collection<GTRecipeBuilder.ResearchRecipeEntry> researchRecipeEntries = new ArrayList<GTRecipeBuilder.ResearchRecipeEntry>();
        private boolean generatingRecipes = true;

        @HideFromJS
        public GTRecipeJS id(ResourceLocation _id) {
            this.idWithoutType = new ResourceLocation(_id.m_135827_().equals("minecraft") ? this.type.id.m_135827_() : _id.m_135827_(), _id.m_135815_());
            this.id = new ResourceLocation(this.idWithoutType.m_135827_(), "%s/%s".formatted(this.type.id.m_135815_(), this.idWithoutType.m_135815_()));
            return this;
        }

        public <T> GTRecipeJS input(RecipeCapability<T> capability, Object ... obj) {
            CapabilityMap map;
            if (this.perTick) {
                if (this.getValue(ALL_TICK_INPUTS) == null) {
                    this.setValue(ALL_TICK_INPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_TICK_INPUTS);
            } else {
                if (this.getValue(ALL_INPUTS) == null) {
                    this.setValue(ALL_INPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_INPUTS);
            }
            if (map != null) {
                for (Object object : obj) {
                    map.add(capability, new Content(object, this.chance, this.maxChance, this.tierChanceBoost, null, null));
                }
            }
            this.save();
            return this;
        }

        public <T> GTRecipeJS output(RecipeCapability<T> capability, Object ... obj) {
            CapabilityMap map;
            if (this.perTick) {
                if (this.getValue(ALL_TICK_OUTPUTS) == null) {
                    this.setValue(ALL_TICK_OUTPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_TICK_OUTPUTS);
            } else {
                if (this.getValue(ALL_OUTPUTS) == null) {
                    this.setValue(ALL_OUTPUTS, new CapabilityMap());
                }
                map = (CapabilityMap)this.getValue(ALL_OUTPUTS);
            }
            if (map != null) {
                for (Object object : obj) {
                    map.add(capability, new Content(object, this.chance, this.maxChance, this.tierChanceBoost, null, null));
                }
            }
            this.save();
            return this;
        }

        public GTRecipeJS addCondition(RecipeCondition condition) {
            if (this.getValue(CONDITIONS) == null) {
                this.setValue(CONDITIONS, new RecipeCondition[0]);
            }
            this.setValue(CONDITIONS, (RecipeCondition[])ArrayUtils.add((Object[])((RecipeCondition[])this.getValue(CONDITIONS)), (Object)condition));
            this.save();
            return this;
        }

        public GTRecipeJS inputEU(long eu) {
            return this.input(EURecipeCapability.CAP, eu);
        }

        public GTRecipeJS EUt(long eu) {
            boolean lastPerTick = this.perTick;
            this.perTick = true;
            if (eu > 0L) {
                this.inputEU(eu);
            } else if (eu < 0L) {
                this.outputEU(-eu);
            }
            this.perTick = lastPerTick;
            return this;
        }

        public GTRecipeJS outputEU(long eu) {
            return this.output(EURecipeCapability.CAP, eu);
        }

        public GTRecipeJS inputCWU(int cwu) {
            return this.input(CWURecipeCapability.CAP, cwu);
        }

        public GTRecipeJS CWUt(int cwu) {
            boolean lastPerTick = this.perTick;
            this.perTick = true;
            if (cwu > 0) {
                this.inputCWU(cwu);
            } else if (cwu < 0) {
                this.outputCWU(cwu);
            }
            this.perTick = lastPerTick;
            return this;
        }

        public GTRecipeJS totalCWU(int cwu) {
            this.durationIsTotalCWU(true);
            this.hideDuration(true);
            this.setValue(DURATION, cwu);
            return this;
        }

        public GTRecipeJS outputCWU(int cwu) {
            return this.output(CWURecipeCapability.CAP, cwu);
        }

        public GTRecipeJS itemInputs(InputItem ... inputs) {
            return this.inputItems(inputs);
        }

        public GTRecipeJS itemInput(UnificationEntry input) {
            return this.inputItems(input);
        }

        public GTRecipeJS itemInput(UnificationEntry input, int count) {
            return this.inputItems(input, count);
        }

        public GTRecipeJS inputItems(InputItem ... inputs) {
            return this.input(ItemRecipeCapability.CAP, inputs);
        }

        public GTRecipeJS inputItems(ItemStack ... inputs) {
            for (ItemStack itemStack : inputs) {
                if (!itemStack.m_41619_()) continue;
                GTCEu.LOGGER.error("gt recipe {} input items is empty", (Object)this.id);
            }
            return this.input(ItemRecipeCapability.CAP, Arrays.stream(inputs).map(stack -> InputItem.of((Ingredient)SizedIngredient.create(stack.m_41782_() ? NBTIngredient.createNBTIngredient(stack) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), stack.m_41613_()), (int)stack.m_41613_())).toArray());
        }

        public GTRecipeJS inputItems(TagKey<Item> tag, int amount) {
            return this.inputItems(InputItem.of((Object)((Object)SizedIngredient.create(tag, amount))));
        }

        public GTRecipeJS inputItems(Item input, int amount) {
            return this.inputItems(new ItemStack((ItemLike)input, amount));
        }

        public GTRecipeJS inputItems(Item input) {
            return this.inputItems(InputItem.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (int)1));
        }

        public GTRecipeJS inputItems(Supplier<? extends Item> input) {
            return this.inputItems(InputItem.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)input.get()}), (int)1));
        }

        public GTRecipeJS inputItems(Supplier<? extends Item> input, int amount) {
            return this.inputItems(new ItemStack((ItemLike)input.get(), amount));
        }

        public GTRecipeJS inputItems(TagPrefix orePrefix, Material material) {
            return this.inputItems(orePrefix, material, 1);
        }

        public GTRecipeJS inputItems(UnificationEntry input) {
            return this.inputItems(input.tagPrefix, input.material, 1);
        }

        public GTRecipeJS inputItems(UnificationEntry input, int count) {
            return this.inputItems(input.tagPrefix, input.material, count);
        }

        public GTRecipeJS inputItems(TagPrefix orePrefix, Material material, int count) {
            return this.inputItems(ChemicalHelper.getTag(orePrefix, material), count);
        }

        public GTRecipeJS inputItems(MachineDefinition machine) {
            return this.inputItems(machine, 1);
        }

        public GTRecipeJS inputItems(MachineDefinition machine, int count) {
            return this.inputItems(machine.asStack(count));
        }

        public GTRecipeJS itemOutputs(ExtendedOutputItem ... outputs) {
            return this.outputItems(outputs);
        }

        public GTRecipeJS itemOutput(UnificationEntry unificationEntry) {
            return this.outputItems(unificationEntry.tagPrefix, unificationEntry.material);
        }

        public GTRecipeJS itemOutput(UnificationEntry unificationEntry, int count) {
            return this.outputItems(unificationEntry.tagPrefix, unificationEntry.material, count);
        }

        public GTRecipeJS outputItems(ExtendedOutputItem ... outputs) {
            for (ExtendedOutputItem itemStack : outputs) {
                if (!itemStack.isEmpty()) continue;
                GTCEu.LOGGER.error("gt recipe {} output items is empty", (Object)this.id);
            }
            return this.output(ItemRecipeCapability.CAP, (Object[])outputs);
        }

        public GTRecipeJS outputItems(Item input, int amount) {
            return this.outputItems(ExtendedOutputItem.of(new ItemStack((ItemLike)input, amount)));
        }

        public GTRecipeJS outputItems(Item input) {
            return this.outputItems(ExtendedOutputItem.of(new ItemStack((ItemLike)input)));
        }

        public GTRecipeJS outputItems(TagPrefix orePrefix, Material material) {
            return this.outputItems(orePrefix, material, 1);
        }

        public GTRecipeJS outputItems(TagPrefix orePrefix, Material material, int count) {
            return this.outputItems(ExtendedOutputItem.of(ChemicalHelper.get(orePrefix, material, count)));
        }

        public GTRecipeJS outputItems(MachineDefinition machine) {
            return this.outputItems(machine, 1);
        }

        public GTRecipeJS outputItems(MachineDefinition machine, int count) {
            return this.outputItems(new ExtendedOutputItem(machine.asStack(count)));
        }

        public GTRecipeJS itemOutputsRanged(ExtendedOutputItem ingredient, int min, int max) {
            return this.outputItemsRanged(ingredient.ingredient.getInner(), min, max);
        }

        public GTRecipeJS outputItemsRanged(Ingredient ingredient, int min, int max) {
            return this.output(ItemRecipeCapability.CAP, new Object[]{new IntProviderIngredient(ingredient, (IntProvider)UniformInt.m_146622_((int)min, (int)max))});
        }

        public GTRecipeJS outputItemsRanged(ItemStack stack, int min, int max) {
            return this.outputItemsRanged(Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), min, max);
        }

        public GTRecipeJS outputItemsRanged(TagPrefix orePrefix, Material material, int min, int max) {
            return this.outputItemsRanged(ChemicalHelper.get(orePrefix, material), min, max);
        }

        public GTRecipeJS notConsumable(InputItem itemStack) {
            int lastChance = this.chance;
            this.chance = 0;
            this.inputItems(itemStack);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS notConsumable(TagPrefix orePrefix, Material material) {
            int lastChance = this.chance;
            this.chance = 0;
            this.inputItems(orePrefix, material);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS notConsumableFluid(GTRecipeComponents.FluidIngredientJS fluid) {
            int lastChance = this.chance;
            this.chance = 0;
            this.inputFluids(fluid);
            this.chance = lastChance;
            return this;
        }

        public GTRecipeJS circuit(int configuration) {
            return this.notConsumable(InputItem.of((Ingredient)IntCircuitIngredient.circuitInput(configuration), (int)1));
        }

        public GTRecipeJS chancedInput(InputItem stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
                return this;
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.inputItems(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedFluidInput(GTRecipeComponents.FluidIngredientJS stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
                return this;
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.inputFluids(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(ExtendedOutputItem stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
                return this;
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.outputItems(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(TagPrefix tag, Material mat, int chance, int tierChanceBoost) {
            return this.chancedOutput(ExtendedOutputItem.of(ChemicalHelper.get(tag, mat)), chance, tierChanceBoost);
        }

        public GTRecipeJS chancedOutput(TagPrefix tag, Material mat, int count, int chance, int tierChanceBoost) {
            return this.chancedOutput(ExtendedOutputItem.of(ChemicalHelper.get(tag, mat, count)), chance, tierChanceBoost);
        }

        public GTRecipeJS chancedOutput(ExtendedOutputItem stack, String fraction, int tierChanceBoost) {
            int maxChance;
            int chance;
            if (stack.isEmpty()) {
                return this;
            }
            String[] split = fraction.split("/");
            if (split.length > 2) {
                GTCEu.LOGGER.error("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
                return this;
            }
            if (split.length == 1) {
                int chance2;
                try {
                    chance2 = (int)Double.parseDouble(split[0]);
                }
                catch (NumberFormatException e) {
                    GTCEu.LOGGER.error("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
                    return this;
                }
                return this.chancedOutput(stack, chance2, tierChanceBoost);
            }
            try {
                chance = Integer.parseInt(split[0]);
                maxChance = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                GTCEu.LOGGER.error("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
                return this;
            }
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
                return this;
            }
            if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Max Chance cannot be less or equal to Chance or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), maxChance, new Throwable()});
                return this;
            }
            int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
            int lastChance = this.chance;
            int lastMaxChance = this.maxChance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance *= scalar;
            this.maxChance = maxChance *= scalar;
            this.tierChanceBoost = tierChanceBoost;
            this.outputItems(stack);
            this.chance = lastChance;
            this.maxChance = lastMaxChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutput(TagPrefix prefix, Material material, int count, String fraction, int tierChanceBoost) {
            return this.chancedOutput(ExtendedOutputItem.of(ChemicalHelper.get(prefix, material, count)), fraction, tierChanceBoost);
        }

        public GTRecipeJS chancedOutput(TagPrefix prefix, Material material, String fraction, int tierChanceBoost) {
            return this.chancedOutput(prefix, material, 1, fraction, tierChanceBoost);
        }

        public GTRecipeJS chancedFluidOutput(FluidStackJS stack, int chance, int tierChanceBoost) {
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
                return this;
            }
            int lastChance = this.chance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance;
            this.tierChanceBoost = tierChanceBoost;
            this.outputFluids(stack);
            this.chance = lastChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedFluidOutput(FluidStackJS stack, String fraction, int tierChanceBoost) {
            int maxChance;
            int chance;
            if (stack.getAmount() == 0L) {
                return this;
            }
            String[] split = fraction.split("/");
            if (split.length > 2) {
                GTCEu.LOGGER.error("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
                return this;
            }
            if (split.length == 1) {
                int chance2;
                try {
                    chance2 = (int)Double.parseDouble(split[0]);
                }
                catch (NumberFormatException e) {
                    GTCEu.LOGGER.error("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
                    return this;
                }
                return this.chancedFluidOutput(stack, chance2, tierChanceBoost);
            }
            try {
                chance = Integer.parseInt(split[0]);
                maxChance = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                GTCEu.LOGGER.error("Fraction or number was not parsed correctly! Expected format is \"1/3\" or \"1000\". Actual: \"{}\".", (Object)fraction, (Object)new Throwable());
                return this;
            }
            if (0 >= chance || chance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Chance cannot be less or equal to 0 or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), chance, new Throwable()});
                return this;
            }
            if (chance >= maxChance || maxChance > ChanceLogic.getMaxChancedValue()) {
                GTCEu.LOGGER.error("Max Chance cannot be less or equal to Chance or more than {}. Actual: {}.", new Object[]{ChanceLogic.getMaxChancedValue(), maxChance, new Throwable()});
                return this;
            }
            int scalar = Math.floorDiv(ChanceLogic.getMaxChancedValue(), maxChance);
            int lastChance = this.chance;
            int lastMaxChance = this.maxChance;
            int lastTierChanceBoost = this.tierChanceBoost;
            this.chance = chance *= scalar;
            this.maxChance = maxChance *= scalar;
            this.tierChanceBoost = tierChanceBoost;
            this.outputFluids(stack);
            this.chance = lastChance;
            this.maxChance = lastMaxChance;
            this.tierChanceBoost = lastTierChanceBoost;
            return this;
        }

        public GTRecipeJS chancedOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(OUTPUT_CHANCE_LOGICS) == null) {
                this.setValue(OUTPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(OUTPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS chancedItemOutputLogic(ChanceLogic logic) {
            return this.chancedOutputLogic(ItemRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedFluidOutputLogic(ChanceLogic logic) {
            return this.chancedOutputLogic(FluidRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(INPUT_CHANCE_LOGICS) == null) {
                this.setValue(INPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(INPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS chancedItemInputLogic(ChanceLogic logic) {
            return this.chancedInputLogic(ItemRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedFluidInputLogic(ChanceLogic logic) {
            return this.chancedInputLogic(FluidRecipeCapability.CAP, logic);
        }

        public GTRecipeJS chancedTickOutputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(TICK_OUTPUT_CHANCE_LOGICS) == null) {
                this.setValue(TICK_OUTPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(TICK_OUTPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS chancedTickInputLogic(RecipeCapability<?> cap, ChanceLogic logic) {
            if (this.getValue(TICK_INPUT_CHANCE_LOGICS) == null) {
                this.setValue(TICK_INPUT_CHANCE_LOGICS, new HashMap());
            }
            ((Map)this.getValue(TICK_INPUT_CHANCE_LOGICS)).put(cap, logic);
            this.save();
            return this;
        }

        public GTRecipeJS inputFluids(GTRecipeComponents.FluidIngredientJS ... inputs) {
            return this.input(FluidRecipeCapability.CAP, inputs);
        }

        public GTRecipeJS outputFluids(FluidStackJS ... outputs) {
            return this.output(FluidRecipeCapability.CAP, outputs);
        }

        public GTRecipeJS inputStress(float stress) {
            return this.input(StressRecipeCapability.CAP, Float.valueOf(stress));
        }

        public GTRecipeJS outputStress(float stress) {
            return this.output(StressRecipeCapability.CAP, Float.valueOf(stress));
        }

        public GTRecipeJS addData(String key, Tag data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).m_128365_(key, data);
            this.save();
            return this;
        }

        @HideFromJS
        public GTRecipeJS addData(String key, int data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).m_128405_(key, data);
            this.save();
            return this;
        }

        @HideFromJS
        public GTRecipeJS addData(String key, long data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).m_128356_(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addDataString(String key, String data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).m_128359_(key, data);
            this.save();
            return this;
        }

        @HideFromJS
        public GTRecipeJS addData(String key, float data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).m_128350_(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addDataNumber(String key, double data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).m_128347_(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS addDataBool(String key, boolean data) {
            if (this.getValue(DATA) == null) {
                this.setValue(DATA, new CompoundTag());
            }
            ((CompoundTag)this.getValue(DATA)).m_128379_(key, data);
            this.save();
            return this;
        }

        public GTRecipeJS blastFurnaceTemp(int blastTemp) {
            return this.addData("ebf_temp", blastTemp);
        }

        public GTRecipeJS explosivesAmount(int explosivesAmount) {
            return this.addData("explosives_amount", explosivesAmount);
        }

        public GTRecipeJS explosivesType(ItemStack explosivesType) {
            return this.addData("explosives_type", (Tag)explosivesType.m_41739_(new CompoundTag()));
        }

        public GTRecipeJS solderMultiplier(int multiplier) {
            return this.addData("solder_multiplier", multiplier);
        }

        public GTRecipeJS disableDistilleryRecipes(boolean flag) {
            return this.addDataBool("disable_distillery", flag);
        }

        public GTRecipeJS fusionStartEU(long eu) {
            return this.addData("eu_to_start", eu);
        }

        public GTRecipeJS researchScan(boolean isScan) {
            return this.addDataBool("scan_for_research", isScan);
        }

        public GTRecipeJS durationIsTotalCWU(boolean durationIsTotalCWU) {
            return this.addDataBool("duration_is_total_cwu", durationIsTotalCWU);
        }

        public GTRecipeJS hideDuration(boolean hideDuration) {
            return this.addDataBool("hide_duration", hideDuration);
        }

        public GTRecipeJS cleanroom(CleanroomType cleanroomType) {
            return this.addCondition(new CleanroomCondition(cleanroomType));
        }

        public GTRecipeJS dimension(ResourceLocation dimension, boolean reverse) {
            return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
        }

        public GTRecipeJS dimension(ResourceLocation dimension) {
            return this.dimension(dimension, false);
        }

        public GTRecipeJS biome(ResourceLocation biome, boolean reverse) {
            return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
        }

        public GTRecipeJS biome(ResourceLocation biome) {
            return this.biome(biome, false);
        }

        public GTRecipeJS rain(float level, boolean reverse) {
            return this.addCondition(new RainingCondition(level).setReverse(reverse));
        }

        public GTRecipeJS rain(float level) {
            return this.rain(level, false);
        }

        public GTRecipeJS thunder(float level, boolean reverse) {
            return this.addCondition(new ThunderCondition(level).setReverse(reverse));
        }

        public GTRecipeJS thunder(float level) {
            return this.thunder(level, false);
        }

        public GTRecipeJS posY(int min, int max, boolean reverse) {
            return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
        }

        public GTRecipeJS posY(int min, int max) {
            return this.posY(min, max, false);
        }

        public GTRecipeJS rpm(float rpm, boolean reverse) {
            return this.addCondition(new RPMCondition(rpm).setReverse(reverse));
        }

        public GTRecipeJS rpm(float rpm) {
            return this.rpm(rpm, false);
        }

        public GTRecipeJS environmentalHazard(MedicalCondition condition, boolean reverse) {
            return this.addCondition(new EnvironmentalHazardCondition(condition).setReverse(reverse));
        }

        public GTRecipeJS environmentalHazard(MedicalCondition condition) {
            return this.environmentalHazard(condition, false);
        }

        private boolean applyResearchProperty(ResearchData.ResearchEntry researchEntry) {
            if (!ConfigHolder.INSTANCE.machines.enableResearch) {
                return false;
            }
            if (researchEntry == null) {
                GTCEu.LOGGER.error("Assembly Line Research Entry cannot be empty.", (Throwable)new IllegalArgumentException());
                return false;
            }
            if (!this.generatingRecipes) {
                GTCEu.LOGGER.error("Cannot generate recipes when using researchWithoutRecipe()", (Throwable)new IllegalArgumentException());
                return false;
            }
            if (this.getValue(CONDITIONS) == null) {
                this.setValue(CONDITIONS, new RecipeCondition[0]);
            }
            ResearchCondition condition = Arrays.stream((RecipeCondition[])this.getValue(CONDITIONS)).filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
            if (condition != null) {
                condition.data.add(researchEntry);
            } else {
                condition = new ResearchCondition();
                condition.data.add(researchEntry);
                this.addCondition(condition);
            }
            return true;
        }

        public GTRecipeJS researchWithoutRecipe(@NotNull String researchId) {
            return this.researchWithoutRecipe(researchId, ResearchManager.getDefaultScannerItem());
        }

        public GTRecipeJS researchWithoutRecipe(@NotNull String researchId, @NotNull ItemStack dataStack) {
            this.applyResearchProperty(new ResearchData.ResearchEntry(researchId, dataStack));
            this.generatingRecipes = false;
            return this;
        }

        public GTRecipeJS scannerResearch(UnaryOperator<ResearchRecipeBuilder.ScannerRecipeBuilder> research) {
            GTRecipeBuilder.ResearchRecipeEntry entry = ((ResearchRecipeBuilder.ScannerRecipeBuilder)research.apply(new ResearchRecipeBuilder.ScannerRecipeBuilder())).build();
            if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId(), entry.dataStack()))) {
                this.researchRecipeEntries.add(entry);
            }
            return this;
        }

        public GTRecipeJS scannerResearch(@NotNull ItemStack researchStack) {
            return this.scannerResearch(b -> (ResearchRecipeBuilder.ScannerRecipeBuilder)b.researchStack(researchStack));
        }

        public GTRecipeJS stationResearch(UnaryOperator<ResearchRecipeBuilder.StationRecipeBuilder> research) {
            GTRecipeBuilder.ResearchRecipeEntry entry = ((ResearchRecipeBuilder.StationRecipeBuilder)research.apply(new ResearchRecipeBuilder.StationRecipeBuilder())).build();
            if (this.applyResearchProperty(new ResearchData.ResearchEntry(entry.researchId(), entry.dataStack()))) {
                this.researchRecipeEntries.add(entry);
            }
            return this;
        }

        @Nullable
        public Recipe<?> createRecipe() {
            if (this.onSave != null) {
                this.onSave.accept(this);
            }
            return super.createRecipe();
        }

        public InputItem readInputItem(Object from) {
            if (from instanceof SizedIngredient) {
                SizedIngredient ingr = (SizedIngredient)((Object)from);
                return InputItem.of((Ingredient)ingr.getInner(), (int)ingr.getAmount());
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                if (!jsonObject.has("type") || !jsonObject.get("type").getAsString().equals(SizedIngredient.TYPE.toString())) {
                    return InputItem.of((Object)from);
                }
                SizedIngredient sizedIngredient = SizedIngredient.fromJson(jsonObject);
                return InputItem.of((Ingredient)sizedIngredient.getInner(), (int)sizedIngredient.getAmount());
            }
            return InputItem.of((Object)from);
        }

        public JsonElement writeInputItem(InputItem value) {
            return SizedIngredient.create(value.ingredient, value.count).m_43942_();
        }

        public OutputItem readOutputItem(Object from) {
            if (from instanceof ExtendedOutputItem) {
                ExtendedOutputItem outputItem = (ExtendedOutputItem)((Object)from);
                return outputItem;
            }
            if (from instanceof OutputItem) {
                OutputItem outputItem = (OutputItem)from;
                return outputItem;
            }
            if (from instanceof SizedIngredient) {
                SizedIngredient ingredient = (SizedIngredient)((Object)from);
                Ingredient ingredient2 = ingredient.getInner();
                if (ingredient2 instanceof IntProviderIngredient) {
                    IntProviderIngredient intProvider = (IntProviderIngredient)ingredient2;
                    return new ExtendedOutputItem(intProvider, 1);
                }
                return OutputItem.of((ItemStack)ingredient.getInner().m_43908_()[0], (double)Double.NaN);
            }
            if (from instanceof IntProviderIngredient) {
                IntProviderIngredient ingredient = (IntProviderIngredient)((Object)from);
                return new ExtendedOutputItem(ingredient, 1);
            }
            if (from instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)from;
                float chance = 1.0f;
                if (jsonObject.has("chance")) {
                    chance = jsonObject.get("chance").getAsFloat();
                }
                if (jsonObject.has("content")) {
                    jsonObject = jsonObject.getAsJsonObject("content");
                }
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonObject);
                return OutputItem.of((ItemStack)ingredient.m_43908_()[0], (double)chance);
            }
            return OutputItem.of((Object)from);
        }

        public JsonElement writeOutputItem(OutputItem value) {
            if (value instanceof ExtendedOutputItem) {
                ExtendedOutputItem extended = (ExtendedOutputItem)value;
                Ingredient ingredient = extended.ingredient.getInner();
                if (ingredient instanceof IntProviderIngredient) {
                    IntProviderIngredient intProvider = (IntProviderIngredient)ingredient;
                    return intProvider.m_43942_();
                }
                return extended.ingredient.m_43942_();
            }
            return SizedIngredient.create(value.item).m_43942_();
        }

        public JsonElement writeInputFluid(InputFluid value) {
            FluidStack fluid = ((FluidStackJS)value).getFluidStack();
            return FluidIngredient.of(fluid.getAmount(), fluid.getFluid()).toJson();
        }

        public InputFluid readInputFluid(Object from) {
            return super.readInputFluid(from);
        }

        public GTRecipeJS perTick(boolean perTick) {
            this.perTick = perTick;
            return this;
        }

        public GTRecipeJS chance(int chance) {
            this.chance = chance;
            return this;
        }

        public GTRecipeJS maxChance(int maxChance) {
            this.maxChance = maxChance;
            return this;
        }

        public GTRecipeJS tierChanceBoost(int tierChanceBoost) {
            this.tierChanceBoost = tierChanceBoost;
            return this;
        }

        public GTRecipeJS isFuel(boolean isFuel) {
            this.isFuel = isFuel;
            return this;
        }

        public ResourceLocation idWithoutType() {
            return this.idWithoutType;
        }

        public GTRecipeJS onSave(Consumer<GTRecipeJS> onSave) {
            this.onSave = onSave;
            return this;
        }

        public Collection<GTRecipeBuilder.ResearchRecipeEntry> researchRecipeEntries() {
            return this.researchRecipeEntries;
        }
    }
}

