/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jei.recipe;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeWrapper;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.jei.ModularUIRecipeCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTRecipeTypeCategory
extends ModularUIRecipeCategory<GTRecipeWrapper> {
    public static final Function<GTRecipeType, RecipeType<GTRecipeWrapper>> TYPES = Util.m_143827_(recipeMap -> new RecipeType(recipeMap.registryName, GTRecipeWrapper.class));
    private final GTRecipeType recipeType;
    private final IDrawable background;
    private final IDrawable icon;

    public GTRecipeTypeCategory(IJeiHelpers helpers, GTRecipeType recipeType) {
        this.recipeType = recipeType;
        IGuiHelper guiHelper = helpers.getGuiHelper();
        Size size = recipeType.getRecipeUI().getJEISize();
        this.background = guiHelper.createBlankDrawable(size.width, size.height);
        this.icon = recipeType.getIconSupplier() != null ? helpers.getGuiHelper().createDrawableItemStack(recipeType.getIconSupplier().get()) : helpers.getGuiHelper().createDrawableItemStack(Items.f_42127_.m_7968_());
    }

    @NotNull
    public RecipeType<GTRecipeWrapper> getRecipeType() {
        return TYPES.apply(this.recipeType);
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)this.recipeType.registryName.m_214298_());
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        for (net.minecraft.world.item.crafting.RecipeType recipeType : BuiltInRegistries.f_256990_) {
            List<GTRecipe> scannerRecipes;
            if (!(recipeType instanceof GTRecipeType)) continue;
            GTRecipeType gtRecipeType = (GTRecipeType)recipeType;
            if (!Platform.isDevEnv() && !gtRecipeType.getRecipeUI().isXEIVisible()) continue;
            registration.addRecipes(TYPES.apply(gtRecipeType), Minecraft.m_91087_().m_91403_().m_105141_().m_44013_((net.minecraft.world.item.crafting.RecipeType)gtRecipeType).stream().map(GTRecipeWrapper::new).collect(Collectors.toList()));
            if (!gtRecipeType.isScanner() || (scannerRecipes = gtRecipeType.getRepresentativeRecipes()).isEmpty()) continue;
            registration.addRecipes(TYPES.apply(gtRecipeType), scannerRecipes.stream().map(GTRecipeWrapper::new).collect(Collectors.toList()));
        }
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (GTRecipeType gtRecipeType : GTRegistries.RECIPE_TYPES) {
            if (!Platform.isDevEnv() && !gtRecipeType.getRecipeUI().isXEIVisible()) continue;
            for (MachineDefinition machine : GTRegistries.MACHINES) {
                if (machine.getRecipeTypes() == null) continue;
                for (GTRecipeType type : machine.getRecipeTypes()) {
                    if (type != gtRecipeType) continue;
                    registration.addRecipeCatalyst(machine.asStack(), new RecipeType[]{TYPES.apply(gtRecipeType)});
                }
            }
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(@NotNull GTRecipeWrapper wrapper) {
        return wrapper.recipe.id;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

