/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.utils;

import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.utils.GTMath;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class AEUtil {
    @Nullable
    public static GenericStack fromFluidStack(FluidStack stack) {
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        AEFluidKey key = AEFluidKey.of((Fluid)stack.getFluid(), (CompoundTag)stack.getTag());
        return new GenericStack((AEKey)key, stack.getAmount());
    }

    public static FluidStack toFluidStack(GenericStack stack) {
        AEKey key = stack.what();
        if (key instanceof AEFluidKey) {
            AEFluidKey fluidKey = (AEFluidKey)key;
            return AEUtil.toFluidStack(fluidKey, stack.amount());
        }
        return FluidStack.empty();
    }

    public static FluidStack toFluidStack(AEFluidKey key, long amount) {
        return FluidStack.create((Fluid)key.getFluid(), (long)amount, (CompoundTag)key.getTag());
    }

    public static ItemStack[] toItemStacks(GenericStack stack) {
        AEKey key = stack.what();
        if (key instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)key;
            return AEUtil.toItemStacks(itemKey, stack.amount());
        }
        return new ItemStack[0];
    }

    public static ItemStack[] toItemStacks(AEItemKey key, long amount) {
        int[] ints = GTMath.split(amount);
        ItemStack[] itemStacks = new ItemStack[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            itemStacks[i] = key.toStack(ints[i]);
        }
        return itemStacks;
    }

    public static boolean matches(AEFluidKey key, FluidStack stack) {
        return !stack.isEmpty() && key.getFluid().m_6212_(stack.getFluid()) && Objects.equals(key.getTag(), stack.getTag());
    }
}

