/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.slot;

import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAESlot;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.mojang.datafixers.util.Pair;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ExportOnlyAEItemSlot
extends ExportOnlyAESlot
implements IItemTransfer {
    public ExportOnlyAEItemSlot() {
    }

    public ExportOnlyAEItemSlot(@Nullable GenericStack config, @Nullable GenericStack stock) {
        super(config, stock);
    }

    @Override
    public void addStack(GenericStack stack) {
        this.stock = this.stock == null ? stack : GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
        this.onContentsChanged();
    }

    @Override
    public void setStock(@Nullable GenericStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        if (stack == null) {
            this.stock = null;
        } else {
            if (stack.equals((Object)this.stock)) {
                return;
            }
            this.stock = stack;
        }
        this.onContentsChanged();
    }

    public int getSlots() {
        return 1;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0 && this.stock != null) {
            ItemStack itemStack;
            AEKey aEKey = this.stock.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                itemStack = itemKey.toStack((int)this.stock.amount());
            } else {
                itemStack = ItemStack.f_41583_;
            }
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, boolean notifyChanges) {
        return stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        if (slot == 0 && this.stock != null) {
            ItemStack itemStack;
            int extracted = (int)Math.min(this.stock.amount(), (long)amount);
            AEKey aEKey = this.stock.what();
            if (aEKey instanceof AEItemKey) {
                AEItemKey itemKey = (AEItemKey)aEKey;
                itemStack = itemKey.toStack((int)this.stock.amount());
            } else {
                itemStack = ItemStack.f_41583_.m_41777_();
            }
            ItemStack result = itemStack;
            result.m_41764_(extracted);
            if (!simulate) {
                this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - (long)extracted);
                if (this.stock.amount() == 0L) {
                    this.stock = null;
                }
            }
            if (notifyChanges) {
                this.onContentsChanged();
            }
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void onContentsChanged() {
        if (this.onContentsChanged != null) {
            this.onContentsChanged.run();
        }
    }

    @Override
    public ExportOnlyAEItemSlot copy() {
        return new ExportOnlyAEItemSlot(this.config == null ? null : ExportOnlyAEItemSlot.copy(this.config), this.stock == null ? null : ExportOnlyAEItemSlot.copy(this.stock));
    }

    @Deprecated
    @NotNull
    public Object createSnapshot() {
        return Pair.of((Object)this.config, (Object)this.stock);
    }

    @Deprecated
    public void restoreFromSnapshot(Object snapshot) {
        if (snapshot instanceof Pair) {
            Pair pair = (Pair)snapshot;
            this.config = (GenericStack)pair.getFirst();
            this.stock = (GenericStack)pair.getSecond();
        }
    }
}

