/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.slot;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAEItemSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlotList;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportOnlyAEItemList
extends NotifiableItemStackHandler
implements IConfigurableSlotList {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ExportOnlyAEItemList.class, NotifiableItemStackHandler.MANAGED_FIELD_HOLDER);
    @Persisted
    protected ExportOnlyAEItemSlot[] inventory;
    private ItemStackTransfer itemTransfer;

    public ExportOnlyAEItemList(MetaMachine holder, int slots) {
        this(holder, slots, ExportOnlyAEItemSlot::new);
    }

    public ExportOnlyAEItemList(MetaMachine holder, int slots, Supplier<ExportOnlyAEItemSlot> slotFactory) {
        super(holder, 0, IO.IN);
        this.inventory = new ExportOnlyAEItemSlot[slots];
        for (int i = 0; i < slots; ++i) {
            this.inventory[i] = slotFactory.get();
        }
        for (ExportOnlyAEItemSlot slot : this.inventory) {
            slot.setOnContentsChanged(this::onContentsChanged);
        }
    }

    public ItemStackTransfer getTransfer() {
        if (this.itemTransfer == null) {
            this.itemTransfer = new ItemStackTransferDelegate(this.inventory);
        }
        return this.itemTransfer;
    }

    @Override
    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSlots() {
        return this.inventory.length;
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.inventory.length) {
            return this.inventory[slot].getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= 0 && slot < this.inventory.length) {
            return this.inventory[slot].extractItem(0, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
        return ExportOnlyAEItemList.handleIngredient(io, recipe, left, simulate, this.handlerIO, this.getTransfer());
    }

    @Override
    public IConfigurableSlot getConfigurableSlot(int index) {
        return this.inventory[index];
    }

    @Override
    public int getConfigurableSlots() {
        return this.inventory.length;
    }

    public boolean isAutoPull() {
        return false;
    }

    public boolean isStocking() {
        return false;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ExportOnlyAEItemSlot[] getInventory() {
        return this.inventory;
    }

    private static class ItemStackTransferDelegate
    extends ItemStackTransfer {
        private final ExportOnlyAEItemSlot[] inventory;

        public ItemStackTransferDelegate(ExportOnlyAEItemSlot[] inventory) {
            this.inventory = inventory;
        }

        public int getSlots() {
            return this.inventory.length;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inventory[slot].getStackInSlot(0);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate, boolean notifyChanges) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            this.validateSlotIndex(slot);
            return this.inventory[slot].extractItem(0, amount, simulate);
        }

        protected void validateSlotIndex(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
            }
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        public ItemStackTransfer copy() {
            return new ItemStackTransferDelegate(this.inventory){

                @Override
                public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
                    return super.extractItem(slot, amount, true, notifyChanges);
                }
            };
        }
    }
}

